/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iglobals.h"
#include "ivtkwindow.h"

#include "ivtk.h"
#include "iparticles.h"
#include "isurface.h"
#include "itensor.h"
#include "ivector.h"
#include "ivolume.h"
#include "ixsection.h"
#include "ilimits.h"
#include "ivolumedataconverter.h"
#include "ipolygonaldataextender.h"
#include "iuniformmeshdataextender.h"
#include "idatareader.h"

#include <vtkPolyDataMapper.h>
#include <vtkLookupTable.h>


void reportNullPointer(int);


iFamily<iVTK> *iVTKWindow::fam = 0;


void iVTKWindow::construct()
{
	if(fam == 0)
	{
		fam = new iFamily<iVTK>;
		if(fam == 0) reportNullPointer(2601);
	}
}


void iVTKWindow::destruct()
{
	if(fam != 0) delete fam;
}


int iVTKWindow::createWindow() 
{ 
	int i = fam->createMember(); 
	if(i != -1) fam->getMember(i)->setWindowNumber(i);
	if(fam->getMaxMemberIndex() == 1) fam->getMember(0)->setWindowNumber(0);
	return i;
}


bool iVTKWindow::deleteWindow(int i)
{
	bool ret = fam->deleteMember(i);
	if(ret)
	{
		int j;
		for(j=i; j<=fam->getMaxMemberIndex(); j++) fam->getMember(j)->setWindowNumber(j);
		if(fam->getMaxMemberIndex() == 0) fam->getMember(0)->setWindowNumber(-1);
	}
	return ret;
}


void iVTKWindow::setCurrentWindowIndex(int i)
{ 
	fam->setCurrentMemberIndex(i); 
	fam->getCurrentMember()->MakeCurrent();
}


void iVTKWindow::setEnabled(bool s)
{ 
	int i;
	for(i=0; i<=fam->getMaxMemberIndex(); i++) fam->getMember(i)->setEnabled(s);
}


void iVTKWindow::broadcastVariableLimitsChange(int dataChannel, int var, int address)
{
	int i,k;
	//
	//  Update the whole clone family
	//  Updating of individual iVisualObject families is not implemented
	//
	for(k=0; k<=fam->getMaxMemberIndex(); k++) if(fam->getMember(k)->getReader() == fam->getCurrentMember()->getReader())
	{
		
		if(address==IVTKWINDOW_BROADCASTADDRESS_ALL || address==IVTKWINDOW_BROADCASTADDRESS_SURF)
		{
			for(i=0; i<=fam->getMember(k)->getSurfaceFamily()->getMaxMemberIndex(); i++) if(fam->getMember(k)->getSurfaceFamily()->getMember(i)->getDataChannel() == dataChannel)
			{
				iSurface *s = fam->getMember(k)->getSurfaceFamily()->getMember(i);
				if(var==-1 || s->getVarPaint(false)==var) 
				{
					s->getMapper()->SetScalarRange(fam->getCurrentMember()->getReader()->getLimits(dataChannel)->getVarLow(s->getVarPaint(false)),fam->getCurrentMember()->getReader()->getLimits(dataChannel)->getVarHigh(s->getVarPaint(false)));
				}
				if(var==-1 || s->getVarPaint(true)==var) 
				{
					s->getMapper(1)->SetScalarRange(fam->getCurrentMember()->getReader()->getLimits(dataChannel)->getVarLow(s->getVarPaint(true)),fam->getCurrentMember()->getReader()->getLimits(dataChannel)->getVarHigh(s->getVarPaint(true)));
				}
			}
		}
		
		if(address==IVTKWINDOW_BROADCASTADDRESS_ALL || address==IVTKWINDOW_BROADCASTADDRESS_XSEC)
		{
			for(i=0; i<=fam->getMember(k)->getXsectionFamily()->getMaxMemberIndex(); i++) if(fam->getMember(k)->getXsectionFamily()->getMember(i)->getDataChannel() == dataChannel)
			{
				iXsection *s = fam->getMember(k)->getXsectionFamily()->getMember(i);
				if(var==-1 || s->getVar()==var) 
				{
					s->getMapper()->SetScalarRange(fam->getCurrentMember()->getReader()->getLimits(dataChannel)->getVarLow(s->getVar()),fam->getCurrentMember()->getReader()->getLimits(dataChannel)->getVarHigh(s->getVar()));
					s->getColorLookupTable()->SetTableRange(fam->getCurrentMember()->getReader()->getLimits(dataChannel)->getVarLow(s->getVar()),fam->getCurrentMember()->getReader()->getLimits(dataChannel)->getVarHigh(s->getVar()));
				}
			}
		}
		
		if(address==IVTKWINDOW_BROADCASTADDRESS_ALL || address==IVTKWINDOW_BROADCASTADDRESS_VOLV)
		{
			for(i=0; i<=fam->getMember(k)->getVolumeFamily()->getMaxMemberIndex(); i++) if(fam->getMember(k)->getVolumeFamily()->getMember(i)->getDataChannel() == dataChannel)
			{
				iVolume *s = fam->getMember(k)->getVolumeFamily()->getMember(i);
				if(var==-1 || s->getVar()==var) 
				{
					s->getConverter()->Modified();
				}
			}
		}
		
		if(address==IVTKWINDOW_BROADCASTADDRESS_ALL || address==IVTKWINDOW_BROADCASTADDRESS_VECT)
		{
			for(i=0; i<=fam->getMember(k)->getVectorFamily()->getMaxMemberIndex(); i++) if(fam->getMember(k)->getVectorFamily()->getMember(i)->getDataChannel() == dataChannel)
			{
				iVector *s = fam->getMember(k)->getVectorFamily()->getMember(i);
				if(var==-1 || s->getColorBy()-3==var) 
				{
					s->getMapper()->SetScalarRange(fam->getCurrentMember()->getReader()->getLimits(dataChannel)->getVarLow(s->getColorBy()-3),fam->getCurrentMember()->getReader()->getLimits(dataChannel)->getVarHigh(s->getColorBy()-3));
				}
			}
		}
		
		if(address==IVTKWINDOW_BROADCASTADDRESS_ALL || address==IVTKWINDOW_BROADCASTADDRESS_TENS)
		{
			for(i=0; i<=fam->getMember(k)->getTensorFamily()->getMaxMemberIndex(); i++) if(fam->getMember(k)->getTensorFamily()->getMember(i)->getDataChannel() == dataChannel)
			{
				iTensor *s = fam->getMember(k)->getTensorFamily()->getMember(i);
				if(var==-1 || s->getColorBy()==var) 
				{
					s->getMapper()->SetScalarRange(fam->getCurrentMember()->getReader()->getLimits(dataChannel)->getVarLow(s->getColorBy()-3),fam->getCurrentMember()->getReader()->getLimits(dataChannel)->getVarHigh(s->getColorBy()-3));
				}
			}
		}
		
	}

}


void iVTKWindow::broadcastExtentSettingsChange(int dataChannel, bool ext, int address)
{
	int i,k;
	//
	//  Update the whole clone family
	//  Updating of individual iVisualObject families is possible
	//
	for(k=0; k<=fam->getMaxMemberIndex(); k++) if(fam->getMember(k)->getReader() == fam->getCurrentMember()->getReader())
	{

		if(address==IVTKWINDOW_BROADCASTADDRESS_ALL	|| address==IVTKWINDOW_BROADCASTADDRESS_SURF || (address==IVTKWINDOW_BROADCASTADDRESS_EXT && fam->getCurrentMember()->getReader()->getLimits(fam->getCurrentMember()->getReader()->getCurrentDataChannel())->isExtendSurf()))
		{
			if(address != IVTKWINDOW_BROADCASTADDRESS_EXT) fam->getCurrentMember()->getReader()->getLimits(dataChannel)->setExtendSurf(ext);
			for(i=0; i<=fam->getCurrentMember()->getSurfaceFamily()->getMaxMemberIndex(); i++) if(fam->getCurrentMember()->getSurfaceFamily()->getMember(i)->getDataChannel() == dataChannel)
			{
				iSurface *ss = fam->getCurrentMember()->getSurfaceFamily()->getMember(i);
				if(address != IVTKWINDOW_BROADCASTADDRESS_EXT) ss->getExtender()->setActive(ext);
				ss->getExtender()->Modified();
				if(ss->getVarPaint(true) > 0)
				{
					if(address != IVTKWINDOW_BROADCASTADDRESS_EXT) ss->getExtender(1)->setActive(ext);
					ss->getExtender(1)->Modified();
				}
			}
		}

		if(address==IVTKWINDOW_BROADCASTADDRESS_ALL	|| address==IVTKWINDOW_BROADCASTADDRESS_VOLV || (address==IVTKWINDOW_BROADCASTADDRESS_EXT && fam->getCurrentMember()->getReader()->getLimits(fam->getCurrentMember()->getReader()->getCurrentDataChannel())->isExtendVolv()))
		{
			if(address != IVTKWINDOW_BROADCASTADDRESS_EXT) fam->getCurrentMember()->getReader()->getLimits(dataChannel)->setExtendVolv(ext);
			for(i=0; i<=fam->getCurrentMember()->getVolumeFamily()->getMaxMemberIndex(); i++) if(fam->getCurrentMember()->getVolumeFamily()->getMember(i)->getDataChannel() == dataChannel)
			{
				iVolume *ss = fam->getCurrentMember()->getVolumeFamily()->getMember(i);
				if(address != IVTKWINDOW_BROADCASTADDRESS_EXT) ss->getExtender()->setActive(ext);
				ss->getExtender()->Modified();
			}
		}
		
		if(address==IVTKWINDOW_BROADCASTADDRESS_ALL	|| address==IVTKWINDOW_BROADCASTADDRESS_PART || (address==IVTKWINDOW_BROADCASTADDRESS_EXT && fam->getCurrentMember()->getReader()->getLimits(fam->getCurrentMember()->getReader()->getCurrentDataChannel())->isExtendPart()))
		{
			if(address != IVTKWINDOW_BROADCASTADDRESS_EXT) fam->getCurrentMember()->getReader()->getLimits(dataChannel)->setExtendPart(ext);
			for(i=0; i<=fam->getCurrentMember()->getParticlesFamily()->getMaxMemberIndex(); i++) if(fam->getCurrentMember()->getParticlesFamily()->getMember(i)->getDataChannel() == dataChannel)
			{
				iParticles *ss = fam->getCurrentMember()->getParticlesFamily()->getMember(i);
				if(address != IVTKWINDOW_BROADCASTADDRESS_EXT) ss->getExtender()->setActive(ext);
				ss->getExtender()->Modified();
			}
		}
		
		if(address==IVTKWINDOW_BROADCASTADDRESS_ALL	|| address==IVTKWINDOW_BROADCASTADDRESS_VECT || (address==IVTKWINDOW_BROADCASTADDRESS_EXT && fam->getCurrentMember()->getReader()->getLimits(fam->getCurrentMember()->getReader()->getCurrentDataChannel())->isExtendVect()))
		{
			if(address != IVTKWINDOW_BROADCASTADDRESS_EXT) fam->getCurrentMember()->getReader()->getLimits(dataChannel)->setExtendVect(ext);
			for(i=0; i<=fam->getCurrentMember()->getVectorFamily()->getMaxMemberIndex(); i++) if(fam->getCurrentMember()->getVectorFamily()->getMember(i)->getDataChannel() == dataChannel)
			{
				iVector *ss = fam->getCurrentMember()->getVectorFamily()->getMember(i);
				if(address != IVTKWINDOW_BROADCASTADDRESS_EXT) ss->getExtender()->setActive(ext);
				ss->getExtender()->Modified();
			}
		}
		
		if(address==IVTKWINDOW_BROADCASTADDRESS_ALL	|| address==IVTKWINDOW_BROADCASTADDRESS_TENS || (address==IVTKWINDOW_BROADCASTADDRESS_EXT && fam->getCurrentMember()->getReader()->getLimits(fam->getCurrentMember()->getReader()->getCurrentDataChannel())->isExtendTens()))
		{
			if(address != IVTKWINDOW_BROADCASTADDRESS_EXT) fam->getCurrentMember()->getReader()->getLimits(dataChannel)->setExtendTens(ext);
			for(i=0; i<=fam->getCurrentMember()->getTensorFamily()->getMaxMemberIndex(); i++) if(fam->getCurrentMember()->getTensorFamily()->getMember(i)->getDataChannel() == dataChannel)
			{
				iTensor *ss = fam->getCurrentMember()->getTensorFamily()->getMember(i);
				if(address != IVTKWINDOW_BROADCASTADDRESS_EXT) ss->getExtender()->setActive(ext);
				ss->getExtender()->Modified();
			}
		}

	}

}
