/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


//
//
#define ICONTROLMODULE_SET_CURRENT_OBJECT(_name_) \
	if(obj>=0 && obj<=module->hartGet##_name_##Family()->GetMaxMemberIndex()) \
	{ \
		module->hartGet##_name_##Family()->SetCurrentMemberIndex(obj); \
		return true; \
	} \
	else return false


//
//
#define ICONTROLMODULE_EXECUTE_FOR_OBJECT1(_name_) \
	switch(objMode) \
	{ \
	case _ObjectModeCurrent: \
		{ \
			w->GetCurrent##_name_()->UnPackState(command); \
			mExecuteOk = w->GetCurrent##_name_()->UnPackedSomething(); \
			break; \
	} \
	case _ObjectModeAll: \
		{ \
			for(j=0; j<=w->GetMax##_name_##Index(); j++) \
			{ \
				w->Get##_name_(j)->UnPackState(command); \
				mExecuteOk = mExecuteOk || w->Get##_name_(j)->UnPackedSomething(); \
			} \
			break; \
		} \
	}

//
//
#define ICONTROLMODULE_EXECUTE_FOR_OBJECT_EXT(_class_,_get_) \
	iViewObjectFamily<_class_##ViewObject> *w = module->_get_##Family(); \
	ICONTROLMODULE_EXECUTE_FOR_OBJECT1(Member)
#define ICONTROLMODULE_EXECUTE_FOR_OBJECT(_name_) ICONTROLMODULE_EXECUTE_FOR_OBJECT_EXT(i##_name_,Get##_name_)


//
//
#define ICONTROLMODULE_CREATE_OBJECT(_name_) \
	iViewObjectFamily<i##_name_##ViewObject> *w = module->Get##_name_##Family(); \
	int	i = w->CreateMember(); \
	if(i == -1) return false; \
	w->GetMember(i)->CopyState(w->GetCurrentMember()); \
	w->Show(w->IsVisible()); \
	w->SetCurrentMemberIndex(i); \
	module->ClearCache()


//
//
#define ICONTROLMODULE_DELETE_OBJECT(_name_) \
	if(obj == -1) obj = module->Get##_name_##Family()->GetCurrentMemberIndex(); \
	if(!module->Get##_name_##Family()->DeleteMember(obj)) return false; \
	module->ClearCache()


//
//
#define ICONTROLMODULE_UNPACK_STATE(_name_) \
	_name_->UnPackCompleteState(line.Section(" ",joff))


//
//
#define ICONTROLMODULE_SAVE_OBJECT_EXT(_module_,_class_,_get_) \
	{ \
		_module_ *vm = iPointerCast<_module_,iViewModule>(mViewModules->GetMember(k)); \
		for(i=0; i<=vm->_get_##Family()->GetMaxMemberIndex(); i++) \
		{ \
			ws = prefix + _class_##ViewObject::Type().FullName() + " " + iString::FromNumber(k) + " " + iString::FromNumber(i) + " "; \
			vm->_get_##Family()->GetMember(i)->PackCompleteState(state); \
			ws += state; \
			if(!F.WriteLine(ws)) return false; \
		} \
	}
#define ICONTROLMODULE_SAVE_OBJECT(_name_) ICONTROLMODULE_SAVE_OBJECT_EXT(iViewModule,i##_name_,Get##_name_)


//
//
#define ICONTROLMODULE_LOAD_OBJECT_EXT(_module_,_class_,_get_,_show_) \
	if(ws == _class_##ViewObject::Type().FullName()) \
	{ \
		k = line.Section(" ",1,1).ToInt(ok); \
		if(!ok) { F.Close(); return false; } \
		if(k>=0 && k<nvm) \
		{ \
			_module_ *vm = iPointerCast<_module_,iViewModule>(mViewModules->GetMember(k)); \
			i = line.Section(" ",2,2).ToInt(ok); \
			if(!ok) { F.Close(); return false; } \
			while(i > vm->_get_##Family()->GetMaxMemberIndex()) if(vm->_get_##Family()->CreateMember()==-1) { F.Close(); return false; } \
			joff = 3; \
			ICONTROLMODULE_UNPACK_STATE(vm->_get_##Family()->GetMember(i)); \
			if(_show_) vm->_get_##Family()->GetMember(i)->Show(_show_); \
		} \
	}
#define ICONTROLMODULE_LOAD_OBJECT(_name_,_show_) ICONTROLMODULE_LOAD_OBJECT_EXT(iViewModule,i##_name_,Get##_name_,_show_)

