/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "icubeaxesactor.h"


#include "ierror.h"

#include <vtkAxisActor2D.h>
#include <vtkProperty2D.h>
#include <vtkRenderer.h>
#include <vtkTextProperty.h>
#include <vtkViewport.h>

	
iCubeAxesActor* iCubeAxesActor::New(const iRenderTool *rv)
{
	return new iCubeAxesActor(rv);
}


iCubeAxesActor::iCubeAxesActor(const iRenderTool *rv) : iOverlayBase(rv)
{
	mFontSize = 16;
	FontFactor = 1.2;

	this->AxisLabelTextProperty->BoldOn();
	this->AxisLabelTextProperty->ItalicOff();
	this->AxisLabelTextProperty->ShadowOn();
	this->AxisLabelTextProperty->SetFontFamilyToArial();
	this->AxisTitleTextProperty->BoldOn();
	this->AxisTitleTextProperty->ItalicOff();
	this->AxisTitleTextProperty->ShadowOn();
	this->AxisTitleTextProperty->SetFontFamilyToArial();
	this->XAxis->SetLabelTextProperty(AxisLabelTextProperty);
	this->YAxis->SetLabelTextProperty(AxisLabelTextProperty);
	this->ZAxis->SetLabelTextProperty(AxisLabelTextProperty);
	this->XAxis->SetTitleTextProperty(AxisTitleTextProperty);
	this->YAxis->SetTitleTextProperty(AxisTitleTextProperty);
	this->ZAxis->SetTitleTextProperty(AxisTitleTextProperty);

	this->SetFlyModeToOuterEdges();
	this->SetLabelFormat("%6.2g");
	this->ScalingOff();
	float b = 1.0;
	this->SetBounds(-b,b,-b,b,-b,b);
	this->SetNumberOfLabels(4);
	this->UseRangesOn();
	this->GetProperty()->SetColor(0.0,0.0,0.0);
}


int iCubeAxesActor::RenderOverlay(vtkViewport *viewport)
{
	return vtkCubeAxesActor2D::RenderOverlay(viewport);
}


int iCubeAxesActor::RenderOpaqueGeometry(vtkViewport *viewport)
{
	vtkCamera *cam = iPointerCast<vtkRenderer,vtkViewport>(viewport)->GetActiveCamera();
	if(cam == 0) return 0;
	//
	//  First of all do nothing if no axes are visible
	//
	if(this->XAxisVisibility==0 && this->YAxisVisibility==0 && this->ZAxisVisibility==0)
	{
		return 0;
	}

	int renderedSomething = 0;
	int mag = this->GetRenderingMagnification();
	if(mag == 1)
	{
		//
		//  Set colors (needed for VTK 5)
		//
		this->AxisLabelTextProperty->SetColor(this->GetProperty()->GetColor());
		this->AxisTitleTextProperty->SetColor(this->GetProperty()->GetColor());

		//
		//  Scale fonts
		//
		this->AxisLabelTextProperty->SetFontSize(mFontSize);
		this->AxisTitleTextProperty->SetFontSize(mFontSize);
		this->XAxis->SetFontFactor(FontFactor*mFontSize/16);
		this->YAxis->SetFontFactor(FontFactor*mFontSize/16);
		this->ZAxis->SetFontFactor(FontFactor*mFontSize/16);
		//
		//  Render and save axes positions
		//
		renderedSomething = vtkCubeAxesActor2D::RenderOpaqueGeometry(viewport);
		
		this->XAxis->GetPositionCoordinate()->GetValue(mPos1X);
		this->YAxis->GetPositionCoordinate()->GetValue(mPos1Y);
		this->ZAxis->GetPositionCoordinate()->GetValue(mPos1Z);

		this->XAxis->GetPosition2Coordinate()->GetValue(mPos2X);
		this->YAxis->GetPosition2Coordinate()->GetValue(mPos2Y);
		this->ZAxis->GetPosition2Coordinate()->GetValue(mPos2Z);
	}
	else
	{
		//
		//  Scale fonts
		//
		this->XAxis->SetFontFactor(mag*FontFactor*mFontSize/16);
		this->YAxis->SetFontFactor(mag*FontFactor*mFontSize/16);
		this->ZAxis->SetFontFactor(mag*FontFactor*mFontSize/16);
		//
		//  compute shifts
		//
		int winij[2];
		this->ComputePositionShiftsUnderMagnification(cam,winij,viewport);
		//
		//  shift positions: positions are in viewport coordinates, so need to scale
		//  winij appropriately
		//
		int *s = viewport->GetSize();
		winij[0] *= s[0];
		winij[1] *= s[1];

		this->XAxis->GetPositionCoordinate()->SetValue(mag*mPos1X[0]-winij[0],mag*mPos1X[1]-winij[1]);
		this->YAxis->GetPositionCoordinate()->SetValue(mag*mPos1Y[0]-winij[0],mag*mPos1Y[1]-winij[1]);
		this->ZAxis->GetPositionCoordinate()->SetValue(mag*mPos1Z[0]-winij[0],mag*mPos1Z[1]-winij[1]);

		if(this->XAxis->GetPosition2Coordinate()->GetReferenceCoordinate() == 0) this->XAxis->GetPosition2Coordinate()->SetValue(mag*mPos2X[0]-winij[0],mag*mPos2X[1]-winij[1]); else this->XAxis->GetPosition2Coordinate()->SetValue(mag*mPos2X[0],mag*mPos2X[1]);
		if(this->YAxis->GetPosition2Coordinate()->GetReferenceCoordinate() == 0) this->YAxis->GetPosition2Coordinate()->SetValue(mag*mPos2Y[0]-winij[0],mag*mPos2Y[1]-winij[1]); else this->YAxis->GetPosition2Coordinate()->SetValue(mag*mPos2Y[0],mag*mPos2Y[1]);
		if(this->ZAxis->GetPosition2Coordinate()->GetReferenceCoordinate() == 0) this->ZAxis->GetPosition2Coordinate()->SetValue(mag*mPos2Z[0]-winij[0],mag*mPos2Z[1]-winij[1]); else this->ZAxis->GetPosition2Coordinate()->SetValue(mag*mPos2Z[0],mag*mPos2Z[1]);
		//	
		//Render the axes
		//
		if(this->XAxisVisibility)
		{
			renderedSomething += this->XAxis->RenderOpaqueGeometry(viewport);
		}
		if(this->YAxisVisibility)
		{
			renderedSomething += this->YAxis->RenderOpaqueGeometry(viewport);
		}
		if(this->ZAxisVisibility)
		{
			renderedSomething += this->ZAxis->RenderOpaqueGeometry(viewport);
		}
		
	}
	return renderedSomething;
}


void iCubeAxesActor::SetFontSize(int s)
{ 
	if(s>0 && s<99) mFontSize = s; 
}


