/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IGRIDDATACONVERTER_H
#define IGRIDDATACONVERTER_H


#include "igenericfilter.h"
#include "iviewobjectcomponent.h"


class vtkImageData;
class vtkDataObject;


class iGridDataConverter : public iAbstractGridDataToGridDataFilter, protected iViewObjectComponent
{

public:

	enum ScalarStatus
	{
		_NoScalars,
		_SingleComponent,
		_MultipleComponents
	};

	static iGridDataConverter* New(iViewObject *vo);
	
	inline int GetCurrentVar() const { return mCurVar; }
	virtual void SetCurrentVar(int n);

	inline unsigned int GetDataRank() const { return mDataRank; }
	virtual void SetDataRank(unsigned int n);

	void SetScalarInput(vtkImageData *input);
	void SetVectorInput(vtkImageData *input);
	void SetTensorInput(vtkImageData *input);

	vtkImageData* GetScalarInput();
	vtkImageData* GetVectorInput();
	vtkImageData* GetTensorInput();

	ScalarStatus GetScalarStatus();

protected:
	
	iGridDataConverter(iViewObject *vo);
	virtual ~iGridDataConverter();
	
	virtual void SyncWithData(int info, void *data);

	//
	//  Block standard methods for setting input
	//
	void SetInput(vtkImageData *input);
	void SetNthInput(int num, vtkDataObject *input);

	virtual void PrepareOutput(vtkImageData *input, vtkStructuredPoints *output);
	virtual void ProduceOutput(vtkImageData *input, vtkStructuredPoints *output);
	
private:
	
	int mCurVar;
	unsigned int mDataRank;
	ScalarStatus mScalarStatus;
	vtkImageData *mInputs[3];
};

#endif


