/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  Optimized version of vtkProbeFilter for vtkPolyData input and vtkImageData source;
//  Also, vtkProbeFilter does not pass through normals of the input (for a good reason!).
//  This filter adds passing normals.
//

#ifndef IPROBEFILTER_H
#define IPROBEFILTER_H


#include "igenericfilter.h"
#include "iviewobjectcomponent.h"


class vtkImageData;


class iProbeFilter : public iAbstractPolyDataToPolyDataFilter, protected iViewObjectComponent
{

public:

	static iProbeFilter* New(iViewObject *);

	void SetSource(vtkImageData *source);
	vtkImageData* GetSource() const { return mSource; }

	void SetActive(bool s);
	inline bool GetActive() const { return mActive; }

protected:
	
	iProbeFilter(iViewObject *vo);
	virtual ~iProbeFilter();

	virtual void ProduceOutput(vtkPolyData *input, vtkPolyData *output);
	
	virtual void SyncWithData(int info, void *data);

	bool mActive;
	vtkImageData *mSource;
};

#endif  // IPROBEFILTER_H


