/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ISURFACESERIALPIPELINE_H
#define ISURFACESERIALPIPELINE_H


#include "iserialpipeline.h"


class iBoundedPlaneSource;
class iBoundedSphereSource;
class iContourFilter;
class iFlipNormalsFilter;
class iOptimizePolyDataFilter;
class iReducePolyDataFilter;
class iReducePolyDataFilter2;
class iShiftPolyDataFilter;
class iSmoothPolyDataFilter;
class iProbeFilter;
class iReplicatedPolyData;
class iSurfaceViewObject;
class iGridDataConverter;

class vtkPolyData;


class iSurfaceSerialPipeline : public iGridDataToPolyDataPipeline
{

	friend class iSurfaceViewObject;

public:
	
	virtual iGridDataToPolyDataPipeline* Copy() const;
	virtual void AttachObservers(bool master);
	virtual float GetMemorySize() const;

	//
	//  Pipeline operation
	//
	virtual void UpdateMethod();
	virtual void UpdateIsoSurfacePipeline(bool force = false);
	virtual void UpdateIsoSurfaceVar();
	virtual void UpdateIsoSurfaceLevel();
	virtual void UpdateVarPaint(int s);
	virtual void UpdateNormalsFlipped();
	virtual void UpdateProbeSize();
	virtual void UpdateProbePosition();
	virtual void UpdatePlaneDirection();
	virtual void UpdateReplicas();

protected:
	
	iSurfaceSerialPipeline(iSurfaceViewObject *s);
	virtual ~iSurfaceSerialPipeline();

	virtual void ProduceOutput(vtkImageData *input, vtkPolyData *output);

	void UpdateSphereResolution();
	void UpdatePlaneResolution();
	void UpdateAll();

	iSurfaceViewObject *mParent;
	vtkPolyData *mOutput[2];

	//
	//  VTK stuff
	//
	iContourFilter *mIsoSurfaceSource;
	iReplicatedPolyData *mDataReplicated[2];
	iGridDataConverter *mDataConverterPaint[2], *mDataConverter;
	iProbeFilter *mGateway, *mProbe[2];

	iShiftPolyDataFilter *mShiftFilter;
	iReducePolyDataFilter *mReduceFilter;
	iReducePolyDataFilter2 *mReduce2Filter;
	iSmoothPolyDataFilter *mSmoothFilter;
	iFlipNormalsFilter *mFlipNormalsFilter[2];
	iOptimizePolyDataFilter *mOptimizeFilter;

	iBoundedSphereSource *mSphereSource;
	iBoundedPlaneSource *mPlaneSource;

	int mSpecialVar;
};

#endif // ISURFACESERIALPIPELINE_H

