/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ISURFACEVIEWOBJECT_H
#define ISURFACEVIEWOBJECT_H


#include "isolidviewobject.h"


class iMarkerViewObject;
class iSurfaceSerialPipeline;
class iSurfaceParallelPipeline;


class iSurfaceViewObject : public iSolidViewObject
{
	
	friend class iExtensionFactory;

public:
	
	static iSurfaceViewObject* New(iViewModule *vm);
	static const iObjectType& Type();
	
	IOBJECT_DECLARE_GETSET1(Method,int);
	//virtual void SetMethod(int v);
	//inline int GetMethod() const { return mMethod; }
	
	IOBJECT_DECLARE_GETSET(IsoSurfaceVar,mVar[mActiveDataTypeIndex],int);
	//virtual void SetIsoSurfaceVar(int v);
	//inline int GetIsoSurfaceVar() const { return mVar[mActiveDataTypeIndex]; }
	
	IOBJECT_DECLARE_GETSET2(IsoSurfaceLevel,float);
	//virtual void SetIsoSurfaceLevel(float l);
	//float GetIsoSurfaceLevel() const;
	inline float GetDataIsoSurfaceLevel() const { return mLev[mActiveDataTypeIndex]; }
	
	IOBJECT_DECLARE_GETSET(IsoSurfaceSmoothing,mSmoothing,int);
	//virtual void SetIsoSurfaceSmoothing(int v);
	//inline int GetIsoSurfaceSmoothing() const { return mSmoothing; }
	
	IOBJECT_DECLARE_GETSET(IsoSurfaceReduction,mReduction,int);
	//virtual void SetIsoSurfaceReduction(int s);
	//inline int GetIsoSurfaceReduction() const { return mReduction; }
	
	IOBJECT_DECLARE_GETSET(AlternativeIsoSurfaceReductionMethod,mAlternativeReductionMethod,bool);
	//virtual void SetAlternativeIsoSurfaceReductionMethod(bool s);
	//inline bool GetAlternativeIsoSurfaceReductionMethod() const { return mAlternativeReductionMethod; }

	IOBJECT_DECLARE_GETSET(IsoSurfaceOptimization,mOptimization,bool);
	//virtual void SetIsoSurfaceOptimization(int s);
	//inline int GetIsoSurfaceOptimization() const { return mOptimization; }
	
	IOBJECT_DECLARE_GETSET1(NormalsFlipped,bool);
	//virtual void SetNormalsFlipped(bool s);
	//inline bool GetNormalsFlipped() const { return mNormalsFlipped; }
	
	IOBJECT_DECLARE_GETSET(PlaneDirection,mDir,const float*);
	//virtual void SetPlaneDirection(const float*);  // for plane
	//inline const float* GetPlaneDirection() const { return mDir; }

	IOBJECT_DECLARE_GETSET(AttachProbeToMarker,mAttachedMarkerIndex,int);  //  for sphere and plane
	//virtual void SetAttachProbeToMarker(int m);
	//inline int GetAttachProbeToMarker() const { return mAttachedMarkerIndex; }
	
	virtual void SetPaintVar(int s, int v);
	inline int GetPaintVar(int s) const { if(s == 0) return mPaintVarExt[mActiveDataTypeIndex]; else if(s == 1) return mPaintVarInt[mActiveDataTypeIndex]; else return 0; }
	static const iObjectKey& KeyPaintVar();

	IOBJECT_DECLARE_GETSET_DISTANCE(Size,mSize);  //  for sphere 
	//virtual void SetSize(const iDistance &s);
	//inline const iDistance& GetSize() const { return mSize; }
	
	IOBJECT_DECLARE_GETSET_POSITION(Position,mPosition); 
	//virtual void SetPosition(const iPosition &p);
	//inline const iPosition& GetPosition() const { return mPosition; }

	virtual void SetProbePositionToPickedPoint();
	static const iObjectKey& KeyProbePositionToPickedPoint(); // action key

//	inline iActor* GetActor(int i = 0) const { if(i == 0) return mActor[0]; else return mActor[1]; }
		
	virtual iSurfaceParallelPipeline* CreateParallelPipeline();
	virtual iSurfaceSerialPipeline* CreateSerialPipeline();

	//
	//  Inherited members
	//
	ISOLIDVIEWOBJECT_DECLARE_INHERITED_KEYS;
	ISOLIDVIEWOBJECT_DECLARE_INHERITED_MEMBERS;

	virtual void SetOpacity(int l, float o);		// both actors have the same opacity 
	virtual void UpdateAfterMarkerMove();

protected:
	
	iSurfaceViewObject(iViewModule *vm, const iDataInfo &info);
	virtual ~iSurfaceViewObject();

	void DetachFromMarker();

	int mMethod;
	iArray<float> mLev;
	iArray<int> mVar, mPaintVarExt, mPaintVarInt;
	
	float mDir[3];	// other parameters of fixed shape probes
	iDistance mSize;

	bool mNormalsFlipped, mOptimization, mAlternativeReductionMethod;
	int mReduction, mSmoothing;

	//
	//  VTK stuff
	//
	iSurfaceParallelPipeline *mPipeline;
};

#endif // ISURFACEVIEWOBJECT_H

