/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ITEXTACTOR_H
#define ITEXTACTOR_H


#include <vtkProp.h>


#include "itextbitmap.h"
#include "itextvector.h"


class iTextActor: public vtkProp
{
	
public:

	static iTextActor* New(const iRenderTool *rv){ return new iTextActor(rv); }
	
	virtual int RenderOverlay(vtkViewport *v);
	virtual int RenderOpaqueGeometry(vtkViewport *v);
	
	virtual void ReleaseGraphicsResources(vtkWindow *w);

	inline void GetSize(vtkViewport *v, float s[2]) const { mText[mFontType]->GetSize(v,s); }
	inline void GetSize(float s[2]) const { s[0] = mText[mFontType]->GetSize()[0]; s[1] = mText[mFontType]->GetSize()[1]; }

	inline void SetFontType(int s){ if(s>=0 && s<iParameter::__NumTextTypes) mFontType = s; }
	inline int GetFontType() const { return mFontType; }

	virtual void SetColor(iColor &c){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->SetColor(c); }
	virtual void SetFontSize(int s){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->SetFontSize(s); }
	virtual void SetBold(bool s){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->SetBold(s); }
	virtual void SetHJustification(int s){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->SetHJustification(s); }
	virtual void SetVJustification(int s){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->SetVJustification(s); }
	virtual void SetPosition(float p[2]){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->SetPosition(p); }
	virtual void SetPosition(float p0, float p1){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->SetPosition(p0,p1); }
	virtual void Rotate(float a){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->Rotate(a); }

	inline int GetFontSize() const { return mText[0]->GetFontSize(); }
	inline bool GetBold() const { return mText[0]->GetBold(); }
	inline const float* GetPosition() const { return mText[0]->GetPosition(); }

	virtual void SetText(const iString &t){ for(int i=0; i<iParameter::__NumTextTypes; i++) mText[i]->SetText(t);} 

protected:
	
	iTextActor(const iRenderTool *rv);
	virtual ~iTextActor();
	
	int mFontType;
	iText *mText[iParameter::__NumTextTypes];
};

#endif // ITEXTACTOR_H
