/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iviewobjectreplicator.h"


#include "ireplicated.h"
#include "iviewobject.h"

//
//  Templates
//
#include "iarraytemplate.h"


iViewObjectReplicator* iViewObjectReplicator::New(iViewObject *vo)
{
	return new iViewObjectReplicator(vo);
}


iViewObjectReplicator::iViewObjectReplicator(iViewObject *vo) : iViewObjectComponent(vo), mDataReplicated(0), mPropReplicated(0)
{
}


iViewObjectReplicator::~iViewObjectReplicator()
{
}


void iViewObjectReplicator::AddDataReplicated(iReplicated *r)
{
	if(r != 0)
	{
		mDataReplicated.AddUnique(r);
		this->Update();
	}
}


void iViewObjectReplicator::AddPropReplicated(iReplicated *r)
{
	if(r != 0)
	{
		mPropReplicated.AddUnique(r);
		this->Update();
	}
}


void iViewObjectReplicator::RemoveDataReplicated(iReplicated *r)
{
	if(r != 0)
	{
		mDataReplicated.Remove(r);
		this->Update();
	}
}


void iViewObjectReplicator::RemovePropReplicated(iReplicated *r)
{
	if(r != 0)
	{
		mPropReplicated.Remove(r);
		this->Update();
	}
}


void iViewObjectReplicator::SyncWithData(int, void *)
{
	this->Update();
}


void iViewObjectReplicator::Update()
{
	int i;

	if(this->GetViewObject()->IsOptimizedForQuality())
	{
		for(i=0; i<mDataReplicated.Size(); i++) mDataReplicated[i]->ReplicateAs(this->GetViewObject());
		for(i=0; i<mPropReplicated.Size(); i++) mPropReplicated[i]->UnReplicate();
	}
	else
	{
		for(i=0; i<mDataReplicated.Size(); i++) mDataReplicated[i]->UnReplicate();
		for(i=0; i<mPropReplicated.Size(); i++) mPropReplicated[i]->ReplicateAs(this->GetViewObject());
	}
}

