/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IVOLUMEVIEWOBJECT_H
#define IVOLUMEVIEWOBJECT_H


#include "iviewobject.h"


#include "icolor.h"

#include <vtkToolkits.h>


class iFunctionMapping;
class iHistogramMaker;
class iPiecewiseFunction;
class iReplicatedGridData;
class iReplicatedVolume;
class iGridDataConverter;
class iVolumeDataConverter;

class vtkImageData;
class vtkVolumeRayCastCompositeFunction;
class vtkVolumeRayCastMIPFunction;
class vtkVolumeRayCastMapper;
class vtkVolumeTextureMapper2D;
class vtkVolumeTextureMapper3D;


//
//  Allow for the IFrIT own support for VolumePro1000
//
#ifdef I_CUSTOM_VP1000
	#ifndef VTK_USE_VOLUMEPRO
		#define VTK_USE_VOLUMEPRO
	#endif
	#include "ivolumepromapper.h"
#else
	#ifdef VTK_USE_VOLUMEPRO
		#include <vtkVolumeProMapper.h>
	#else
		#define vtkVolumeProMapper int
	#endif
	#define iVolumeProMapper vtkVolumeProMapper
#endif


class iVolumeViewObject : public iViewObject
{
	
	friend class iExtensionFactory;

public:
	
	static iVolumeViewObject* New(iViewModule *vm);
	static const iObjectType& Type();
		
	IOBJECT_DECLARE_GETSET(Var,mVar[mActiveDataTypeIndex],int);
//	virtual void SetVar(int v);
//	inline int GetVar() const { return mVar[mActiveDataTypeIndex]; }

	virtual int SetMethod(int m);
	IOBJECT_DECLARE_GET1(Method,int);
//	inline int GetMethod() const { return mMethod; }
	
	IOBJECT_DECLARE_GETSET1(Palette,int);
//	virtual void SetPalette(int p);
//	inline int GetPalette() const { return mPalette; }

	IOBJECT_DECLARE_GETSET1(BlendMode,int);
//	virtual void SetBlendMode(int m);
//	inline int GetBlendMode() const { return mBlendMode; }

	IOBJECT_DECLARE_GETSET1(CompositeMethod,int);
//	virtual void SetCompositeMethod(bool m);
//	inline bool GetCompositeMethod() const { return mCompositeMethod; }

	IOBJECT_DECLARE_GETSET1(InterpolationType,int);
//	virtual void SetInterpolationType(bool m);
//	inline bool GetInterpolationType() const { return mInterpolationType; }
	
	IOBJECT_DECLARE_GETSET(XYResample,mResXY,float);
//	virtual void SetXYResample(float m);
//	inline float GetXYResample() const { return mResXY; }
	
	IOBJECT_DECLARE_GETSET(ZResample,mResZ,float);
//	virtual void SetZResample(float m);
//	inline float GetZResample() const { return mResZ; }
	
	IOBJECT_DECLARE_GET2(OpacityFunction,iFunctionMapping*);
//	iFunctionMapping* GetOpacityFunction() const;

	inline iVolumeDataConverter* GetConverter() const { return mDataConverter; }
	inline iGridDataConverter* GetHistogramConverter() const { return mHistogramConverter; }
	//
	//  Needed to circumvent VTK bug which does not give access to vtkVolumeMapper::ImageClipper
	//
	virtual vtkImageData* GetMapperInput();

	bool HasVolumePro() const;
	bool Has3DTexture() const;
	
	//
	//  Inherited members
	//
	IVIEWOBJECT_DECLARE_INHERITED_KEYS;
	IVIEWOBJECT_DECLARE_INHERITED_MEMBERS;

protected:
	
	iVolumeViewObject(iViewModule *vm, const iDataInfo &info);
	virtual ~iVolumeViewObject();

	virtual void UpdateVar();

	iArray<int> mVar;
	int mPalette, mMethod;
	iPiecewiseFunction *mOF;
	iArray<iFunctionMapping*> mFunctionMappings;
	
	int mBlendMode, mCompositeMethod, mInterpolationType; 
	float mResXY, mResZ;
	//
	//  VTK members
	//
	iReplicatedVolume *mVolume;
	iReplicatedGridData *mDataReplicated;
	iVolumeDataConverter *mDataConverter;
	iArray<iHistogramMaker*> mHistogramMakers;
	iGridDataConverter *mHistogramConverter;
	iVolumeProMapper *mVolumeProMapper;
	
	vtkVolumeRayCastMapper *mRaycastMapper;
	vtkVolumeTextureMapper2D *m2DTextureMapper;
	vtkVolumeTextureMapper3D *m3DTextureMapper;
	vtkVolumeRayCastCompositeFunction *mCF;
	vtkVolumeRayCastMIPFunction *mMF;
};

#endif // IVOLUMEVIEWOBJECT_H
 
