/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  A class for providing DataType(s)
//
#ifndef IGGDATATYPEPROVIDER_H
#define IGGDATATYPEPROVIDER_H


#include "ishellcomponent.h"


class iDataInfo;
class iDataType;
class iObjectKey;
class iString;

class iggPageViewObject;
class iggWidget;


class iggDataTypeProvider : protected iShellComponent
{

public:

	virtual ~iggDataTypeProvider();

	const iObjectKey& Translate(const iObjectKey &key) const;

	virtual int GetActiveDataTypeIndex() const = 0;
	virtual void SetActiveDataTypeIndex(int v) = 0;
	virtual const iDataInfo* GetDataInfo() const = 0;
	virtual const iDataType& GetActiveDataType() const = 0;

protected:

	iggDataTypeProvider(iShell *s);
};


class iggFixedDataTypeProvider : public iggDataTypeProvider
{

public:

	iggFixedDataTypeProvider(const iDataType &type, iggWidget *parent);
	virtual ~iggFixedDataTypeProvider();

	virtual int GetActiveDataTypeIndex() const;
	virtual void SetActiveDataTypeIndex(int v);
	virtual const iDataInfo* GetDataInfo() const;
	virtual const iDataType& GetActiveDataType() const;

protected:

	iDataInfo *mInfoPointer;
};


class iggKeywordDataTypeProvider : public iggDataTypeProvider
{

public:

	iggKeywordDataTypeProvider(const iString &keywords, iggWidget *parent);
	virtual ~iggKeywordDataTypeProvider();

	void FindAvailableData();
	bool IsThereDataType() const;

	virtual int GetActiveDataTypeIndex() const;
	virtual void SetActiveDataTypeIndex(int v);
	virtual const iDataInfo* GetDataInfo() const;
	virtual const iDataType& GetActiveDataType() const;

protected:

	iggWidget *mParent;
	int mActiveIndex;
	iDataInfo *mInfoPointer;
};


class iggViewObjectDataTypeProvider : public iggDataTypeProvider
{

public:

	iggViewObjectDataTypeProvider(iggPageViewObject *page);
	virtual ~iggViewObjectDataTypeProvider();

	virtual int GetActiveDataTypeIndex() const;
	virtual void SetActiveDataTypeIndex(int v);
	virtual const iDataInfo* GetDataInfo() const;
	virtual const iDataType& GetActiveDataType() const;

protected:

	iggPageViewObject *mPage;
};


class iggScalarFieldDataTypeProvider : public iggViewObjectDataTypeProvider
{

public:

	iggScalarFieldDataTypeProvider(iggPageViewObject *page);
	virtual ~iggScalarFieldDataTypeProvider();

	virtual const iDataInfo* GetDataInfo() const;
	virtual const iDataType& GetActiveDataType() const;
};

#endif  // IGGDATATYPEPROVIDER_H

