/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggwidgetkeylineedit.h"


#include "iggwidgetrendermodebutton.h"

#include "ibgwidgetentrysubject.h"

#include "iggsubjectfactory.h"


//
//******************************************
//
//  template class
//
//******************************************
//
template<class T>
iggWidgetKeyLineEdit<T>::iggWidgetKeyLineEdit(bool numeric, bool readonly, const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index, const iObjectKey *indkey) : iggWidgetKeyHandler<T>(_WidgetTypeEntry,key,rm,parent,index,indkey)
{
	this->mSubject = this->mSubject = iggSubjectFactory::CreateWidgetEntrySubject(this,false,(numeric)?10:0,label,(rm==_RenderModeNoRender)?0:new iggWidgetRenderModeButton(this)); IERROR_ASSERT_NULL_POINTER(mSubject);
	this->mSubject->SetEditable(!readonly);
	this->SetRenderMode(rm);
}


template<class T>
void iggWidgetKeyLineEdit<T>::SetRenderMode(int m)
{
	iggWidgetKeyHandler<T>::SetRenderMode(m);
	this->mSubject->SetDelayedEdit(this->GetRenderMode()==_RenderModeDelayed);
}


template<class T>
void iggWidgetKeyLineEdit<T>::QueryValue(T &val) const
{
	if(!this->ConvertFromString(this->mSubject->GetText(),val))
	{
		this->mSubject->SetText("");
	}
}


template<class T>
void iggWidgetKeyLineEdit<T>::UpdateValue(T val)
{
	iString s;

	if(this->IsEnabled())
	{
		this->ConvertToString(val,s);
		this->SetText(s);
	}
}


template<class T>
void iggWidgetKeyLineEdit<T>::OnString1Body(const iString &s)
{
	if(!s.IsEmpty())
	{
		this->ExecuteControl(false);
	}
}


template<class T>
void iggWidgetKeyLineEdit<T>::OnVoid1Body()
{
	this->ExecuteControl(true);
}


template<class T>
void iggWidgetKeyLineEdit<T>::Enable(bool s)
{
	if(s == this->IsEnabled()) return;

	if(s)
	{
		this->UpdateWidget();
	}
	else
	{
		this->mSubject->SetText("");
	}
	iggWidget::Enable(s);
}


template<class T>
void iggWidgetKeyLineEdit<T>::SetText(const iString &text)
{
	this->mSubject->SetText(text);
}

