/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iqtwidgetcolorselectionsubject.h"


#include "icolor.h"
#include "ierror.h"

#include "iggwidget.h"

#include "ibgframesubject.h"

#include "iqtassistant.h"
#include "iqtwidgethelper.h"

#ifdef IQT_3
#include <qcolordialog.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#else
#include <QtGui/QColorDialog>
#include <QtGui/QFrame>
#include <QtGui/QGridLayout>
#include <QtGui/QLabel>
#include <QtGui/QPushButton>
#endif


iqtWidgetColorSelectionSubject::iqtWidgetColorSelectionSubject(iggWidget *owner, bool horizontal) : QWidget(iqtAssistant::Convert(owner->GetParent())), ibgWidgetColorSelectionSubject(owner,horizontal)
{
	mWidgetHelper = new iqtWidgetHelper(this,owner); IERROR_ASSERT_NULL_POINTER(mWidgetHelper);

	//
	//  Create a layout
	//
	if(this->layout() != 0) delete this->layout();
	QGridLayout *l, *l1;
	if(horizontal) l = iqtAssistant::NewLayout(this,2); else
	{
		l = iqtAssistant::NewLayout(this,1);
#ifdef IQT_3
		l->expand(3,1);
#endif
	}

	QFrame *f = new QFrame(this);
	f->setFrameStyle(QFrame::Panel | QFrame::Sunken);
#ifdef IQT_3
	f->setMargin(ibgFrameSubject::GetPaddingWidth());
#endif
	l1 = iqtAssistant::NewLayout(f,1);
	mLabel = new QLabel(f);
#ifndef IQT_3
#ifndef IQT_40
	mLabel->setAutoFillBackground(true);
#endif
#endif
	mLabel->setScaledContents(true);
	mLabel->setMinimumSize(32,32);
	l1->addWidget(mLabel,0,0);
	if(horizontal) l->addWidget(f,0,0); else
	{
		l->addWidget(f,1,0);
		l->setRowStretch(0,10);
	}

	mButton = new QPushButton(this);
	mButton->setText("Select color");
	if(horizontal) l->addWidget(mButton,0,1); else l->addWidget(mButton,2,0);

	this->setSizePolicy(QSizePolicy(QSizePolicy::Minimum,QSizePolicy::Minimum));

	if(!this->connect(mButton,SIGNAL(clicked()),iPointerCast<iqtWidgetHelper,ibgWidgetHelper>(mWidgetHelper),SLOT(OnVoid1()))) IERROR_REPORT_ERROR("Missed connection.");
}


iqtWidgetColorSelectionSubject::~iqtWidgetColorSelectionSubject()
{
}


const iColor iqtWidgetColorSelectionSubject::GetColor() const
{
    QColor c = QColorDialog::getColor(); 
	if(c.isValid())
	{
		iqtAssistant::SetBackground(mLabel,c);
	}
	return iqtAssistant::Convert(c);
}


void iqtWidgetColorSelectionSubject::SetColor(const iColor &v)
{
	iqtAssistant::SetBackground(mLabel,iqtAssistant::Convert(v));
}

	
void iqtWidgetColorSelectionSubject::SetText(const iString &text)
{
	mButton->setText(iqtAssistant::ConvertWithModifiers(mButton,text));
}
