/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


//
//
#define ICONTROLMODULE_SET_CURRENT_OBJECT(_fam_) \
	if(obj>=0 && obj<=_fam_->GetMaxMemberIndex()) \
	{ \
		_fam_->SetCurrentMemberIndex(obj); \
		return true; \
	} \
	else return false


//
//
#define ICONTROLMODULE_EXECUTE_FOR_OBJECT(_fam_,_name_) \
	switch(objMode) \
	{ \
	case _ObjectModeCurrent: \
		{ \
			_fam_->GetCurrent##_name_()->UnPackState(command); \
			mExecuteOk = _fam_->GetCurrent##_name_()->UnPackedSomething(); \
			break; \
	} \
	case _ObjectModeAll: \
		{ \
			for(j=0; j<=_fam_->GetMax##_name_##Index(); j++) \
			{ \
				_fam_->Get##_name_(j)->UnPackState(command); \
				mExecuteOk = mExecuteOk || _fam_->Get##_name_(j)->UnPackedSomething(); \
			} \
			break; \
		} \
	}


//
//
#define ICONTROLMODULE_CREATE_OBJECT(_fam_) \
	int	i = _fam_->CreateMember(); \
	if(i == -1) return false; \
	_fam_->GetMember(i)->CopyState(_fam_->GetCurrentMember()); \
	_fam_->Show(_fam_->IsVisible()); \
	_fam_->SetCurrentMemberIndex(i); \
	module->ClearCache()


//
//
#define ICONTROLMODULE_DELETE_OBJECT(_fam_) \
	if(obj == -1) obj = _fam_->GetCurrentMemberIndex(); \
	if(!_fam_->DeleteMember(obj)) return false; \
	module->ClearCache()


//
//
#define ICONTROLMODULE_UNPACK_STATE(_name_) \
	{ _name_->UnPackCompleteState(line.Section(" ",joff)); this->GetShell()->OnInitAtom(); }


//
//
#define ICONTROLMODULE_SAVE_OBJECT(_fam_,_type_) \
	{ \
		for(i=0; i<=_fam_->GetMaxMemberIndex(); i++) \
		{ \
			ws = prefix + _type_.FullName() + " " + iString::FromNumber(k) + " " + iString::FromNumber(i) + " "; \
			fam->GetMember(i)->PackCompleteState(state); \
			ws += state; \
			if(!F.WriteLine(ws)) return false; \
		} \
	}


//
//
#define ICONTROLMODULE_LOAD_OBJECT(_getfam_,_type_,_show_) \
	if(ws == _type_.FullName()) \
	{ \
		k = line.Section(" ",1,1).ToInt(ok); \
		if(!ok) { F.Close(); return false; } \
		if(k>=0 && k<nvm) \
		{ \
			iViewModule *vm = mViewModules->GetMember(k); \
			i = line.Section(" ",2,2).ToInt(ok); \
			if(!ok) { F.Close(); return false; } \
			while(i > vm->_getfam_->GetMaxMemberIndex()) if(vm->_getfam_->CreateMember()==-1) { F.Close(); return false; } \
			joff = 3; \
			ICONTROLMODULE_UNPACK_STATE(vm->_getfam_->GetMember(i)); \
			if(_show_) vm->_getfam_->GetMember(i)->Show(_show_); \
		} \
	}

