/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


//
//  A class that decides how a ViewSubject is replicated - either by replicating the data 
// (in quality mode) or by replicating props - but not both at the same time!
//
#ifndef IVIEWSUBJECTREPLICATOR_H
#define IVIEWSUBJECTREPLICATOR_H


#include "iviewsubjectcomponent.h"
#include "ideletable.h"


#include "iarray.h"

class iReplicated;


class iViewSubjectReplicator : public iViewSubjectComponent, public iDeletable
{
	
	friend class iReplicated;

public:
	
	static iViewSubjectReplicator* New(iViewSubject *vo);

	const iReplicated* GetDataReplicated() const { return mDataReplicated[0]; }

	void Update();

protected:
	
	iViewSubjectReplicator(iViewSubject *vo);
	virtual ~iViewSubjectReplicator();
	
	void AddDataReplicated(iReplicated *r);
	void AddPropReplicated(iReplicated *r);

	void RemoveDataReplicated(iReplicated *r);
	void RemovePropReplicated(iReplicated *r);

	virtual void SyncWithData(const iDataSyncRequest &);

	iSearchableArray<iReplicated*> mDataReplicated, mPropReplicated;
};

#endif // IVIEWSUBJECTREPLICATOR_H
