/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  IFrIT control script class - maps control commands to function calls
//

#ifndef ICONTROLSCRIPT_H
#define ICONTROLSCRIPT_H


#include "ibasescript.h"


#include "ipointermacro.h"

class iControlModule;


class iControlScript: public iBaseScript
{

	IPOINTER_AS_PART(ControlModule);

public:

	enum _HelpId
	{
		_Root = 0,
		_Exec = 1,
		_Print = 2,
		_CreateDelete = 3,
		_Current = 4,
		_Control = 5
	};

	vtkTypeMacro(iControlScript,iBaseScript);
	static iControlScript* New(iControlModule *cm = 0, iScript *parent = 0);

	virtual const iString& GetHelpString(_HelpId id) const;

	void SetAutoRender(bool s){ mAutoRender = s; }
	inline bool GetAutoRender() const { return mAutoRender; }

protected:

	iControlScript(iControlModule *cm, iScript *parent);
	virtual ~iControlScript();

private:

	virtual iValue* TransformUnknownTokenToValue(const iString &s, bool acceptArrays = true, bool forceFloat = false);

	//
	//  Own console functions for re-directing the output into special windows
	//
	virtual void OutputText(const iString &s) = 0;
	virtual void OutputError(const iString &s) = 0;

	bool mAutoRender;

	static void ExecBody(iScript *me, iValue* v, int mode);
	//
	//  Basic functions
	//
	static void Exec(iScript *me, iValue* v, iValue::Assignment rel);
	static void Show(iScript *me, iValue* v, iValue::Assignment rel);
	static void Hide(iScript *me, iValue* v, iValue::Assignment rel);
	static void Print(iScript *me, iValue* v, iValue::Assignment rel);
	static void Create(iScript *me, iValue* v, iValue::Assignment rel);
	static void Remove(iScript *me, iValue* v, iValue::Assignment rel);
	static void Render(iScript *me, iValue* v, iValue::Assignment rel);
	static void Current(iScript *me, iValue* v, iValue::Assignment rel);
	static void Animate(iScript *me, iValue* v, iValue::Assignment rel);
	static void ExecAllObjects(iScript *me, iValue* v, iValue::Assignment rel);
	static void ExecAllWindows(iScript *me, iValue* v, iValue::Assignment rel);

	static void SaveState(iScript *me, iValue* v, iValue::Assignment rel);
	static void LoadState(iScript *me, iValue* v, iValue::Assignment rel);

	static void EmbedAnimatorScript(iScript *me, iValue* v, iValue::Assignment rel);
	//
	//  Help functions
	//
	static void Help(iScript *me, iValue* v, iValue::Assignment rel);
	static void HelpObject(iScript *me, iValue* v, iValue::Assignment rel);
	static void HelpProperty(iScript *me, iValue* v, iValue::Assignment rel);

	static void ListObjects(iScript *me);
	static void ListProperties(iScript *me, iValue* v, iValue::Assignment rel);

};

#endif // ICONTROLCRIPT_H
