/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iggdialoganimatingprogress.h"


#include "ianimator.h"
#include "ianimatorscript.h"
#include "icontrolmodule.h"
#include "idatareader.h"
#include "ierror.h"
#include "iimagefactory.h"
#include "imath.h"
#include "ishell.h"
#include "isystem.h"
#include "iviewmodule.h"
#include "iwriter.h"

#include "iggframe.h"
#include "iggmainwindow.h"
#include "iggwidgetarea.h"
#include "iggwidgetotherbutton.h"

#include "ibgwidgetbuttonsubject.h"

#include "iggsubjectfactory.h"
#include "iggparameter.h"
using namespace iggParameter;


namespace iggDialogAnimatingProgress_Private
{
	class CancelButton : public iggWidgetSimpleButton
	{

	public:

		CancelButton(iggDialogAnimatingProgress *dialog, iggFrame *parent) : iggWidgetSimpleButton("Cancel",parent)
		{
			mDialog = dialog;

			this->SetBaloonHelp("Cancel the animation");
		}

	protected:

		virtual void Execute()
		{
			mDialog->Cancel();
		}

		iggDialogAnimatingProgress *mDialog;
	};


	class PauseResumeButton : public iggWidgetSimpleButton
	{

	public:

		PauseResumeButton(iggDialogAnimatingProgress *dialog, iggFrame *parent) : iggWidgetSimpleButton("Pause",parent)
		{
			mDialog = dialog;

			this->SetBaloonHelp("Pause or resume the animation");
		}

	protected:

		virtual void UpdateWidgetBody()
		{
			if(mDialog->IsPaused()) mSubject->SetText("Resume"); else mSubject->SetText("Pause");
		}

		virtual void Execute()
		{
			mDialog->Pause(!mDialog->IsPaused());
		}

		iggDialogAnimatingProgress *mDialog;
	};
};


using namespace iggDialogAnimatingProgress_Private;


iggDialogAnimatingProgress::iggDialogAnimatingProgress(iggMainWindow *parent) : iggDialog(parent,_DialogBlocking|_DialogNoTitleBar,0,"Animating...",0,4,0), iScriptObserver(0)
{
	mFrame->AddLine(new iggWidgetTextArea("%bAnimating the scene...",mFrame),4);
	
	mFrame->AddSpace(10);
	mFrame->AddLine(0,new PauseResumeButton(this,mFrame),new CancelButton(this,mFrame));
	mFrame->AddSpace(10);

	mInfoFrame = new iggFrame(mFrame,2);
	mCurrentImageNumber = new iggWidgetTextArea("   1",mInfoFrame);
	mCurrentImageNumber->AlignLeft(true);
	mInfoFrame->AddLine(new iggWidgetTextArea("Current image #: ",mInfoFrame),mCurrentImageNumber);
	mCurrentRecord = new iggWidgetTextArea("   0",mInfoFrame);
	mCurrentRecord->AlignLeft(true);
	mInfoFrame->AddLine(new iggWidgetTextArea("Current record: ",mInfoFrame),mCurrentRecord);
	mCurrentFrame = new iggWidgetTextArea("   1",mInfoFrame);
	mCurrentFrame->AlignLeft(true);
	mInfoFrame->AddLine(new iggWidgetTextArea("Current frame: ",mInfoFrame),mCurrentFrame);
	mFrame->AddLine(mInfoFrame,4);

	mWarningFrame = new iggFrame(mFrame);
	mWarningFrame->AddLine(new iggWidgetTextArea("%b%+Animation is paused",mWarningFrame));
	mFrame->AddLine(mWarningFrame,4);

	mCancelled = mPaused = false;
	mCurrentViewModule = 0;
}


const iString& iggDialogAnimatingProgress::GetToolTip() const
{
	static iString tmp = "Pause or cancel an animation.";
	return tmp;
}

	
void iggDialogAnimatingProgress::Animate()
{
	mCurrentViewModule = this->GetShell()->GetControlModule()->GetViewModule();
	this->SetScript(mCurrentViewModule->GetAnimator()->GetScript());
	mCurrentViewModule->GetAnimator()->Animate();
}


void iggDialogAnimatingProgress::OnScriptStartBody()
{
    mCancelled = false;
	this->Pause(false);

	mLastImageIndex = mLastRecord = mLastFrame = -1;

	this->DisplayInfo();

	this->Show(true);
}


void iggDialogAnimatingProgress::OnScriptStopBody(const iString &)
{
	mCurrentViewModule = 0;
    mCancelled = mPaused = false;

	this->Show(false);
}


void iggDialogAnimatingProgress::OnScriptBeginLineBody(int, const iString &)
{
}


void iggDialogAnimatingProgress::OnScriptEndLineBody(int, const iString &)
{
}


void iggDialogAnimatingProgress::DisplayInfo()
{
	bool nr;
	int cr, cf, cii = mCurrentViewModule->GetWriter()->GetCurrentAnimationImageIndex();
	
	mCurrentViewModule->GetAnimator()->GetInfo(nr,cr,cf);

	if(cii != mLastImageIndex)
	{
		mLastImageIndex = cii;
		mCurrentImageNumber->SetText(iString::FromNumber(cii,"%5d"));
	}
	if(cr != mLastRecord)
	{
		mLastRecord = cr;
		mCurrentRecord->SetText(iString::FromNumber(cr,"%4d"));
	}
	if(cf != mLastFrame)
	{
		mLastFrame = cf;
		mCurrentFrame->SetText(iString::FromNumber(cf,"%4d"));
	}
}


bool iggDialogAnimatingProgress::OnScriptCheckAbortBody(int , int , int)
{
	this->DisplayInfo();

	this->GetMainWindow()->ProcessEvents();
	while(this->IsPaused() && !this->IsCancelled())
	{
		iSystem::Sleep(50);
		this->GetMainWindow()->ProcessEvents();
	}

	return this->IsCancelled();
}


void iggDialogAnimatingProgress::Cancel()
{
    mCancelled = true;
}


void iggDialogAnimatingProgress::Pause(bool s)
{
	mPaused = s;

	mInfoFrame->Show(!s);
	mWarningFrame->Show(s);

	mFrame->UpdateWidget();
}


bool iggDialogAnimatingProgress::CanBeClosed()
{
	return false;  // make it non-closeable
}

