/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "ibasicdatasubjects.h"


#include "idata.h"
#include "iuniformgridfileloader.h"


//
//  ********************************************************************
//
//  iUniformScalarsDataSubject class
//
//  ********************************************************************
//
IFIELDDATASUBJECT_DEFINE_TYPE(iUniformScalarsDataSubject,1,"Uniform Scalars","us","basic,field,scalars","IFRIT_SCALAR_FIELD_DATA_DIR");
//
//  Inherited keys
//
IFIELDDATASUBJECT_DEFINE_INHERITED_KEYS(iUniformScalarsDataSubject);

IOBJECT_DEFINE_KEY(iUniformScalarsDataSubject,VariableCalculatorFunction,cf,String,1);
IOBJECT_DEFINE_KEY(iUniformScalarsDataSubject,VariableCalculatorOutput,co,OffsetInt,1);


iUniformScalarsDataSubject::iUniformScalarsDataSubject(iUniformScalarsFileLoader *fl) : iFieldDataSubject(fl,iUniformScalarsDataSubject::Type().FullName())
{
	mConcreteLoader = fl;
	this->ConfigureLimits(3,"Variable");
}


void iUniformScalarsDataSubject::FieldDataSubjectPackStateBody(iString &s) const
{
	this->PackValue(s,KeyVariableCalculatorOutput(),mConcreteLoader->GetCalculatorOutput());
	this->PackValue(s,KeyVariableCalculatorFunction(),mConcreteLoader->GetCalculatorExpression());
}


void iUniformScalarsDataSubject::FieldDataSubjectUnPackStateBody(const iString &s)
{
	int i; iString s1;

	if(this->UnPackValue(s,KeyVariableCalculatorOutput(),i))
	{
		mConcreteLoader->SetCalculatorOutput(i);
		this->ClearCache();
	}
	if(this->UnPackValue(s,KeyVariableCalculatorFunction(),s1))
	{
		mConcreteLoader->SetCalculatorExpression(s1);
		this->ClearCache();
	}
}


//
//  ********************************************************************
//
//  iUniformVectorsDataSubject class
//
//  ********************************************************************
//
IFIELDDATASUBJECT_DEFINE_TYPE(iUniformVectorsDataSubject,2,"Uniform Vectors","uv","basic,field","IFRIT_VECTOR_FIELD_DATA_DIR");
//
//  Inherited keys
//
IFIELDDATASUBJECT_DEFINE_INHERITED_KEYS(iUniformVectorsDataSubject);


iUniformVectorsDataSubject::iUniformVectorsDataSubject(iFieldFileLoader *fl) : iFieldDataSubject(fl,iUniformVectorsDataSubject::Type().FullName())
{
	this->ConfigureLimits(1,"Vector field");
}


//
//  ********************************************************************
//
//  iUniformTensorsDataSubject class
//
//  ********************************************************************
//
IFIELDDATASUBJECT_DEFINE_TYPE(iUniformTensorsDataSubject,3,"Uniform Tensors","ut","basic,field","IFRIT_TENSOR_FIELD_DATA_DIR");
//
//  Inherited keys
//
IFIELDDATASUBJECT_DEFINE_INHERITED_KEYS(iUniformTensorsDataSubject);


iUniformTensorsDataSubject::iUniformTensorsDataSubject(iFieldFileLoader *fl) : iFieldDataSubject(fl,iUniformTensorsDataSubject::Type().FullName())
{
	this->ConfigureLimits(1,"Tensor field");
}


//
//  ********************************************************************
//
//  iBasicParticlesDataSubject class
//
//  ********************************************************************
//
IPARTICLEDATASUBJECT_DEFINE_TYPE(iBasicParticlesDataSubject,4,"Basic Particles","bp","basic,particles","IFRIT_PARTICLE_SET_DATA_DIR");

//
//  Inherited keys
//
IPARTICLEDATASUBJECT_DEFINE_INHERITED_KEYS(iBasicParticlesDataSubject);


iBasicParticlesDataSubject::iBasicParticlesDataSubject(iParticleFileLoader *fl) : iParticleDataSubject(fl,iBasicParticlesDataSubject::Type().FullName())
{
	this->ConfigureLimits(3,"Attribute");
}

