/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IDATAHELPER_H
#define IDATAHELPER_H


class vtkDataSet;


//
//  This is a small helper class, mostly responsible for providing the information about data.
//
class iDataHelper
{

public:
	
	iDataHelper(vtkDataSet *ds);
	virtual ~iDataHelper();

	inline vtkDataSet* GetData() const { return mData; }

	unsigned int GetDataRank() const;

	virtual bool IsThereData() const;
	virtual bool IsThereScalarData() const;
	virtual bool IsThereVectorData() const;
	virtual bool IsThereTensorData() const;

	static void CIC(bool periodic[3], int dims[3], double org[3], double spa[3],  float pos[3], int ijk1[3], int ijk2[3], double d1[3], double d2[3]);
	static void CIC(bool periodic[3], int dims[3], double org[3], double spa[3], double pos[3], int ijk1[3], int ijk2[3], double d1[3], double d2[3]);

private:

	vtkDataSet *mData;
};

#endif // IDATAHELPER_H

