/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iarray.h"
#include "ifamily.h"


template<class Object, class Parent>
iFamily<Object,Parent>* iFamily<Object,Parent>::New(Parent *p)
{
	return new iFamily<Object,Parent>(p);
}


template<class Object, class Parent>
iFamily<Object,Parent>::iFamily(Parent *p)
{
	this->mParent = p;
	this->mCur = 0;

	Object* tmp = Object::New(this->mParent); IERROR_ASSERT(tmp);
	this->mMemlist.Add(tmp);
}


template<class Object, class Parent>
iFamily<Object,Parent>::~iFamily()
{
	int i;
	//
	//  Delete members in reverse order in case they create static instances of reference-counted variables
	//
    for(i=this->mMemlist.MaxIndex(); i>=0; i--) this->mMemlist[i]->Delete(); 
}


template<class Object, class Parent>
int iFamily<Object,Parent>::CreateMember()
{
	Object* tmp = Object::New(this->mParent); if(tmp == 0) return -1;
	this->mMemlist.Add(tmp);
	return this->mMemlist.MaxIndex();

}


template<class Object, class Parent>
bool iFamily<Object,Parent>::DeleteMember(int i)
{
	if(i>=0 && i<this->mMemlist.Size() && this->mMemlist.Size()>1)
	{
		this->mMemlist[i]->Delete();
		this->mMemlist.Remove(i);
		if(this->mCur>=i && i>0) this->mCur--;
		return true;
    }
	else return false;
}

