/*
 *  IHU -- I Hear U, easy VoIP application using Speex and Qt
 *
 *  Copyright (C) 2003-2005 M. Trotta - <mrotta@users.sourceforge.net>
 *
 *  http://ihu.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

#ifndef CONFIG_HPP
#define CONFIG_HPP

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <memory>
#include <qsettings.h>
#include <qstring.h>

#define IHU_DEFAULT_INPORT 1793
#define IHU_DEFAULT_OUTPORT 1793
#define IHU_DEFAULT_INDRIVER 0
#define IHU_DEFAULT_OUTDRIVER 0
#define IHU_DEFAULT_PROTOCOL 0
#define IHU_DEFAULT_THRESHOLD 20
#define IHU_DEFAULT_TXSTOP 3
#define IHU_DEFAULT_RINGVOLUME 2
#define IHU_DEFAULT_ADRSTRETCH 5
#define IHU_DEFAULT_ADRMINDELAY 30
#define IHU_DEFAULT_ADRMAXDELAY 100
#define IHU_DEFAULT_AGCMIN 0
#define IHU_DEFAULT_AGCMAX 30
#define IHU_DEFAULT_AGCSTEP 10
#define IHU_DEFAULT_AGCLEVEL 50
#define IHU_DEFAULT_MODE 1
#define IHU_DEFAULT_BITRATEMODE 1
#define IHU_DEFAULT_QUALITY 5
#define IHU_DEFAULT_COMPLEXITY 3
#define IHU_DEFAULT_VBRQUALITY 5
#define IHU_DEFAULT_ABR 16
#define IHU_DEFAULT_KEYLEN 256

#define IHU_DEFAULT_ANSWER false
#define IHU_DEFAULT_TRAY true
#define IHU_DEFAULT_WAIT false
#define IHU_DEFAULT_HIDE false
#define IHU_DEFAULT_UDP true
#define IHU_DEFAULT_TCP true
#define IHU_DEFAULT_ADR false
#define IHU_DEFAULT_AGC false
#define IHU_DEFAULT_VAD true
#define IHU_DEFAULT_DTX true
#define IHU_DEFAULT_CRYPT false
#define IHU_DEFAULT_RANDOM true
#define IHU_DEFAULT_SHOWKEY false

#define IHU_DEFAULT_INTERFACE "default"

#define IHU_EXT ".ihu"
#define IHU_MAX_NAME_LEN 64
#define IHU_UDP 0
#define IHU_TCP 1
#define IHU_NARROW 0
#define IHU_WIDE 1
#define IHU_ULTRAWIDE 2

/**
 * This class is implemented as a Singleton and provides a global interface to 
 * configuration data. It is derived from QSettings, so see the Qt documentation
 * for specific member functions.
 * The constructor initializes everything with default values in case there is 
 * no item found in the configuration file.
 */

class Config : public QSettings {
public:
        /**
	 * Only possible access to Singleton
	 */
	static Config& instance();
	~Config() {};
private:
	typedef std::auto_ptr<Config> ConfigPtr;
	Config();
	void setDefault(const QString& key, const char* value);
	void setDefault(const QString& key, const int value);
	void setDefault(const QString& key, bool value);
};

#endif

