/*
 *  IHU -- I Hear U, easy VoIP application using Speex and Qt
 *
 *  Copyright (C) 2003-2005 M. Trotta - <mrotta@users.sourceforge.net>
 *
 *  http://ihu.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

#ifndef IHU_HPP
#define IHU_HPP

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qvariant.h>
#include <qmainwindow.h>
#include <qtimer.h>

#include "Config.hpp"
#include "Logger.hpp"
#include "Receiver.hpp"
#include "Transmitter.hpp"
#include "Rsa.hpp"
#include "Player.hpp"
#include "Recorder.hpp"

#include "trayicon.hpp"

class QFrame;
class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QAction;
class QActionGroup;
class QToolBar;
class QPopupMenu;
class QLabel;
class QComboBox;
class QPushButton;
class QSlider;
class QToolButton;

class LogViewer;

class Ihu : public QMainWindow
{
	Q_OBJECT

public:
	Ihu( QWidget* parent = 0, const char* name = 0, WFlags fl = WType_TopLevel );
	~Ihu();
	
	enum icon_type { IHU_ICON_NORMAL = 0, IHU_ICON_WAIT, IHU_ICON_ALARM, IHU_ICON_MISSED, IHU_ICON_TALK };

	QStatusBar* statusbar;
	QWidget *lockWidget;
	QFrame *mainFrame;
	QFrame *otherFrame;
	QLabel* tx;
	QLabel* rx;
	QLabel* threshold;
	QLabel* trafficLabel;
	QComboBox* hostEdit;
	QLabel* hostname;
	QLabel* agcLabel;
	QPushButton* callButton;
	QPushButton* stopButton;
	QPushButton* waitButton;
	QPushButton* logButton;
	QSlider* thSlider;
	QSlider* agcSlider;
	QToolButton* ringButton;
	QPushButton* settingsButton;
	QToolButton* muteSpkButton;
	QToolButton* muteMicButton;
	QMenuBar *menubar;
	QPopupMenu *fileMenu;
	QPopupMenu *optionsMenu;
	QPopupMenu *helpMenu;
	QAction* fileQuitAction;
	QAction* helpContentsAction;
	QAction* helpAboutAction;
	QAction* settingsAction;
	QAction* filePlayFileAction;
	QAction* adrAction;
	QAction* agcAction;
	QAction* cryptAction;
	QAction* changeKeyAction;
	QAction* setDecKeyAction;
	Player *player;
	Receiver *receiver;
	Recorder *recorder;
	Transmitter *transmitter;
	Rsa *rsa;
	Logger *logger;
	QLabel *lockPixmap;
	QLabel *rxPixmap;
	QLabel *txPixmap;
	QTimer *timer;
	QTimer *restartTimer;
	LogViewer* logViewer;
	TrayIcon* trayIcon;
public slots:
	virtual void initIhu(bool);
	virtual void closeEvent(QCloseEvent *);
	virtual void toggleVisibility();
	virtual void trayMenuRequested( const QPoint& );
	virtual void changeTrayIcon(icon_type);
	virtual void fileQuit();
	virtual void helpContents();
	virtual void helpAbout();
	virtual void log();
	virtual void settings();
	virtual void waitCalls(bool);
	virtual void waitForCalls();
	virtual void answer();
	virtual void call(QString);
	virtual void startAll();
	virtual void stopAll();
	virtual void stop();
	virtual void stopSignal();
	virtual void adrOn(bool);
	virtual void agcOn(bool);
	virtual void adrRefresh(bool);
	virtual void agcRefresh(bool);
	virtual void cryptOn();
	virtual void crypt(bool);
	virtual bool changeKey();
	virtual void setDecryptionKey();
	virtual void agcSliderChanged(int);
	virtual void sliderChanged(int);
	virtual void play();
	virtual void playFile(QString);
	virtual void abortAll(QString);
	virtual void showMessageCritical(QString);
	virtual void showWarning(QString);
	virtual void message(QString);
	virtual void ringMessage();
	virtual void warning(QString);
	virtual void sendKey();
	virtual void sendKeyRequest();
	virtual void newConnection(int, int, struct sockaddr_in);
	virtual void transmitterStatus(bool);
	virtual void receiverStatus(bool);
	virtual void ringOn(bool);
	virtual void changeProgress(int);
	virtual void sliderPress();
	virtual void sliderRelease();
	virtual void txLedEnable(bool);
	virtual void rxLedEnable(bool);
	virtual void applySettings();
	virtual void disableIn();
	virtual void disableOut();
	virtual void listen();
	virtual void receivedNewKey(QString);
private:
	bool fromFile;
	bool sliderFree;
	bool listening;
	bool received;
	bool tocrypt;
	bool closing;
	int skipStat;
	unsigned long seconds;
	QString fileName;
	Config& config;

protected slots:
	virtual void languageChange();
	virtual void statistics();
};

#endif
