/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.SourcePath;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.annotation.Documented;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class Util {
    public static final String[][] HTML_ESCAPE_CHARS = new String[][]{{"&", "&amp;"}, {"<", "&lt;"}, {">", "&gt;"}};

    public static ProgramElementDoc[] excludeDeprecatedMembers(ProgramElementDoc[] programElementDocArray) {
        return Util.toProgramElementDocArray(Util.excludeDeprecatedMembersAsList(programElementDocArray));
    }

    public static List excludeDeprecatedMembersAsList(ProgramElementDoc[] programElementDocArray) {
        ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>();
        for (int i = 0; i < programElementDocArray.length; ++i) {
            if (programElementDocArray[i].tags("deprecated").length != 0) continue;
            arrayList.add(programElementDocArray[i]);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static ProgramElementDoc[] toProgramElementDocArray(List list) {
        ProgramElementDoc[] programElementDocArray = new ProgramElementDoc[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            programElementDocArray[i] = (ProgramElementDoc)list.get(i);
        }
        return programElementDocArray;
    }

    public static boolean nonPublicMemberFound(ProgramElementDoc[] programElementDocArray) {
        for (int i = 0; i < programElementDocArray.length; ++i) {
            if (programElementDocArray[i].isPublic()) continue;
            return true;
        }
        return false;
    }

    public static MethodDoc findMethod(ClassDoc classDoc, MethodDoc methodDoc) {
        MethodDoc[] methodDocArray = classDoc.methods();
        for (int i = 0; i < methodDocArray.length; ++i) {
            if (!Util.executableMembersEqual(methodDoc, methodDocArray[i])) continue;
            return methodDocArray[i];
        }
        return null;
    }

    public static boolean executableMembersEqual(ExecutableMemberDoc executableMemberDoc, ExecutableMemberDoc executableMemberDoc2) {
        if (!(executableMemberDoc instanceof MethodDoc) || !(executableMemberDoc2 instanceof MethodDoc)) {
            return false;
        }
        MethodDoc methodDoc = (MethodDoc)executableMemberDoc;
        MethodDoc methodDoc2 = (MethodDoc)executableMemberDoc2;
        if (methodDoc.isStatic() && methodDoc2.isStatic()) {
            Parameter[] parameterArray;
            Parameter[] parameterArray2 = methodDoc.parameters();
            if (methodDoc.name().equals(methodDoc2.name()) && (parameterArray = methodDoc2.parameters()).length == parameterArray2.length) {
                int n;
                for (n = 0; n < parameterArray2.length && (parameterArray2[n].typeName().equals(parameterArray[n].typeName()) || parameterArray[n].type() instanceof TypeVariable || parameterArray2[n].type() instanceof TypeVariable); ++n) {
                }
                if (n == parameterArray2.length) {
                    return true;
                }
            }
            return false;
        }
        return methodDoc.overrides(methodDoc2) || methodDoc2.overrides(methodDoc) || executableMemberDoc == executableMemberDoc2;
    }

    public static boolean isCoreClass(ClassDoc classDoc) {
        return classDoc.containingClass() == null || classDoc.isStatic();
    }

    public static boolean matches(ProgramElementDoc programElementDoc, ProgramElementDoc programElementDoc2) {
        if (programElementDoc instanceof ExecutableMemberDoc && programElementDoc2 instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc executableMemberDoc = (ExecutableMemberDoc)programElementDoc;
            ExecutableMemberDoc executableMemberDoc2 = (ExecutableMemberDoc)programElementDoc2;
            return Util.executableMembersEqual(executableMemberDoc, executableMemberDoc2);
        }
        return programElementDoc.name().equals(programElementDoc2.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        byte[] byArray = new byte[512];
        int n = 0;
        FileInputStream fileInputStream = new FileInputStream(file2);
        File file3 = file.getParentFile();
        file3.mkdirs();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        finally {
            fileInputStream.close();
            fileOutputStream.close();
        }
    }

    public static void copyDocFiles(Configuration configuration, String string, String string2, boolean bl) {
        if (Util.checkCopyDocFilesErrors(configuration, string, string2)) {
            return;
        }
        String string3 = configuration.docFileDestDirName;
        File file = new File(string + string2);
        if (string3.length() > 0 && !string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        String string4 = string3 + string2;
        try {
            File file2 = new File(string4);
            DirectoryManager.createDirectory(configuration, string4);
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file3 = new File(file, stringArray[i]);
                File file4 = new File(file2, stringArray[i]);
                if (file3.isFile()) {
                    if (file4.exists() && !bl) {
                        configuration.message.warning((SourcePosition)null, "doclet.Copy_Overwrite_warning", file3.toString(), file2.toString());
                        continue;
                    }
                    configuration.message.notice("doclet.Copying_File_0_To_Dir_1", file3.toString(), file2.toString());
                    Util.copyFile(file4, file3);
                    continue;
                }
                if (!file3.isDirectory() || !configuration.copydocfilesubdirs || configuration.shouldExcludeDocFileDir(file3.getName())) continue;
                Util.copyDocFiles(configuration, string, string2 + "/" + file3.getName(), bl);
            }
        }
        catch (SecurityException securityException) {
            throw new DocletAbortException();
        }
        catch (IOException iOException) {
            throw new DocletAbortException();
        }
    }

    private static boolean checkCopyDocFilesErrors(Configuration configuration, String string, String string2) {
        if (!(configuration.sourcepath != null && configuration.sourcepath.length() != 0 || configuration.destDirName != null && configuration.destDirName.length() != 0)) {
            return true;
        }
        File file = new File(configuration.destDirName);
        StringTokenizer stringTokenizer = new StringTokenizer(configuration.sourcepath == null ? "" : configuration.sourcepath, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            File file2 = new File(stringTokenizer.nextToken());
            if (!file.equals(file2)) continue;
            return true;
        }
        File file3 = new File(string + string2);
        return !file3.exists();
    }

    public static void copyResourceFile(Configuration configuration, String string, boolean bl) {
        String string2 = configuration.destDirName;
        String string3 = string2 + "resources";
        DirectoryManager.createDirectory(configuration, string3);
        File file = new File(string3, string);
        if (file.exists() && !bl) {
            return;
        }
        try {
            int n;
            InputStream inputStream = Configuration.class.getResourceAsStream("resources/" + string);
            if (inputStream == null) {
                return;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getPackageSourcePath(Configuration configuration, PackageDoc packageDoc) {
        try {
            String string = DirectoryManager.getDirectoryPath(packageDoc);
            String string2 = new SourcePath(configuration.sourcepath).getDirectory(string) + "/";
            string2 = Util.replaceText(string2, File.separator, "/");
            string = Util.replaceText(string, File.separator, "/");
            return string2.substring(0, string2.indexOf(string));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static List getAllInterfaces(Type type, Configuration configuration, boolean bl) {
        AbstractMap abstractMap = bl ? new TreeMap() : new LinkedHashMap();
        Type[] typeArray = null;
        Type type2 = null;
        if (type instanceof ParameterizedType) {
            typeArray = ((ParameterizedType)type).interfaceTypes();
            type2 = ((ParameterizedType)type).superclassType();
        } else if (type instanceof ClassDoc) {
            typeArray = ((ClassDoc)type).interfaceTypes();
            type2 = ((ClassDoc)type).superclassType();
        } else {
            typeArray = type.asClassDoc().interfaceTypes();
            type2 = type.asClassDoc().superclassType();
        }
        for (int i = 0; i < typeArray.length; ++i) {
            Type type3 = typeArray[i];
            ClassDoc classDoc = type3.asClassDoc();
            if (!classDoc.isPublic() && configuration != null && !Util.isLinkable(classDoc, configuration)) continue;
            abstractMap.put(classDoc, type3);
            List list = Util.getAllInterfaces(type3, configuration, bl);
            for (Type type4 : list) {
                abstractMap.put(type4.asClassDoc(), type4);
            }
        }
        if (type2 == null) {
            return new ArrayList(abstractMap.values());
        }
        Util.addAllInterfaceTypes(abstractMap, type2, type2 instanceof ClassDoc ? ((ClassDoc)type2).interfaceTypes() : ((ParameterizedType)type2).interfaceTypes(), false, configuration);
        ArrayList arrayList = new ArrayList(abstractMap.values());
        if (bl) {
            Collections.sort(arrayList, new TypeComparator());
        }
        return arrayList;
    }

    public static List getAllInterfaces(Type type, Configuration configuration) {
        return Util.getAllInterfaces(type, configuration, true);
    }

    private static void findAllInterfaceTypes(Map map, ClassDoc classDoc, boolean bl, Configuration configuration) {
        Type type = classDoc.superclassType();
        if (type == null) {
            return;
        }
        Util.addAllInterfaceTypes(map, type, type instanceof ClassDoc ? ((ClassDoc)type).interfaceTypes() : ((ParameterizedType)type).interfaceTypes(), bl, configuration);
    }

    private static void findAllInterfaceTypes(Map map, ParameterizedType parameterizedType, Configuration configuration) {
        Type type = parameterizedType.superclassType();
        if (type == null) {
            return;
        }
        Util.addAllInterfaceTypes(map, type, type instanceof ClassDoc ? ((ClassDoc)type).interfaceTypes() : ((ParameterizedType)type).interfaceTypes(), false, configuration);
    }

    private static void addAllInterfaceTypes(Map map, Type type, Type[] typeArray, boolean bl, Configuration configuration) {
        for (int i = 0; i < typeArray.length; ++i) {
            Type type2 = typeArray[i];
            ClassDoc classDoc = type2.asClassDoc();
            if (!classDoc.isPublic() && (configuration == null || !Util.isLinkable(classDoc, configuration))) continue;
            if (bl) {
                type2 = type2.asClassDoc();
            }
            map.put(classDoc, type2);
            List list = Util.getAllInterfaces(type2, configuration);
            for (Type type3 : list) {
                map.put(type3.asClassDoc(), type3);
            }
        }
        if (type instanceof ParameterizedType) {
            Util.findAllInterfaceTypes(map, (ParameterizedType)type, configuration);
        } else if (((ClassDoc)type).typeParameters().length == 0) {
            Util.findAllInterfaceTypes(map, (ClassDoc)type, bl, configuration);
        } else {
            Util.findAllInterfaceTypes(map, (ClassDoc)type, true, configuration);
        }
    }

    public static List asList(ProgramElementDoc[] programElementDocArray) {
        ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>();
        for (int i = 0; i < programElementDocArray.length; ++i) {
            arrayList.add(programElementDocArray[i]);
        }
        return arrayList;
    }

    public static String quote(String string) {
        return "\"" + string + "\"";
    }

    public static String getPackageName(PackageDoc packageDoc) {
        return packageDoc == null || packageDoc.name().length() == 0 ? "&lt;Unnamed&gt;" : packageDoc.name();
    }

    public static String getPackageFileHeadName(PackageDoc packageDoc) {
        return packageDoc == null || packageDoc.name().length() == 0 ? "default" : packageDoc.name();
    }

    public static String replaceText(String string, String string2, String string3) {
        if (string2 == null || string3 == null || string2.equals(string3)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while ((n = stringBuffer.indexOf(string2, n)) != -1) {
            stringBuffer = stringBuffer.replace(n, n + string2.length(), string3);
            n += string3.length();
        }
        return stringBuffer.toString();
    }

    public static String escapeHtmlChars(String string) {
        String string2 = string;
        for (int i = 0; i < HTML_ESCAPE_CHARS.length; ++i) {
            string2 = Util.replaceText(string2, HTML_ESCAPE_CHARS[i][0], HTML_ESCAPE_CHARS[i][1]);
        }
        return string2;
    }

    public static Writer genWriter(Configuration configuration, String string, String string2, String string3) throws IOException, UnsupportedEncodingException {
        FileOutputStream fileOutputStream;
        if (string != null) {
            DirectoryManager.createDirectory(configuration, string);
            fileOutputStream = new FileOutputStream((string.length() > 0 ? string + File.separator : "") + string2);
        } else {
            fileOutputStream = new FileOutputStream(string2);
        }
        if (string3 == null) {
            return new OutputStreamWriter(fileOutputStream);
        }
        return new OutputStreamWriter((OutputStream)fileOutputStream, string3);
    }

    public static boolean isDocumentedAnnotation(AnnotationTypeDoc annotationTypeDoc) {
        AnnotationDesc[] annotationDescArray = annotationTypeDoc.annotations();
        for (int i = 0; i < annotationDescArray.length; ++i) {
            if (!annotationDescArray[i].annotationType().qualifiedName().equals(Documented.class.getName())) continue;
            return true;
        }
        return false;
    }

    public static String[] tokenize(String string, char c, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); i += Character.charCount(i)) {
            int n2 = string.codePointAt(i);
            if (bl) {
                stringBuilder.appendCodePoint(n2);
                bl = false;
                continue;
            }
            if (n2 == c && arrayList.size() < n - 1) {
                arrayList.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                continue;
            }
            if (n2 == 92) {
                bl = true;
                continue;
            }
            stringBuilder.appendCodePoint(n2);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[0]);
    }

    public static boolean isLinkable(ClassDoc classDoc, Configuration configuration) {
        return classDoc.isIncluded() && configuration.isGeneratedDoc(classDoc) || configuration.extern.isExternal(classDoc) && (classDoc.isPublic() || classDoc.isProtected());
    }

    public static Type getFirstVisibleSuperClass(ClassDoc classDoc, Configuration configuration) {
        if (classDoc == null) {
            return null;
        }
        Type type = classDoc.superclassType();
        ClassDoc classDoc2 = classDoc.superclass();
        while (!(type == null || classDoc2.isPublic() || Util.isLinkable(classDoc2, configuration) || classDoc2.superclass().qualifiedName().equals(classDoc2.qualifiedName()))) {
            type = classDoc2.superclassType();
            classDoc2 = classDoc2.superclass();
        }
        if (classDoc.equals(classDoc2)) {
            return null;
        }
        return type;
    }

    public static ClassDoc getFirstVisibleSuperClassCD(ClassDoc classDoc, Configuration configuration) {
        ClassDoc classDoc2;
        if (classDoc == null) {
            return null;
        }
        for (classDoc2 = classDoc.superclass(); classDoc2 != null && !classDoc2.isPublic() && !Util.isLinkable(classDoc2, configuration); classDoc2 = classDoc2.superclass()) {
        }
        if (classDoc.equals(classDoc2)) {
            return null;
        }
        return classDoc2;
    }

    public static String getTypeName(Configuration configuration, ClassDoc classDoc, boolean bl) {
        String string = "";
        if (classDoc.isOrdinaryClass()) {
            string = "doclet.Class";
        } else if (classDoc.isInterface()) {
            string = "doclet.Interface";
        } else if (classDoc.isException()) {
            string = "doclet.Exception";
        } else if (classDoc.isError()) {
            string = "doclet.Error";
        } else if (classDoc.isAnnotationType()) {
            string = "doclet.AnnotationType";
        } else if (classDoc.isEnum()) {
            string = "doclet.Enum";
        }
        return configuration.getText(bl ? string.toLowerCase() : string);
    }

    public static void replaceTabs(int n, StringBuffer stringBuffer) {
        int n2;
        while ((n2 = stringBuffer.indexOf("\t")) != -1) {
            StringBuffer stringBuffer2 = new StringBuffer();
            int n3 = n2;
            do {
                stringBuffer2.append(" ");
            } while (++n3 % n != 0);
            stringBuffer.replace(n2, n2 + 1, stringBuffer2.toString());
        }
    }

    public static void setEnumDocumentation(Configuration configuration, ClassDoc classDoc) {
        MethodDoc[] methodDocArray = classDoc.methods();
        for (int i = 0; i < methodDocArray.length; ++i) {
            Type type;
            MethodDoc methodDoc = methodDocArray[i];
            if (methodDoc.name().equals("values") && methodDoc.parameters().length == 0) {
                methodDoc.setRawCommentText(configuration.getText("doclet.enum_values_doc", classDoc.name()));
                continue;
            }
            if (!methodDoc.name().equals("valueOf") || methodDoc.parameters().length != 1 || (type = methodDoc.parameters()[0].type()) == null || !type.qualifiedTypeName().equals(String.class.getName())) continue;
            methodDoc.setRawCommentText(configuration.getText("doclet.enum_valueof_doc"));
        }
    }

    public static boolean isDeprecated(ProgramElementDoc programElementDoc) {
        if (programElementDoc.tags("deprecated").length > 0) {
            return true;
        }
        AnnotationDesc[] annotationDescArray = programElementDoc.annotations();
        for (int i = 0; i < annotationDescArray.length; ++i) {
            if (!annotationDescArray[i].annotationType().qualifiedName().equals(Deprecated.class.getName())) continue;
            return true;
        }
        return false;
    }

    private static class TypeComparator
    implements Comparator {
        private TypeComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Type)object).qualifiedTypeName().toLowerCase().compareTo(((Type)object2).qualifiedTypeName().toLowerCase());
        }
    }
}

