/*
  Copyright (C) 2004 Jeroen Frijters

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  Jeroen Frijters
  jeroen@frijters.net
  
*/

namespace CoreClasses.java.lang
{
	sealed class Object
	{
		private Object() {}
		// NOTE we have a dummy static initializer, to make sure we don't get the beforeFieldInit attribute
		// (we don't want the classes to be loaded prematurely, because they might not be available then)
		static Object() {}
		internal static TypeWrapper Wrapper = ClassLoaderWrapper.LoadClassCritical("java.lang.Object");
	}

	sealed class String
	{
		private String() {}
		// NOTE we have a dummy static initializer, to make sure we don't get the beforeFieldInit attribute
		// (we don't want the classes to be loaded prematurely, because they might not be available then)
		static String() {}
		internal static TypeWrapper Wrapper = ClassLoaderWrapper.LoadClassCritical("java.lang.String");
	}

	sealed class Class
	{
		private Class() {}
		// NOTE we have a dummy static initializer, to make sure we don't get the beforeFieldInit attribute
		// (we don't want the classes to be loaded prematurely, because they might not be available then)
		static Class() {}
		internal static TypeWrapper Wrapper = ClassLoaderWrapper.LoadClassCritical("java.lang.Class");
	}

	sealed class Throwable
	{
		private Throwable() {}
		// NOTE we have a dummy static initializer, to make sure we don't get the beforeFieldInit attribute
		// (we don't want the classes to be loaded prematurely, because they might not be available then)
		static Throwable() {}
		internal static TypeWrapper Wrapper = ClassLoaderWrapper.LoadClassCritical("java.lang.Throwable");
	}
}
