/*
  IIIMGdkEventKey.c
  Copyright (C) 2003 Free Standards Group

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL OPENI18N WG OR FREE STANDARDS GROUP. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.

  Except as contained in this notice, the names of OpenI18N WG and/or
  Free Standards Group shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from OpenI18N WG and/or Free Standards Group
  as applicable.

  Author: MIYASHITA, Hisashi <himi@OpenI18N.org>

*/
#include <gdk/gdkkeysyms.h>
#include "IIIMGdkEventKey.h"

enum IIIMF_MODIFIERS
  {
    IIIMF_SHIFT_MODIFIER = 1,
    IIIMF_CONTROL_MODIFIER = 2,
    IIIMF_META_MODIFIER = 4,
    IIIMF_ALT_MODIFIER = 8
  };

static int
g2icode (guint kv)
{
  switch (kv)
    {
    case GDK_VoidSymbol:
      return 0;
    case GDK_BackSpace:
      return IIIMF_KEYCODE_BACK_SPACE;
    case GDK_Tab:
      return IIIMF_KEYCODE_TAB;
    case GDK_Linefeed:
      return IIIMF_KEYCODE_ENTER;
    case GDK_Clear:
      return -IIIMF_KEYCODE_CLEAR;
    case GDK_Return:
      return IIIMF_KEYCODE_ENTER;
    case GDK_Pause:
      return IIIMF_KEYCODE_PAUSE;
    case GDK_Scroll_Lock:
      return -IIIMF_KEYCODE_SCROLL_LOCK;
    case GDK_Sys_Req:
      return 0;
    case GDK_Escape:
      return IIIMF_KEYCODE_ESCAPE;
    case GDK_Delete:
      return IIIMF_KEYCODE_DELETE;
    case GDK_Multi_key:
      return 0;
    case GDK_Codeinput:
      return -IIIMF_KEYCODE_CODE_INPUT;
    case GDK_SingleCandidate:
    case GDK_MultipleCandidate:
      return 0;
    case GDK_PreviousCandidate:
      return -IIIMF_KEYCODE_PREVIOUS_CANDIDATE;
    case GDK_Kanji:
      return -IIIMF_KEYCODE_KANJI;
    case GDK_Muhenkan:
      return -IIIMF_KEYCODE_NONCONVERT;
    case GDK_Henkan_Mode:
      /* case GDK_Henkan: */
      return -IIIMF_KEYCODE_CONVERT;
    case GDK_Romaji:
      return -IIIMF_KEYCODE_ROMAN_CHARACTERS;
    case GDK_Hiragana:
      return -IIIMF_KEYCODE_HIRAGANA;
    case GDK_Katakana:
      return -IIIMF_KEYCODE_KATAKANA;
    case GDK_Hiragana_Katakana:
      return 0;
    case GDK_Zenkaku:
      return -IIIMF_KEYCODE_FULL_WIDTH;
    case GDK_Hankaku:
      return -IIIMF_KEYCODE_HALF_WIDTH;
    case GDK_Zenkaku_Hankaku:
      return 0;
    case GDK_Touroku:
    case GDK_Massyo:
      return 0;
    case GDK_Kana_Lock:
      return -IIIMF_KEYCODE_KANA_LOCK;
    case GDK_Kana_Shift:
    case GDK_Eisu_Shift:
    case GDK_Eisu_toggle:
      /* case GDK_Kanji_Bangou: */
      /* case GDK_Zen_Koho: */
      /* case GDK_Mae_Koho: */
      return 0;
    case GDK_Home:
      return -IIIMF_KEYCODE_HOME;
    case GDK_Left:
      return -IIIMF_KEYCODE_LEFT;
    case GDK_Up:
      return -IIIMF_KEYCODE_UP;
    case GDK_Right:
      return -IIIMF_KEYCODE_RIGHT;
    case GDK_Down:
      return -IIIMF_KEYCODE_DOWN;
    case GDK_Page_Up:
      return -IIIMF_KEYCODE_PAGE_UP;
    case GDK_Page_Down:
      return -IIIMF_KEYCODE_PAGE_DOWN;
    case GDK_End:
      return -IIIMF_KEYCODE_END;
    case GDK_Begin:
    case GDK_Select:
      return 0;
    case GDK_Print:
      return -IIIMF_KEYCODE_PRINTSCREEN;
    case GDK_Execute:
      return 0;
    case GDK_Insert:
      return IIIMF_KEYCODE_INSERT;
    case GDK_Undo:
      return -IIIMF_KEYCODE_UNDO;
    case GDK_Redo:
    case GDK_Menu:
      return 0;
    case GDK_Find:
      return -IIIMF_KEYCODE_FIND;
    case GDK_Cancel:
      return -IIIMF_KEYCODE_CANCEL;
    case GDK_Help:
      return -IIIMF_KEYCODE_HELP;
    case GDK_Break:
      return 0;
    case GDK_Mode_switch:
      /* case GDK_script_switch: */
      return -IIIMF_KEYCODE_MODECHANGE;
    case GDK_Num_Lock:
      return -IIIMF_KEYCODE_NUM_LOCK;
    case GDK_KP_Space:
      return IIIMF_KEYCODE_SPACE;
    case GDK_KP_Tab:
      return IIIMF_KEYCODE_TAB;
    case GDK_KP_Enter:
      return IIIMF_KEYCODE_ENTER;
    case GDK_KP_F1:
      return -IIIMF_KEYCODE_F1;
    case GDK_KP_F2:
      return -IIIMF_KEYCODE_F2;
    case GDK_KP_F3:
      return -IIIMF_KEYCODE_F3;
    case GDK_KP_F4:
      return -IIIMF_KEYCODE_F4;
    case GDK_KP_Home:
      return -IIIMF_KEYCODE_HOME;
    case GDK_KP_Left:
      return -IIIMF_KEYCODE_LEFT;
    case GDK_KP_Up:
      return -IIIMF_KEYCODE_UP;
    case GDK_KP_Right:
      return -IIIMF_KEYCODE_RIGHT;
    case GDK_KP_Down:
      return -IIIMF_KEYCODE_DOWN;
    case GDK_KP_Page_Up:
      return -IIIMF_KEYCODE_PAGE_UP;
    case GDK_KP_Page_Down:
      return -IIIMF_KEYCODE_PAGE_DOWN;
    case GDK_KP_End:
      return -IIIMF_KEYCODE_END;
    case GDK_KP_Begin:
      return 0;
    case GDK_KP_Insert:
      return IIIMF_KEYCODE_INSERT;
    case GDK_KP_Delete:
      return IIIMF_KEYCODE_DELETE;
    case GDK_KP_Equal:
      return IIIMF_KEYCODE_EQUALS;
    case GDK_KP_Multiply:
      return IIIMF_KEYCODE_MULTIPLY;
    case GDK_KP_Add:
      return IIIMF_KEYCODE_ADD;
    case GDK_KP_Separator:
      return IIIMF_KEYCODE_SEPARATOR;
    case GDK_KP_Subtract:
      return IIIMF_KEYCODE_SUBTRACT;
    case GDK_KP_Decimal:
      return IIIMF_KEYCODE_DECIMAL;
    case GDK_KP_Divide:
      return IIIMF_KEYCODE_DIVIDE;
    case GDK_KP_0:
      return IIIMF_KEYCODE_NUMPAD0;
    case GDK_KP_1:
      return IIIMF_KEYCODE_NUMPAD1;
    case GDK_KP_2:
      return IIIMF_KEYCODE_NUMPAD2;
    case GDK_KP_3:
      return IIIMF_KEYCODE_NUMPAD3;
    case GDK_KP_4:
      return IIIMF_KEYCODE_NUMPAD4;
    case GDK_KP_5:
      return IIIMF_KEYCODE_NUMPAD5;
    case GDK_KP_6:
      return IIIMF_KEYCODE_NUMPAD6;
    case GDK_KP_7:
      return IIIMF_KEYCODE_NUMPAD7;
    case GDK_KP_8:
      return IIIMF_KEYCODE_NUMPAD8;
    case GDK_KP_9:
      return IIIMF_KEYCODE_NUMPAD9;
    case GDK_F1:
      return -IIIMF_KEYCODE_F1;
    case GDK_F2:
      return -IIIMF_KEYCODE_F2;
    case GDK_F3:
      return -IIIMF_KEYCODE_F3;
    case GDK_F4:
      return -IIIMF_KEYCODE_F4;
    case GDK_F5:
      return -IIIMF_KEYCODE_F5;
    case GDK_F6:
      return -IIIMF_KEYCODE_F6;
    case GDK_F7:
      return -IIIMF_KEYCODE_F7;
    case GDK_F8:
      return -IIIMF_KEYCODE_F8;
    case GDK_F9:
      return -IIIMF_KEYCODE_F9;
    case GDK_F10:
      return -IIIMF_KEYCODE_F10;
    case GDK_F11:
      /*case GDK_L1:*/
      return -IIIMF_KEYCODE_F11;
    case GDK_F12:
      /* case GDK_L2: */
      return -IIIMF_KEYCODE_F12;
    case GDK_F13:
      /* case GDK_L3: */
      return -IIIMF_KEYCODE_F13;
    case GDK_F14:
      /* case GDK_L4: */
      return -IIIMF_KEYCODE_F14;
    case GDK_F15:
      /* case GDK_L5: */
      return -IIIMF_KEYCODE_F15;
    case GDK_F16:
      /* case GDK_L6: */
      return -IIIMF_KEYCODE_F16;
    case GDK_F17:
      /* case GDK_L7: */
      return -IIIMF_KEYCODE_F17;
    case GDK_F18:
      /* case GDK_L8: */
      return -IIIMF_KEYCODE_F18;
    case GDK_F19:
      /* case GDK_L9: */
      return -IIIMF_KEYCODE_F19;
    case GDK_F20:
      /* case GDK_L10: */
      return -IIIMF_KEYCODE_F20;
    case GDK_F21:
      /* case GDK_R1: */
      return -IIIMF_KEYCODE_F21;
    case GDK_F22:
      /* case GDK_R2: */
      return -IIIMF_KEYCODE_F22;
    case GDK_F23:
      /* case GDK_R3: */
      return -IIIMF_KEYCODE_F23;
    case GDK_F24:
      /* case GDK_R4: */
      return -IIIMF_KEYCODE_F24;
    case GDK_F25:
      /* case GDK_R5: */
    case GDK_F26:
      /* case GDK_R6: */
    case GDK_F27:
      /* case GDK_R7: */
    case GDK_F28:
      /* case GDK_R8: */
    case GDK_F29:
      /* case GDK_R9: */
    case GDK_F30:
      /* case GDK_R10: */
    case GDK_F31:
      /* case GDK_R11: */
    case GDK_F32:
      /* case GDK_R12: */
    case GDK_F33:
      /* case GDK_R13: */
    case GDK_F34:
      /* case GDK_R14: */
    case GDK_F35:
      /* case GDK_R15: */
      return 0;
    case GDK_Shift_L:
    case GDK_Shift_R:
      return -IIIMF_KEYCODE_SHIFT;
    case GDK_Control_L:
    case GDK_Control_R:
      return -IIIMF_KEYCODE_CONTROL;
    case GDK_Caps_Lock:
      return -IIIMF_KEYCODE_CAPS_LOCK;
    case GDK_Shift_Lock:
      return 0;
    case GDK_Meta_L:
    case GDK_Meta_R:
      return -IIIMF_KEYCODE_META;
    case GDK_Alt_L:
    case GDK_Alt_R:
      return -IIIMF_KEYCODE_ALT;
    case GDK_Super_L:
    case GDK_Super_R:
    case GDK_Hyper_L:
    case GDK_Hyper_R:
    case GDK_ISO_Lock:
    case GDK_ISO_Level2_Latch:
    case GDK_ISO_Level3_Shift:
    case GDK_ISO_Level3_Latch:
    case GDK_ISO_Level3_Lock:
      /* case GDK_ISO_Group_Shift: */
    case GDK_ISO_Group_Latch:
    case GDK_ISO_Group_Lock:
    case GDK_ISO_Next_Group:
    case GDK_ISO_Next_Group_Lock:
    case GDK_ISO_Prev_Group:
    case GDK_ISO_Prev_Group_Lock:
    case GDK_ISO_First_Group:
    case GDK_ISO_First_Group_Lock:
    case GDK_ISO_Last_Group:
    case GDK_ISO_Last_Group_Lock:
    case GDK_ISO_Left_Tab:
    case GDK_ISO_Move_Line_Up:
    case GDK_ISO_Move_Line_Down:
    case GDK_ISO_Partial_Line_Up:
    case GDK_ISO_Partial_Line_Down:
    case GDK_ISO_Partial_Space_Left:
    case GDK_ISO_Partial_Space_Right:
    case GDK_ISO_Set_Margin_Left:
    case GDK_ISO_Set_Margin_Right:
    case GDK_ISO_Release_Margin_Left:
    case GDK_ISO_Release_Margin_Right:
    case GDK_ISO_Release_Both_Margins:
    case GDK_ISO_Fast_Cursor_Left:
    case GDK_ISO_Fast_Cursor_Right:
    case GDK_ISO_Fast_Cursor_Up:
    case GDK_ISO_Fast_Cursor_Down:
    case GDK_ISO_Continuous_Underline:
    case GDK_ISO_Discontinuous_Underline:
    case GDK_ISO_Emphasize:
    case GDK_ISO_Center_Object:
    case GDK_ISO_Enter:
      return 0;
    case GDK_dead_grave:
      return IIIMF_KEYCODE_DEAD_GRAVE;
    case GDK_dead_acute:
      return IIIMF_KEYCODE_DEAD_ACUTE;
    case GDK_dead_circumflex:
      return IIIMF_KEYCODE_DEAD_CIRCUMFLEX;
    case GDK_dead_tilde:
      return IIIMF_KEYCODE_DEAD_TILDE;
    case GDK_dead_macron:
      return IIIMF_KEYCODE_DEAD_MACRON;
    case GDK_dead_breve:
      return IIIMF_KEYCODE_DEAD_BREVE;
    case GDK_dead_abovedot:
      return IIIMF_KEYCODE_DEAD_ABOVEDOT;
    case GDK_dead_diaeresis:
      return IIIMF_KEYCODE_DEAD_DIAERESIS;
    case GDK_dead_abovering:
      return IIIMF_KEYCODE_DEAD_ABOVERING;
    case GDK_dead_doubleacute:
      return IIIMF_KEYCODE_DEAD_DOUBLEACUTE;
    case GDK_dead_caron:
      return IIIMF_KEYCODE_DEAD_CARON;
    case GDK_dead_cedilla:
      return IIIMF_KEYCODE_DEAD_CEDILLA;
    case GDK_dead_ogonek:
      return IIIMF_KEYCODE_DEAD_OGONEK;
    case GDK_dead_iota:
      return IIIMF_KEYCODE_DEAD_IOTA;
    case GDK_dead_voiced_sound:
      return IIIMF_KEYCODE_DEAD_VOICED_SOUND;
    case GDK_dead_semivoiced_sound:
      return IIIMF_KEYCODE_DEAD_SEMIVOICED_SOUND;

    case GDK_dead_belowdot:
    case GDK_First_Virtual_Screen:
    case GDK_Prev_Virtual_Screen:
    case GDK_Next_Virtual_Screen:
    case GDK_Last_Virtual_Screen:
    case GDK_Terminate_Server:
    case GDK_AccessX_Enable:
    case GDK_AccessX_Feedback_Enable:
    case GDK_RepeatKeys_Enable:
    case GDK_SlowKeys_Enable:
    case GDK_BounceKeys_Enable:
    case GDK_StickyKeys_Enable:
    case GDK_MouseKeys_Enable:
    case GDK_MouseKeys_Accel_Enable:
    case GDK_Overlay1_Enable:
    case GDK_Overlay2_Enable:
    case GDK_AudibleBell_Enable:
    case GDK_Pointer_Left:
    case GDK_Pointer_Right:
    case GDK_Pointer_Up:
    case GDK_Pointer_Down:
    case GDK_Pointer_UpLeft:
    case GDK_Pointer_UpRight:
    case GDK_Pointer_DownLeft:
    case GDK_Pointer_DownRight:
    case GDK_Pointer_Button_Dflt:
    case GDK_Pointer_Button1:
    case GDK_Pointer_Button2:
    case GDK_Pointer_Button3:
    case GDK_Pointer_Button4:
    case GDK_Pointer_Button5:
    case GDK_Pointer_DblClick_Dflt:
    case GDK_Pointer_DblClick1:
    case GDK_Pointer_DblClick2:
    case GDK_Pointer_DblClick3:
    case GDK_Pointer_DblClick4:
    case GDK_Pointer_DblClick5:
    case GDK_Pointer_Drag_Dflt:
    case GDK_Pointer_Drag1:
    case GDK_Pointer_Drag2:
    case GDK_Pointer_Drag3:
    case GDK_Pointer_Drag4:
    case GDK_Pointer_Drag5:
    case GDK_Pointer_EnableKeys:
    case GDK_Pointer_Accelerate:
    case GDK_Pointer_DfltBtnNext:
    case GDK_Pointer_DfltBtnPrev:
    case GDK_3270_Duplicate:
    case GDK_3270_FieldMark:
    case GDK_3270_Right2:
    case GDK_3270_Left2:
    case GDK_3270_BackTab:
    case GDK_3270_EraseEOF:
    case GDK_3270_EraseInput:
    case GDK_3270_Reset:
    case GDK_3270_Quit:
    case GDK_3270_PA1:
    case GDK_3270_PA2:
    case GDK_3270_PA3:
    case GDK_3270_Test:
    case GDK_3270_Attn:
    case GDK_3270_CursorBlink:
    case GDK_3270_AltCursor:
    case GDK_3270_KeyClick:
    case GDK_3270_Jump:
    case GDK_3270_Ident:
    case GDK_3270_Rule:
    case GDK_3270_Copy:
    case GDK_3270_Play:
    case GDK_3270_Setup:
    case GDK_3270_Record:
    case GDK_3270_ChangeScreen:
    case GDK_3270_DeleteWord:
    case GDK_3270_ExSelect:
    case GDK_3270_CursorSelect:
    case GDK_3270_PrintScreen:
    case GDK_3270_Enter:
      return 0;

    case GDK_space:
      return IIIMF_KEYCODE_SPACE;
    case GDK_exclam:
      return IIIMF_KEYCODE_EXCLAMATION_MARK;
    case GDK_quotedbl:
      return IIIMF_KEYCODE_QUOTEDBL;
    case GDK_numbersign:
      return IIIMF_KEYCODE_NUMBER_SIGN;
    case GDK_dollar:
      return IIIMF_KEYCODE_DOLLAR;
    case GDK_percent:
      /* note that it is a dummy code which assumes US keyboard.
	 Use keychar instead. */
      return IIIMF_KEYCODE_5;
    case GDK_ampersand:
      return IIIMF_KEYCODE_AMPERSAND;
    case GDK_apostrophe:
      /* case GDK_quoteright: */
      return IIIMF_KEYCODE_QUOTE;
    case GDK_parenleft:
      return IIIMF_KEYCODE_LEFT_PARENTHESIS;
    case GDK_parenright:
      return IIIMF_KEYCODE_RIGHT_PARENTHESIS;
    case GDK_asterisk:
      return IIIMF_KEYCODE_ASTERISK;
    case GDK_plus:
      return IIIMF_KEYCODE_PLUS;
    case GDK_comma:
      return IIIMF_KEYCODE_COMMA;
    case GDK_minus:
      return IIIMF_KEYCODE_MINUS;
    case GDK_period:
      return IIIMF_KEYCODE_PERIOD;
    case GDK_slash:
      return IIIMF_KEYCODE_SLASH;
    case GDK_0:
      return IIIMF_KEYCODE_0;
    case GDK_1:
      return IIIMF_KEYCODE_1;
    case GDK_2:
      return IIIMF_KEYCODE_2;
    case GDK_3:
      return IIIMF_KEYCODE_3;
    case GDK_4:
      return IIIMF_KEYCODE_4;
    case GDK_5:
      return IIIMF_KEYCODE_5;
    case GDK_6:
      return IIIMF_KEYCODE_6;
    case GDK_7:
      return IIIMF_KEYCODE_7;
    case GDK_8:
      return IIIMF_KEYCODE_8;
    case GDK_9:
      return IIIMF_KEYCODE_9;
    case GDK_colon:
      return IIIMF_KEYCODE_COLON;
    case GDK_semicolon:
      return IIIMF_KEYCODE_SEMICOLON;
    case GDK_less:
      return IIIMF_KEYCODE_LESS;
    case GDK_equal:
      return IIIMF_KEYCODE_EQUALS;
    case GDK_greater:
      return IIIMF_KEYCODE_GREATER;
    case GDK_question:
      /* note that it is a dummy code which assumes US keyboard.
	 Use keychar instead. */
      return IIIMF_KEYCODE_SLASH;
    case GDK_at:
      return IIIMF_KEYCODE_AT;
    case GDK_A:
      return IIIMF_KEYCODE_A;
    case GDK_B:
      return IIIMF_KEYCODE_B;
    case GDK_C:
      return IIIMF_KEYCODE_C;
    case GDK_D:
      return IIIMF_KEYCODE_D;
    case GDK_E:
      return IIIMF_KEYCODE_E;
    case GDK_F:
      return IIIMF_KEYCODE_F;
    case GDK_G:
      return IIIMF_KEYCODE_G;
    case GDK_H:
      return IIIMF_KEYCODE_H;
    case GDK_I:
      return IIIMF_KEYCODE_I;
    case GDK_J:
      return IIIMF_KEYCODE_J;
    case GDK_K:
      return IIIMF_KEYCODE_K;
    case GDK_L:
      return IIIMF_KEYCODE_L;
    case GDK_M:
      return IIIMF_KEYCODE_M;
    case GDK_N:
      return IIIMF_KEYCODE_N;
    case GDK_O:
      return IIIMF_KEYCODE_O;
    case GDK_P:
      return IIIMF_KEYCODE_P;
    case GDK_Q:
      return IIIMF_KEYCODE_Q;
    case GDK_R:
      return IIIMF_KEYCODE_R;
    case GDK_S:
      return IIIMF_KEYCODE_S;
    case GDK_T:
      return IIIMF_KEYCODE_T;
    case GDK_U:
      return IIIMF_KEYCODE_U;
    case GDK_V:
      return IIIMF_KEYCODE_V;
    case GDK_W:
      return IIIMF_KEYCODE_W;
    case GDK_X:
      return IIIMF_KEYCODE_X;
    case GDK_Y:
      return IIIMF_KEYCODE_Y;
    case GDK_Z:
      return IIIMF_KEYCODE_Z;

    case GDK_bracketleft:
      return IIIMF_KEYCODE_OPEN_BRACKET;
    case GDK_backslash:
      return IIIMF_KEYCODE_BACK_SLASH;
    case GDK_bracketright:
      return IIIMF_KEYCODE_CLOSE_BRACKET;
    case GDK_asciicircum:
      return IIIMF_KEYCODE_CIRCUMFLEX;
    case GDK_underscore:
      return IIIMF_KEYCODE_UNDERSCORE;
    case GDK_grave:
      /* case GDK_quoteleft: */
      return IIIMF_KEYCODE_BACK_QUOTE;

    case GDK_a:
      return IIIMF_KEYCODE_A;
    case GDK_b:
      return IIIMF_KEYCODE_B;
    case GDK_c:
      return IIIMF_KEYCODE_C;
    case GDK_d:
      return IIIMF_KEYCODE_D;
    case GDK_e:
      return IIIMF_KEYCODE_E;
    case GDK_f:
      return IIIMF_KEYCODE_F;
    case GDK_g:
      return IIIMF_KEYCODE_G;
    case GDK_h:
      return IIIMF_KEYCODE_H;
    case GDK_i:
      return IIIMF_KEYCODE_I;
    case GDK_j:
      return IIIMF_KEYCODE_J;
    case GDK_k:
      return IIIMF_KEYCODE_K;
    case GDK_l:
      return IIIMF_KEYCODE_L;
    case GDK_m:
      return IIIMF_KEYCODE_M;
    case GDK_n:
      return IIIMF_KEYCODE_N;
    case GDK_o:
      return IIIMF_KEYCODE_O;
    case GDK_p:
      return IIIMF_KEYCODE_P;
    case GDK_q:
      return IIIMF_KEYCODE_Q;
    case GDK_r:
      return IIIMF_KEYCODE_R;
    case GDK_s:
      return IIIMF_KEYCODE_S;
    case GDK_t:
      return IIIMF_KEYCODE_T;
    case GDK_u:
      return IIIMF_KEYCODE_U;
    case GDK_v:
      return IIIMF_KEYCODE_V;
    case GDK_w:
      return IIIMF_KEYCODE_W;
    case GDK_x:
      return IIIMF_KEYCODE_X;
    case GDK_y:
      return IIIMF_KEYCODE_Y;
    case GDK_z:
      return IIIMF_KEYCODE_Z;
    case GDK_braceleft:
      return IIIMF_KEYCODE_BRACELEFT;
    case GDK_bar:
      return kv;
    case GDK_braceright:
      return IIIMF_KEYCODE_BRACERIGHT;

    case GDK_asciitilde:
    case GDK_nobreakspace:
      return kv;
    case GDK_exclamdown:
      return IIIMF_KEYCODE_INVERTED_EXCLAMATION_MARK;

    case GDK_cent:
    case GDK_sterling:
    case GDK_currency:
    case GDK_yen:
    case GDK_brokenbar:
    case GDK_section:
    case GDK_diaeresis:
    case GDK_copyright:
    case GDK_ordfeminine:
    case GDK_guillemotleft:
    case GDK_notsign:
    case GDK_hyphen:
    case GDK_registered:
    case GDK_macron:
    case GDK_degree:
    case GDK_plusminus:
    case GDK_twosuperior:
    case GDK_threesuperior:
    case GDK_acute:
    case GDK_mu:
    case GDK_paragraph:
    case GDK_periodcentered:
    case GDK_cedilla:
    case GDK_onesuperior:
    case GDK_masculine:
    case GDK_guillemotright:
    case GDK_onequarter:
    case GDK_onehalf:
    case GDK_threequarters:
    case GDK_questiondown:
    case GDK_Agrave:
    case GDK_Aacute:
    case GDK_Acircumflex:
    case GDK_Atilde:
    case GDK_Adiaeresis:
    case GDK_Aring:
    case GDK_AE:
    case GDK_Ccedilla:
    case GDK_Egrave:
    case GDK_Eacute:
    case GDK_Ecircumflex:
    case GDK_Ediaeresis:
    case GDK_Igrave:
    case GDK_Iacute:
    case GDK_Icircumflex:
    case GDK_Idiaeresis:
    case GDK_ETH:
      /* case GDK_Eth: */
    case GDK_Ntilde:
    case GDK_Ograve:
    case GDK_Oacute:
    case GDK_Ocircumflex:
    case GDK_Otilde:
    case GDK_Odiaeresis:
    case GDK_multiply:
    case GDK_Ooblique:
    case GDK_Ugrave:
    case GDK_Uacute:
    case GDK_Ucircumflex:
    case GDK_Udiaeresis:
    case GDK_Yacute:
    case GDK_THORN:
      /* case GDK_Thorn: */
    case GDK_ssharp:
    case GDK_agrave:
    case GDK_aacute:
    case GDK_acircumflex:
    case GDK_atilde:
    case GDK_adiaeresis:
    case GDK_aring:
    case GDK_ae:
    case GDK_ccedilla:
    case GDK_egrave:
    case GDK_eacute:
    case GDK_ecircumflex:
    case GDK_ediaeresis:
    case GDK_igrave:
    case GDK_iacute:
    case GDK_icircumflex:
    case GDK_idiaeresis:
    case GDK_eth:
    case GDK_ntilde:
    case GDK_ograve:
    case GDK_oacute:
    case GDK_ocircumflex:
    case GDK_otilde:
    case GDK_odiaeresis:
    case GDK_division:
    case GDK_oslash:
    case GDK_ugrave:
    case GDK_uacute:
    case GDK_ucircumflex:
    case GDK_udiaeresis:
    case GDK_yacute:
    case GDK_thorn:
    case GDK_ydiaeresis:
    case GDK_Aogonek:
    case GDK_breve:
    case GDK_Lstroke:
    case GDK_Lcaron:
    case GDK_Sacute:
    case GDK_Scaron:
    case GDK_Scedilla:
    case GDK_Tcaron:
    case GDK_Zacute:
    case GDK_Zcaron:
    case GDK_Zabovedot:
    case GDK_aogonek:
    case GDK_ogonek:
    case GDK_lstroke:
    case GDK_lcaron:
    case GDK_sacute:
    case GDK_caron:
    case GDK_scaron:
    case GDK_scedilla:
    case GDK_tcaron:
    case GDK_zacute:
    case GDK_doubleacute:
    case GDK_zcaron:
    case GDK_zabovedot:
    case GDK_Racute:
    case GDK_Abreve:
    case GDK_Lacute:
    case GDK_Cacute:
    case GDK_Ccaron:
    case GDK_Eogonek:
    case GDK_Ecaron:
    case GDK_Dcaron:
    case GDK_Dstroke:
    case GDK_Nacute:
    case GDK_Ncaron:
    case GDK_Odoubleacute:
    case GDK_Rcaron:
    case GDK_Uring:
    case GDK_Udoubleacute:
    case GDK_Tcedilla:
    case GDK_racute:
    case GDK_abreve:
    case GDK_lacute:
    case GDK_cacute:
    case GDK_ccaron:
    case GDK_eogonek:
    case GDK_ecaron:
    case GDK_dcaron:
    case GDK_dstroke:
    case GDK_nacute:
    case GDK_ncaron:
    case GDK_odoubleacute:
    case GDK_udoubleacute:
    case GDK_rcaron:
    case GDK_uring:
    case GDK_tcedilla:
    case GDK_abovedot:
    case GDK_Hstroke:
    case GDK_Hcircumflex:
    case GDK_Iabovedot:
    case GDK_Gbreve:
    case GDK_Jcircumflex:
    case GDK_hstroke:
    case GDK_hcircumflex:
    case GDK_idotless:
    case GDK_gbreve:
    case GDK_jcircumflex:
    case GDK_Cabovedot:
    case GDK_Ccircumflex:
    case GDK_Gabovedot:
    case GDK_Gcircumflex:
    case GDK_Ubreve:
    case GDK_Scircumflex:
    case GDK_cabovedot:
    case GDK_ccircumflex:
    case GDK_gabovedot:
    case GDK_gcircumflex:
    case GDK_ubreve:
    case GDK_scircumflex:
    case GDK_kra:
      /* case GDK_kappa: */
    case GDK_Rcedilla:
    case GDK_Itilde:
    case GDK_Lcedilla:
    case GDK_Emacron:
    case GDK_Gcedilla:
    case GDK_Tslash:
    case GDK_rcedilla:
    case GDK_itilde:
    case GDK_lcedilla:
    case GDK_emacron:
    case GDK_gcedilla:
    case GDK_tslash:
    case GDK_ENG:
    case GDK_eng:
    case GDK_Amacron:
    case GDK_Iogonek:
    case GDK_Eabovedot:
    case GDK_Imacron:
    case GDK_Ncedilla:
    case GDK_Omacron:
    case GDK_Kcedilla:
    case GDK_Uogonek:
    case GDK_Utilde:
    case GDK_Umacron:
    case GDK_amacron:
    case GDK_iogonek:
    case GDK_eabovedot:
    case GDK_imacron:
    case GDK_ncedilla:
    case GDK_omacron:
    case GDK_kcedilla:
    case GDK_uogonek:
    case GDK_utilde:
    case GDK_umacron:
    case GDK_OE:
      /* case GDK_oe: */
    case GDK_Ydiaeresis:
    case GDK_overline:
    case GDK_kana_fullstop:
    case GDK_kana_openingbracket:
    case GDK_kana_closingbracket:
    case GDK_kana_comma:
    case GDK_kana_conjunctive:
      /* case GDK_kana_middledot: */
    case GDK_kana_WO:
    case GDK_kana_a:
    case GDK_kana_i:
    case GDK_kana_u:
    case GDK_kana_e:
    case GDK_kana_o:
    case GDK_kana_ya:
    case GDK_kana_yu:
    case GDK_kana_yo:
    case GDK_kana_tsu:
      /* case GDK_kana_tu: */
    case GDK_prolongedsound:
    case GDK_kana_A:
    case GDK_kana_I:
    case GDK_kana_U:
    case GDK_kana_E:
    case GDK_kana_O:
    case GDK_kana_KA:
    case GDK_kana_KI:
    case GDK_kana_KU:
    case GDK_kana_KE:
    case GDK_kana_KO:
    case GDK_kana_SA:
    case GDK_kana_SHI:
    case GDK_kana_SU:
    case GDK_kana_SE:
    case GDK_kana_SO:
    case GDK_kana_TA:
    case GDK_kana_CHI:
      /* case GDK_kana_TI: */
    case GDK_kana_TSU:
      /* case GDK_kana_TU: */
    case GDK_kana_TE:
    case GDK_kana_TO:
    case GDK_kana_NA:
    case GDK_kana_NI:
    case GDK_kana_NU:
    case GDK_kana_NE:
    case GDK_kana_NO:
    case GDK_kana_HA:
    case GDK_kana_HI:
    case GDK_kana_FU:
      /* case GDK_kana_HU: */
    case GDK_kana_HE:
    case GDK_kana_HO:
    case GDK_kana_MA:
    case GDK_kana_MI:
    case GDK_kana_MU:
    case GDK_kana_ME:
    case GDK_kana_MO:
    case GDK_kana_YA:
    case GDK_kana_YU:
    case GDK_kana_YO:
    case GDK_kana_RA:
    case GDK_kana_RI:
    case GDK_kana_RU:
    case GDK_kana_RE:
    case GDK_kana_RO:
    case GDK_kana_WA:
    case GDK_kana_N:
    case GDK_voicedsound:
    case GDK_semivoicedsound:
      /* case GDK_kana_switch: */
    case GDK_Arabic_comma:
    case GDK_Arabic_semicolon:
    case GDK_Arabic_question_mark:
    case GDK_Arabic_hamza:
    case GDK_Arabic_maddaonalef:
    case GDK_Arabic_hamzaonalef:
    case GDK_Arabic_hamzaonwaw:
    case GDK_Arabic_hamzaunderalef:
    case GDK_Arabic_hamzaonyeh:
    case GDK_Arabic_alef:
    case GDK_Arabic_beh:
    case GDK_Arabic_tehmarbuta:
    case GDK_Arabic_teh:
    case GDK_Arabic_theh:
    case GDK_Arabic_jeem:
    case GDK_Arabic_hah:
    case GDK_Arabic_khah:
    case GDK_Arabic_dal:
    case GDK_Arabic_thal:
    case GDK_Arabic_ra:
    case GDK_Arabic_zain:
    case GDK_Arabic_seen:
    case GDK_Arabic_sheen:
    case GDK_Arabic_sad:
    case GDK_Arabic_dad:
    case GDK_Arabic_tah:
    case GDK_Arabic_zah:
    case GDK_Arabic_ain:
    case GDK_Arabic_ghain:
    case GDK_Arabic_tatweel:
    case GDK_Arabic_feh:
    case GDK_Arabic_qaf:
    case GDK_Arabic_kaf:
    case GDK_Arabic_lam:
    case GDK_Arabic_meem:
    case GDK_Arabic_noon:
    case GDK_Arabic_ha:
      /*case GDK_Arabic_heh:*/
    case GDK_Arabic_waw:
    case GDK_Arabic_alefmaksura:
    case GDK_Arabic_yeh:
    case GDK_Arabic_fathatan:
    case GDK_Arabic_dammatan:
    case GDK_Arabic_kasratan:
    case GDK_Arabic_fatha:
    case GDK_Arabic_damma:
    case GDK_Arabic_kasra:
    case GDK_Arabic_shadda:
    case GDK_Arabic_sukun:
      /* case GDK_Arabic_switch: */
    case GDK_Serbian_dje:
    case GDK_Macedonia_gje:
    case GDK_Cyrillic_io:
    case GDK_Ukrainian_ie:
      /* case GDK_Ukranian_je: */
    case GDK_Macedonia_dse:
    case GDK_Ukrainian_i:
      /* case GDK_Ukranian_i: */
    case GDK_Ukrainian_yi:
      /* case GDK_Ukranian_yi: */
    case GDK_Cyrillic_je:
      /* case GDK_Serbian_je: */
    case GDK_Cyrillic_lje:
      /* case GDK_Serbian_lje: */
    case GDK_Cyrillic_nje:
      /* case GDK_Serbian_nje: */
    case GDK_Serbian_tshe:
    case GDK_Macedonia_kje:
    case GDK_Byelorussian_shortu:
    case GDK_Cyrillic_dzhe:
      /* case GDK_Serbian_dze: */
    case GDK_numerosign:
    case GDK_Serbian_DJE:
    case GDK_Macedonia_GJE:
    case GDK_Cyrillic_IO:
    case GDK_Ukrainian_IE:
      /* case GDK_Ukranian_JE: */
    case GDK_Macedonia_DSE:
    case GDK_Ukrainian_I:
      /* case GDK_Ukranian_I: */
    case GDK_Ukrainian_YI:
      /* case GDK_Ukranian_YI: */
    case GDK_Cyrillic_JE:
      /* case GDK_Serbian_JE: */
    case GDK_Cyrillic_LJE:
      /* case GDK_Serbian_LJE: */
    case GDK_Cyrillic_NJE:
      /* case GDK_Serbian_NJE: */
    case GDK_Serbian_TSHE:
    case GDK_Macedonia_KJE:
    case GDK_Byelorussian_SHORTU:
    case GDK_Cyrillic_DZHE:
      /* case GDK_Serbian_DZE: */
    case GDK_Cyrillic_yu:
    case GDK_Cyrillic_a:
    case GDK_Cyrillic_be:
    case GDK_Cyrillic_tse:
    case GDK_Cyrillic_de:
    case GDK_Cyrillic_ie:
    case GDK_Cyrillic_ef:
    case GDK_Cyrillic_ghe:
    case GDK_Cyrillic_ha:
    case GDK_Cyrillic_i:
    case GDK_Cyrillic_shorti:
    case GDK_Cyrillic_ka:
    case GDK_Cyrillic_el:
    case GDK_Cyrillic_em:
    case GDK_Cyrillic_en:
    case GDK_Cyrillic_o:
    case GDK_Cyrillic_pe:
    case GDK_Cyrillic_ya:
    case GDK_Cyrillic_er:
    case GDK_Cyrillic_es:
    case GDK_Cyrillic_te:
    case GDK_Cyrillic_u:
    case GDK_Cyrillic_zhe:
    case GDK_Cyrillic_ve:
    case GDK_Cyrillic_softsign:
    case GDK_Cyrillic_yeru:
    case GDK_Cyrillic_ze:
    case GDK_Cyrillic_sha:
    case GDK_Cyrillic_e:
    case GDK_Cyrillic_shcha:
    case GDK_Cyrillic_che:
    case GDK_Cyrillic_hardsign:
    case GDK_Cyrillic_YU:
    case GDK_Cyrillic_A:
    case GDK_Cyrillic_BE:
    case GDK_Cyrillic_TSE:
    case GDK_Cyrillic_DE:
    case GDK_Cyrillic_IE:
    case GDK_Cyrillic_EF:
    case GDK_Cyrillic_GHE:
    case GDK_Cyrillic_HA:
    case GDK_Cyrillic_I:
    case GDK_Cyrillic_SHORTI:
    case GDK_Cyrillic_KA:
    case GDK_Cyrillic_EL:
    case GDK_Cyrillic_EM:
    case GDK_Cyrillic_EN:
    case GDK_Cyrillic_O:
    case GDK_Cyrillic_PE:
    case GDK_Cyrillic_YA:
    case GDK_Cyrillic_ER:
    case GDK_Cyrillic_ES:
    case GDK_Cyrillic_TE:
    case GDK_Cyrillic_U:
    case GDK_Cyrillic_ZHE:
    case GDK_Cyrillic_VE:
    case GDK_Cyrillic_SOFTSIGN:
    case GDK_Cyrillic_YERU:
    case GDK_Cyrillic_ZE:
    case GDK_Cyrillic_SHA:
    case GDK_Cyrillic_E:
    case GDK_Cyrillic_SHCHA:
    case GDK_Cyrillic_CHE:
    case GDK_Cyrillic_HARDSIGN:
    case GDK_Greek_ALPHAaccent:
    case GDK_Greek_EPSILONaccent:
    case GDK_Greek_ETAaccent:
    case GDK_Greek_IOTAaccent:
    case GDK_Greek_IOTAdiaeresis:
    case GDK_Greek_OMICRONaccent:
    case GDK_Greek_UPSILONaccent:
    case GDK_Greek_UPSILONdieresis:
    case GDK_Greek_OMEGAaccent:
    case GDK_Greek_accentdieresis:
    case GDK_Greek_horizbar:
    case GDK_Greek_alphaaccent:
    case GDK_Greek_epsilonaccent:
    case GDK_Greek_etaaccent:
    case GDK_Greek_iotaaccent:
    case GDK_Greek_iotadieresis:
    case GDK_Greek_iotaaccentdieresis:
    case GDK_Greek_omicronaccent:
    case GDK_Greek_upsilonaccent:
    case GDK_Greek_upsilondieresis:
    case GDK_Greek_upsilonaccentdieresis:
    case GDK_Greek_omegaaccent:
    case GDK_Greek_ALPHA:
    case GDK_Greek_BETA:
    case GDK_Greek_GAMMA:
    case GDK_Greek_DELTA:
    case GDK_Greek_EPSILON:
    case GDK_Greek_ZETA:
    case GDK_Greek_ETA:
    case GDK_Greek_THETA:
    case GDK_Greek_IOTA:
    case GDK_Greek_KAPPA:
    case GDK_Greek_LAMDA:
      /* case GDK_Greek_LAMBDA: */
    case GDK_Greek_MU:
    case GDK_Greek_NU:
    case GDK_Greek_XI:
    case GDK_Greek_OMICRON:
    case GDK_Greek_PI:
    case GDK_Greek_RHO:
    case GDK_Greek_SIGMA:
    case GDK_Greek_TAU:
    case GDK_Greek_UPSILON:
    case GDK_Greek_PHI:
    case GDK_Greek_CHI:
    case GDK_Greek_PSI:
    case GDK_Greek_OMEGA:
    case GDK_Greek_alpha:
    case GDK_Greek_beta:
    case GDK_Greek_gamma:
    case GDK_Greek_delta:
    case GDK_Greek_epsilon:
    case GDK_Greek_zeta:
    case GDK_Greek_eta:
    case GDK_Greek_theta:
    case GDK_Greek_iota:
    case GDK_Greek_kappa:
    case GDK_Greek_lamda:
      /* case GDK_Greek_lambda: */
    case GDK_Greek_mu:
    case GDK_Greek_nu:
    case GDK_Greek_xi:
    case GDK_Greek_omicron:
    case GDK_Greek_pi:
    case GDK_Greek_rho:
    case GDK_Greek_sigma:
    case GDK_Greek_finalsmallsigma:
    case GDK_Greek_tau:
    case GDK_Greek_upsilon:
    case GDK_Greek_phi:
    case GDK_Greek_chi:
    case GDK_Greek_psi:
    case GDK_Greek_omega:
      /* case GDK_Greek_switch: */
    case GDK_leftradical:
    case GDK_topleftradical:
    case GDK_horizconnector:
    case GDK_topintegral:
    case GDK_botintegral:
    case GDK_vertconnector:
    case GDK_topleftsqbracket:
    case GDK_botleftsqbracket:
    case GDK_toprightsqbracket:
    case GDK_botrightsqbracket:
    case GDK_topleftparens:
    case GDK_botleftparens:
    case GDK_toprightparens:
    case GDK_botrightparens:
    case GDK_leftmiddlecurlybrace:
    case GDK_rightmiddlecurlybrace:
    case GDK_topleftsummation:
    case GDK_botleftsummation:
    case GDK_topvertsummationconnector:
    case GDK_botvertsummationconnector:
    case GDK_toprightsummation:
    case GDK_botrightsummation:
    case GDK_rightmiddlesummation:
    case GDK_lessthanequal:
    case GDK_notequal:
    case GDK_greaterthanequal:
    case GDK_integral:
    case GDK_therefore:
    case GDK_variation:
    case GDK_infinity:
    case GDK_nabla:
    case GDK_approximate:
    case GDK_similarequal:
    case GDK_ifonlyif:
    case GDK_implies:
    case GDK_identical:
    case GDK_radical:
    case GDK_includedin:
    case GDK_includes:
    case GDK_intersection:
    case GDK_union:
    case GDK_logicaland:
    case GDK_logicalor:
    case GDK_partialderivative:
    case GDK_function:
    case GDK_leftarrow:
    case GDK_uparrow:
    case GDK_rightarrow:
    case GDK_downarrow:
    case GDK_blank:
    case GDK_soliddiamond:
    case GDK_checkerboard:
    case GDK_ht:
    case GDK_ff:
    case GDK_cr:
    case GDK_lf:
    case GDK_nl:
    case GDK_vt:
    case GDK_lowrightcorner:
    case GDK_uprightcorner:
    case GDK_upleftcorner:
    case GDK_lowleftcorner:
    case GDK_crossinglines:
    case GDK_horizlinescan1:
    case GDK_horizlinescan3:
    case GDK_horizlinescan5:
    case GDK_horizlinescan7:
    case GDK_horizlinescan9:
    case GDK_leftt:
    case GDK_rightt:
    case GDK_bott:
    case GDK_topt:
    case GDK_vertbar:
    case GDK_emspace:
    case GDK_enspace:
    case GDK_em3space:
    case GDK_em4space:
    case GDK_digitspace:
    case GDK_punctspace:
    case GDK_thinspace:
    case GDK_hairspace:
    case GDK_emdash:
    case GDK_endash:
    case GDK_signifblank:
    case GDK_ellipsis:
    case GDK_doubbaselinedot:
    case GDK_onethird:
    case GDK_twothirds:
    case GDK_onefifth:
    case GDK_twofifths:
    case GDK_threefifths:
    case GDK_fourfifths:
    case GDK_onesixth:
    case GDK_fivesixths:
    case GDK_careof:
    case GDK_figdash:
    case GDK_leftanglebracket:
    case GDK_decimalpoint:
    case GDK_rightanglebracket:
    case GDK_marker:
    case GDK_oneeighth:
    case GDK_threeeighths:
    case GDK_fiveeighths:
    case GDK_seveneighths:
    case GDK_trademark:
    case GDK_signaturemark:
    case GDK_trademarkincircle:
    case GDK_leftopentriangle:
    case GDK_rightopentriangle:
    case GDK_emopencircle:
    case GDK_emopenrectangle:
    case GDK_leftsinglequotemark:
    case GDK_rightsinglequotemark:
    case GDK_leftdoublequotemark:
    case GDK_rightdoublequotemark:
    case GDK_prescription:
    case GDK_minutes:
    case GDK_seconds:
    case GDK_latincross:
    case GDK_hexagram:
    case GDK_filledrectbullet:
    case GDK_filledlefttribullet:
    case GDK_filledrighttribullet:
    case GDK_emfilledcircle:
    case GDK_emfilledrect:
    case GDK_enopencircbullet:
    case GDK_enopensquarebullet:
    case GDK_openrectbullet:
    case GDK_opentribulletup:
    case GDK_opentribulletdown:
    case GDK_openstar:
    case GDK_enfilledcircbullet:
    case GDK_enfilledsqbullet:
    case GDK_filledtribulletup:
    case GDK_filledtribulletdown:
    case GDK_leftpointer:
    case GDK_rightpointer:
    case GDK_club:
    case GDK_diamond:
    case GDK_heart:
    case GDK_maltesecross:
    case GDK_dagger:
    case GDK_doubledagger:
    case GDK_checkmark:
    case GDK_ballotcross:
    case GDK_musicalsharp:
    case GDK_musicalflat:
    case GDK_malesymbol:
    case GDK_femalesymbol:
    case GDK_telephone:
    case GDK_telephonerecorder:
    case GDK_phonographcopyright:
    case GDK_caret:
    case GDK_singlelowquotemark:
    case GDK_doublelowquotemark:
    case GDK_cursor:
    case GDK_leftcaret:
    case GDK_rightcaret:
    case GDK_downcaret:
    case GDK_upcaret:
    case GDK_overbar:
    case GDK_downtack:
    case GDK_upshoe:
    case GDK_downstile:
    case GDK_underbar:
    case GDK_jot:
    case GDK_quad:
    case GDK_uptack:
    case GDK_circle:
    case GDK_upstile:
    case GDK_downshoe:
    case GDK_rightshoe:
    case GDK_leftshoe:
    case GDK_lefttack:
    case GDK_righttack:
    case GDK_hebrew_doublelowline:
    case GDK_hebrew_aleph:
    case GDK_hebrew_bet:
      /* case GDK_hebrew_beth: */
    case GDK_hebrew_gimel:
      /* case GDK_hebrew_gimmel: */
    case GDK_hebrew_dalet:
      /* case GDK_hebrew_daleth: */
    case GDK_hebrew_he:
    case GDK_hebrew_waw:
    case GDK_hebrew_zain:
      /* case GDK_hebrew_zayin: */
    case GDK_hebrew_chet:
      /* case GDK_hebrew_het: */
    case GDK_hebrew_tet:
      /* case GDK_hebrew_teth: */
    case GDK_hebrew_yod:
    case GDK_hebrew_finalkaph:
    case GDK_hebrew_kaph:
    case GDK_hebrew_lamed:
    case GDK_hebrew_finalmem:
    case GDK_hebrew_mem:
    case GDK_hebrew_finalnun:
    case GDK_hebrew_nun:
    case GDK_hebrew_samech:
      /* case GDK_hebrew_samekh: */
    case GDK_hebrew_ayin:
    case GDK_hebrew_finalpe:
    case GDK_hebrew_pe:
    case GDK_hebrew_finalzade:
      /* case GDK_hebrew_finalzadi: */
    case GDK_hebrew_zade:
      /* case GDK_hebrew_zadi: */
    case GDK_hebrew_qoph:
      /* case GDK_hebrew_kuf: */
    case GDK_hebrew_resh:
    case GDK_hebrew_shin:
    case GDK_hebrew_taw:
      /* case GDK_hebrew_taf: */
      /* case GDK_Hebrew_switch: */
    case GDK_Thai_kokai:
    case GDK_Thai_khokhai:
    case GDK_Thai_khokhuat:
    case GDK_Thai_khokhwai:
    case GDK_Thai_khokhon:
    case GDK_Thai_khorakhang:
    case GDK_Thai_ngongu:
    case GDK_Thai_chochan:
    case GDK_Thai_choching:
    case GDK_Thai_chochang:
    case GDK_Thai_soso:
    case GDK_Thai_chochoe:
    case GDK_Thai_yoying:
    case GDK_Thai_dochada:
    case GDK_Thai_topatak:
    case GDK_Thai_thothan:
    case GDK_Thai_thonangmontho:
    case GDK_Thai_thophuthao:
    case GDK_Thai_nonen:
    case GDK_Thai_dodek:
    case GDK_Thai_totao:
    case GDK_Thai_thothung:
    case GDK_Thai_thothahan:
    case GDK_Thai_thothong:
    case GDK_Thai_nonu:
    case GDK_Thai_bobaimai:
    case GDK_Thai_popla:
    case GDK_Thai_phophung:
    case GDK_Thai_fofa:
    case GDK_Thai_phophan:
    case GDK_Thai_fofan:
    case GDK_Thai_phosamphao:
    case GDK_Thai_moma:
    case GDK_Thai_yoyak:
    case GDK_Thai_rorua:
    case GDK_Thai_ru:
    case GDK_Thai_loling:
    case GDK_Thai_lu:
    case GDK_Thai_wowaen:
    case GDK_Thai_sosala:
    case GDK_Thai_sorusi:
    case GDK_Thai_sosua:
    case GDK_Thai_hohip:
    case GDK_Thai_lochula:
    case GDK_Thai_oang:
    case GDK_Thai_honokhuk:
    case GDK_Thai_paiyannoi:
    case GDK_Thai_saraa:
    case GDK_Thai_maihanakat:
    case GDK_Thai_saraaa:
    case GDK_Thai_saraam:
    case GDK_Thai_sarai:
    case GDK_Thai_saraii:
    case GDK_Thai_saraue:
    case GDK_Thai_sarauee:
    case GDK_Thai_sarau:
    case GDK_Thai_sarauu:
    case GDK_Thai_phinthu:
    case GDK_Thai_maihanakat_maitho:
    case GDK_Thai_baht:
    case GDK_Thai_sarae:
    case GDK_Thai_saraae:
    case GDK_Thai_sarao:
    case GDK_Thai_saraaimaimuan:
    case GDK_Thai_saraaimaimalai:
    case GDK_Thai_lakkhangyao:
    case GDK_Thai_maiyamok:
    case GDK_Thai_maitaikhu:
    case GDK_Thai_maiek:
    case GDK_Thai_maitho:
    case GDK_Thai_maitri:
    case GDK_Thai_maichattawa:
    case GDK_Thai_thanthakhat:
    case GDK_Thai_nikhahit:
    case GDK_Thai_leksun:
    case GDK_Thai_leknung:
    case GDK_Thai_leksong:
    case GDK_Thai_leksam:
    case GDK_Thai_leksi:
    case GDK_Thai_lekha:
    case GDK_Thai_lekhok:
    case GDK_Thai_lekchet:
    case GDK_Thai_lekpaet:
    case GDK_Thai_lekkao:
    case GDK_Hangul:
    case GDK_Hangul_Start:
    case GDK_Hangul_End:
    case GDK_Hangul_Hanja:
    case GDK_Hangul_Jamo:
    case GDK_Hangul_Romaja:
      /* case GDK_Hangul_Codeinput: */
    case GDK_Hangul_Jeonja:
    case GDK_Hangul_Banja:
    case GDK_Hangul_PreHanja:
    case GDK_Hangul_PostHanja:
      /* case GDK_Hangul_SingleCandidate: */
      /* case GDK_Hangul_MultipleCandidate: */
      /* case GDK_Hangul_PreviousCandidate: */
    case GDK_Hangul_Special:
      /* case GDK_Hangul_switch: */
    case GDK_Hangul_Kiyeog:
    case GDK_Hangul_SsangKiyeog:
    case GDK_Hangul_KiyeogSios:
    case GDK_Hangul_Nieun:
    case GDK_Hangul_NieunJieuj:
    case GDK_Hangul_NieunHieuh:
    case GDK_Hangul_Dikeud:
    case GDK_Hangul_SsangDikeud:
    case GDK_Hangul_Rieul:
    case GDK_Hangul_RieulKiyeog:
    case GDK_Hangul_RieulMieum:
    case GDK_Hangul_RieulPieub:
    case GDK_Hangul_RieulSios:
    case GDK_Hangul_RieulTieut:
    case GDK_Hangul_RieulPhieuf:
    case GDK_Hangul_RieulHieuh:
    case GDK_Hangul_Mieum:
    case GDK_Hangul_Pieub:
    case GDK_Hangul_SsangPieub:
    case GDK_Hangul_PieubSios:
    case GDK_Hangul_Sios:
    case GDK_Hangul_SsangSios:
    case GDK_Hangul_Ieung:
    case GDK_Hangul_Jieuj:
    case GDK_Hangul_SsangJieuj:
    case GDK_Hangul_Cieuc:
    case GDK_Hangul_Khieuq:
    case GDK_Hangul_Tieut:
    case GDK_Hangul_Phieuf:
    case GDK_Hangul_Hieuh:
    case GDK_Hangul_A:
    case GDK_Hangul_AE:
    case GDK_Hangul_YA:
    case GDK_Hangul_YAE:
    case GDK_Hangul_EO:
    case GDK_Hangul_E:
    case GDK_Hangul_YEO:
    case GDK_Hangul_YE:
    case GDK_Hangul_O:
    case GDK_Hangul_WA:
    case GDK_Hangul_WAE:
    case GDK_Hangul_OE:
    case GDK_Hangul_YO:
    case GDK_Hangul_U:
    case GDK_Hangul_WEO:
    case GDK_Hangul_WE:
    case GDK_Hangul_WI:
    case GDK_Hangul_YU:
    case GDK_Hangul_EU:
    case GDK_Hangul_YI:
    case GDK_Hangul_I:
    case GDK_Hangul_J_Kiyeog:
    case GDK_Hangul_J_SsangKiyeog:
    case GDK_Hangul_J_KiyeogSios:
    case GDK_Hangul_J_Nieun:
    case GDK_Hangul_J_NieunJieuj:
    case GDK_Hangul_J_NieunHieuh:
    case GDK_Hangul_J_Dikeud:
    case GDK_Hangul_J_Rieul:
    case GDK_Hangul_J_RieulKiyeog:
    case GDK_Hangul_J_RieulMieum:
    case GDK_Hangul_J_RieulPieub:
    case GDK_Hangul_J_RieulSios:
    case GDK_Hangul_J_RieulTieut:
    case GDK_Hangul_J_RieulPhieuf:
    case GDK_Hangul_J_RieulHieuh:
    case GDK_Hangul_J_Mieum:
    case GDK_Hangul_J_Pieub:
    case GDK_Hangul_J_PieubSios:
    case GDK_Hangul_J_Sios:
    case GDK_Hangul_J_SsangSios:
    case GDK_Hangul_J_Ieung:
    case GDK_Hangul_J_Jieuj:
    case GDK_Hangul_J_Cieuc:
    case GDK_Hangul_J_Khieuq:
    case GDK_Hangul_J_Tieut:
    case GDK_Hangul_J_Phieuf:
    case GDK_Hangul_J_Hieuh:
    case GDK_Hangul_RieulYeorinHieuh:
    case GDK_Hangul_SunkyeongeumMieum:
    case GDK_Hangul_SunkyeongeumPieub:
    case GDK_Hangul_PanSios:
    case GDK_Hangul_KkogjiDalrinIeung:
    case GDK_Hangul_SunkyeongeumPhieuf:
    case GDK_Hangul_YeorinHieuh:
    case GDK_Hangul_AraeA:
    case GDK_Hangul_AraeAE:
    case GDK_Hangul_J_PanSios:
    case GDK_Hangul_J_KkogjiDalrinIeung:
    case GDK_Hangul_J_YeorinHieuh:
    case GDK_Korean_Won:
    case GDK_EcuSign:
    case GDK_ColonSign:
    case GDK_CruzeiroSign:
    case GDK_FFrancSign:
    case GDK_LiraSign:
    case GDK_MillSign:
    case GDK_NairaSign:
    case GDK_PesetaSign:
    case GDK_RupeeSign:
    case GDK_WonSign:
    case GDK_NewSheqelSign:
    case GDK_DongSign:
      return kv;

    case GDK_EuroSign:
      return IIIMF_KEYCODE_EURO_SIGN;
    }

  return 0;
}

static int
modifier (guint st)
{
  int mod = 0;

  if (st & GDK_SHIFT_MASK)
    {
      mod |= IIIMF_SHIFT_MODIFIER;
    }
  if (st & GDK_CONTROL_MASK)
    {
      mod |= IIIMF_CONTROL_MODIFIER;
    }
  if (st & GDK_MOD2_MASK)
    {
      mod |= IIIMF_META_MODIFIER;
    }
  if (st & GDK_MOD1_MASK)
    {
      mod |= IIIMF_ALT_MODIFIER;
    }

  return mod;
}

IIIMF_status
convert_GdkEventKey_to_IIIMCF_keyevent (GdkEventKey *e,
					IIIMCF_keyevent *pkev)
{
  int c;

  c = g2icode (e->keyval);
  if (c == 0) return IIIMF_STATUS_FAIL;

  if (c < 0)
    {
      pkev->keychar = 0;
      pkev->keycode = -c;
    }
  else
    {
      pkev->keychar = gdk_keyval_to_unicode (e->keyval);
      pkev->keycode = c;
    }
  pkev->modifier = modifier (e->state);

  pkev->time_stamp = e->time;

  return IIIMF_STATUS_SUCCESS;
}

#if 0 /* TODO? */
IIIMF_status
convert_IIIMCF_keyevent_to_GdkEventKey (IIIMCF_keyevent *pkev,
					int pressp,
					GdkEventKey **pe)
{
  int c, s;

  c = i2gcode(pkev->keycode);

  if (!c) return IIIMF_STATUS_FAIL;

  s = 0;
  if (pkev->modifier & IIIMF_SHIFT_MODIFIER)
    {
      s |= Qt::ShiftButton;
    }
  if (pkev->modifier & IIIMF_CONTROL_MODIFIER)
    {
      s |= Qt::ControlButton;
    }
  if (pkev->modifier & IIIMF_META_MODIFIER)
    {
      s |= Qt::MetaButton;
    }
  if (pkev->modifier & IIIMF_ALT_MODIFIER)
    {
      s |= Qt::AltButton;
    }

  if (pressp)
    *pe = new QKeyEvent(QEvent::KeyPress, c, pkev->keychar, s);
  else
    *pe = new QKeyEvent(QEvent::KeyRelease, c, pkev->keychar, s);

  return IIIMF_STATUS_SUCCESS;
}
#endif

/* Local Variables: */
/* c-file-style: "gnu" */
/* End: */
