#ifndef IMSVR_HH_
#define IMSVR_HH_
#include <vector>
#include "basictype.hh"
#include "IMAccept.hh"
#include "IMAuth.hh"
#include "IMUserMgr.hh"
#include "IMUtil.hh"

class IMSvrCfg;
class IMConnection;
class LEMgr;
class IMProtocol;

class IMSvr : public IMAccept
{
    IMSvrCfg *pcfg;
    IMUserMgr usermgr;
    LEMgr *plemgr;
    IMProtocol *pimprotocol;
    IMSocketAddressVec addrvec;

    typedef list<IMConnection*> IMConnectionList;
    IMConnectionList imclist;

    IMConnection* create_imconnection(
	IMUser *puser,
	const string &hostname
    );

  protected:
    // configuration methods.
    bool config_lepath(
	const char* lepath
    );
    bool config_listenaddress(
	IMSocketAddressVec& addrvec
    );

  public:
    // IMAccept realization.

    virtual bool request_accept(
	int fd
    );
    virtual IMHandler* request_connect(
	int fd,
	const u16string &username,
	const string &hostname,
	const u16string &password,
	const IMAuthList &authlist
    );
    
  public:
    LEMgr* get_lemgr()
    { return plemgr; }

    enum IMSVR_EXIT_CODE {
	    IMSVR_EXIT_SUCCESS = 0,
	    IMSVR_CONFIG_ERROR = 100,
	    IMSVR_SYSTEM_ERROR = 255
    };

    bool remove_imconnection(
	IMConnection* pc
    );

    void reload() {}
    void terminate();
    int start();
    IMSvr(IMSvrCfg *p_cfg);
    virtual ~IMSvr();

  friend class IMSvrCfg;
};

#endif /* not IMSVR_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
