#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include "LEMgr.hh"
#include "IMInputContext.hh"
#include "IMLog.hh"
#include "IMUtil.hh"

void
LEMgr::listup_LEs()
{
    DirectoryInfo di;
    DirectoryInfoVec::iterator i;
    DirectoryInfoVec *pdv;

    if (!di.refresh(lepath.c_str())) return;
    pdv = di.get_directory_info();
    for (i = pdv->begin(); i != pdv->end();i++) {
	LEBase *pleb = new LEBase(i->dirname, i->filename);
	// memory error.
	if (!pleb) return;
	if (pleb->errorp()) {
	    delete pleb;
	    continue;
	}
	levec.push_back(pleb);
    }
    psunim_default_lebase = new LEBase(LEBase::SUNIM_DEFAULT);
    if (!psunim_default_lebase || psunim_default_lebase->errorp()) {
	LOG_ERROR("Could not create default sunim LE.  Exit.");
	// TODO! we should use exception.
	exit(255);
    }
}

bool
LEMgr::initialize_ledata()
{
    LEBaseVec::iterator itl;
    LEBase* ple;
    const IMLangList *piml;
    const IMDescriptorList *pimd;
    const IMObjectWithDescList *pimodl;
    
    langlist.erase(langlist.begin(), langlist.end());
    for (itl = levec.begin();itl != levec.end();itl++) {
	ple = *itl;
	piml = ple->get_langlist();
	if (piml) {
	    langlist.insert(langlist.end(), piml->begin(), piml->end());
	}
	pimd = ple->get_imdesclist();
	if (pimd) {
	    imdesclist.insert(imdesclist.end(), pimd->begin(), pimd->end());
	}
	pimodl = ple->get_objectdesclist();
	if (pimd) {
	    imobjectdesclist.insert(imobjectdesclist.end(),
				    pimodl->begin(), pimodl->end());
	}
    }

    langlist.sort();
    langlist.unique();

    ledata_inited = true;
    return true;
}

const IMLangList*
LEMgr::get_all_langlist()
{
    if (!ledata_inited) initialize_ledata();
    return &langlist;
}

const IMDescriptorList*
LEMgr::get_all_imdesclist()
{
    if (!ledata_inited) initialize_ledata();
    return &imdesclist;
}

const IMObjectWithDescList*
LEMgr::get_all_imobjectdesclist()
{
    if (!ledata_inited) initialize_ledata();
    return &imobjectdesclist;
}

LEContext*
LEMgr::choose_LE(
    IMInputContext *pic
)
{
    const ICAttribute &attr = pic->get_icattr();
    LEBaseVec::iterator itl;
    LEBase* ple;
    const IMLangList *pimll;
    const IMLang *piml = NULL;
    const string *preq_lang = NULL;
    const u16string *preq_imdesc = NULL;

    if (!attr.get_inputlanguage().empty()) {
	preq_lang = attr.get_inputlanguage().get_string();
	if (!preq_lang) goto notfound;
    }
    if (!attr.get_inputmethod().empty()) {
	preq_imdesc = &attr.get_inputmethod();
    }

    for (itl = levec.begin();itl != levec.end();itl++) {
	ple = *itl;

	// choose LE by language.
	if (preq_lang) {
	    IMLangList::const_iterator itlang;
	    pimll = ple->get_langlist();
	    if (!pimll) continue;
	    itlang = find_if(pimll->begin(), pimll->end(), IMLangMatchPredicate(preq_lang));
	    if (itlang != pimll->end()) {
		piml = &*itlang;
	    } else {
		continue;
	    }
	}

	// choose LE by imname.
	if (preq_imdesc) {
	    IMDescriptorList::const_iterator itimd;
	    const IMDescriptorList *pimd = ple->get_imdesclist();
	    if (!pimd) continue;
	    itimd = find_if(pimd->begin(), pimd->end(),
			    IMDescriptorMatchPredicate(preq_imdesc));
	    if (itimd != pimd->end()) {
		break;
	    } else {
		continue;
	    }
	}
	break;
    }
    if (itl == levec.end()) goto notfound;

    if (piml) {
	return ple->create_lecontext(pic, piml->get_id());
    }

    return ple->create_lecontext(pic, NULL);

notfound:
    return psunim_default_lebase->create_lecontext(pic, NULL);
}

LEMgr::LEMgr(
    const char* x_lepath
)
{
    lepath = x_lepath;
    ledata_inited = false;
    listup_LEs();
}

LEMgr::~LEMgr()
{
    delete_all(levec);
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
