/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include "guiIM.h"
#include "XimpIm.h"
#include "iiimpDL.h"

static void ChangeStatus(XIC, StatusAttr, XPointer);
static void ChangePreedit(XIC, PreeditAttr, XPointer);

static Bool
SetInputStyle(XicCommon ic, XIMArg *values) {
  XIMArg *p;
  XimCommon im = (XimCommon)ic->core.im;
  Bool status = False;

  for (p = values; p->name != NULL; p++) {
    if (strcmp(p->name, XNInputStyle) == 0) {
      ic->core.input_style = (XIMStyle)p->value;
      ic->ximp_icpart->value_mask |= XIMP_INPUT_STYLE;

      if (ic->core.input_style & XIMStatusArea)
	XIC_GUI(ic, change_status) = ChangeStatusArea;
      else if (ic->core.input_style & XIMStatusNothing)
	XIC_GUI(ic, change_status) = ChangeStatusNothing;

      if (ic->core.input_style & XIMPreeditArea)
	XIC_GUI(ic, change_preedit) = ChangePreeditArea;
      else if (ic->core.input_style & XIMPreeditPosition)
	XIC_GUI(ic, change_preedit) = ChangePreeditPosition;
      else if (ic->core.input_style & XIMPreeditNothing)
	XIC_GUI(ic, change_preedit) = ChangePreeditNothing;
      status = True;
      break;
    }
  }
  /* Set fallback lookup method */
  XIC_GUI(ic, change_lookup) = ChangeLookup;

  if (im->dl_impart) {
    XIMStyles *styles = im->dl_impart->styles;
    int i;
    if (styles && styles->count_styles != 0) {
      for (i = 0; i < styles->count_styles; i++) {
	if (ic->core.input_style == styles->supported_styles[i]) {
	  if (im->dl_impart->change_status)
	    XIC_GUI(ic, change_status) = im->dl_impart->change_status;
	  if (im->dl_impart->change_preedit)
	    XIC_GUI(ic, change_preedit) = im->dl_impart->change_preedit;
	  if (im->dl_impart->change_lookup)
	    XIC_GUI(ic, change_lookup) = im->dl_impart->change_lookup;
	  break;
	}
      }
    }
  }

  return status;
}

extern XICGUI
CreateGUI(XicCommon ic, XIMArg *arg) {
  XICGUIRec* gui_icpart = 0;
  XimCommon im = (XimCommon)ic->core.im;

  gui_icpart = (XICGUIRec*)Xmalloc(sizeof(XICGUIRec));
  if (!gui_icpart) return 0;

  memset(gui_icpart, 0, sizeof(XICGUIRec));
  ic->gui_icpart = gui_icpart;

  XIC_GUI(ic, change_status) = ChangeStatus; /* default */
  XIC_GUI(ic, change_preedit) = ChangePreedit; /* default */

  SetScreenNumber(ic);

  /* register a handler for dl_impart to return key events */
  if (im->dl_impart &&
      im->dl_impart->register_forwardevent)
    im->dl_impart->register_forwardevent((XIC)ic, IMForwardEvent);

  /* Need to set inputstyle to the ic first */
  if (!SetInputStyle(ic, arg)) {
    Xfree(gui_icpart);
    return 0;
  }
  ic->gui_icpart = gui_icpart;
  return gui_icpart;
}

static void
ChangeStatus(XIC xic, StatusAttr reason, XPointer call_data) {
  /* do nothing  */
  return;
}

static void
ChangePreedit(XIC xic, PreeditAttr reason, XPointer call_data) {
  /* do nothing  */
  return;
}

extern void
DestroyGUI(XicCommon ic) {
  if (ic->gui_icpart) Xfree(ic->gui_icpart);
  ic->gui_icpart = 0;
}

void
SetScreenNumber(XicCommon ic) {
  XWindowAttributes attr;
  if (None != ic->core.focus_window) {
    if (XGetWindowAttributes(ic->core.im->core.display,
			     ic->core.focus_window, &attr)) {
      XIC_GUI(ic, screen_number) = XScreenNumberOfScreen(attr.screen);
    } else {
      XIC_GUI(ic, screen_number) = DefaultScreen(ic->core.im->core.display);
    }
  } else {
    XIC_GUI(ic, screen_number) = DefaultScreen(ic->core.im->core.display);
  }
}
