#include <stdio.h>
#include "codetable.h"

#define MAX_SEARCH_NUM	32	
#define MAX_CHAR_LEN	128

CodeTableStruct hzCodeTable;

int main(int argc, char *argv[])
{
	char inbuf[64];
	unsigned char *outbuf[MAX_SEARCH_NUM]; 
	unsigned char *attrbuf[MAX_SEARCH_NUM]; 
    	int i, again, ret, search_pos, search_num, num;
	char *filename = "wubi.data";

	if (argc == 2)
		filename = argv[1];

	ret = LoadCodeTable(filename, &hzCodeTable);

	if (ret == -1)
	{
		UnloadCodeTable(&hzCodeTable);
		return;
	}

	for (i=0; i<MAX_SEARCH_NUM; i++)
	{
		outbuf[i] = (unsigned char *)malloc(MAX_CHAR_LEN);
		attrbuf[i] = (unsigned char *)malloc(MAX_CHAR_LEN);
	}

	search_pos = 0;
	search_num = 6;

	again = 1;
    	while (again) {
        	printf("input code = ");
        	scanf("%s", inbuf);
		if (inbuf[0] == 'Q') break;
		num = codetable_search(&hzCodeTable, inbuf, outbuf, attrbuf, search_pos, search_num);
		if (num>0)
		{
			printf("search result:\n");
/*
			for (i=0; i<num; i++)
				printf("\t%d: %s\n", i, outbuf[i]);
*/
			for (i=0; i<num; i++)
				printf("\t%d: %s %s\n", i, outbuf[i], attrbuf[i]);
		}
		else 
			printf("no matched phrase\n");

    	}

	UnloadCodeTable(&hzCodeTable);
}

