#include <stdio.h>
#include <stdlib.h>
#include <iiimcf.h>
#include <time.h>
#include "common.h"

IIIMCF_context context;

static IIIMF_status
preedit_handler(
    IIIMCF_context c,
    IIIMCF_event event,
    IIIMCF_component current,
    IIIMCF_component parent
)
{
    test_show_preedit_info(c);
    return IIIMF_STATUS_SUCCESS;
}

static IIIMF_status
keyevent_handler(
    IIIMCF_context c,
    IIIMCF_event event,
    IIIMCF_component current,
    IIIMCF_component parent
)
{
    IIIMF_status st;
    IIIMCF_event_type et;
    IIIMCF_keyevent kev;

    check(iiimcf_get_event_type(event, &et));
    if (et == IIIMCF_EVENT_TYPE_KEYEVENT) {
	check(iiimcf_get_keyevent_value(event, &kev));
	fprintf(stderr, "Keyevent[%d]:(%d, %d, %d, %d)\n",
		et, kev.keycode, kev.keychar, kev.modifier, kev.time_stamp);
    }

    return IIIMF_STATUS_SUCCESS;
}

static void
create_context()
{
    check(iiimcf_create_context(handle, IIIMCF_ATTR_NULL, &context));
}

static void
destroy_context(
    IIIMCF_context c
)
{
    check(iiimcf_destroy_context(c));
}

static void
register_components()
{
    IIIMCF_component parent, comp;

    check(iiimcf_get_component(handle,
			       "org.OpenI18N.IIIMCF.UI.preedit",
			       &parent));
    check(iiimcf_register_component(handle,
				    "org.OpenI18N.IIIMCF.test.preedit",
				    preedit_handler,
				    parent,
				    &comp));
    check(iiimcf_get_component(handle,
			       "org.OpenI18N.IIIMCF.event.key",
			       &parent));
    check(iiimcf_register_component(handle,
				    "org.OpenI18N.IIIMCF.test.event.key",
				    keyevent_handler,
				    parent,
				    &comp));
}

int
main(
    int argc,
    char **argv
)
{
    test_init();
    register_components();
    create_context();

    test_forwardkey(context, IIIMF_KEYCODE_A, 'a', 0);
    test_show_incoming_events(context, 1);
    test_trigger(context, 1);
    test_show_incoming_events(context, 1);
    test_forwardkey(context, IIIMF_KEYCODE_K, 'k', 0);
    test_show_incoming_events(context, 1);
    test_forwardkey(context, IIIMF_KEYCODE_U, 'u', 0);
    test_show_incoming_events(context, 1);
    test_forwardkey(context, IIIMF_KEYCODE_1, '1', 0);
    test_show_incoming_events(context, 1);
    test_forwardkey(context, IIIMF_KEYCODE_ENTER, 0, 0);
    test_show_incoming_events(context, 1);
    test_trigger(context, 0);
    test_show_incoming_events(context, 1);

    destroy_context(context);
    test_uninit();

    return 0;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */

