#if !defined(IIIMP_DATA_P_H)
#define IIIMP_DATA_P_H

/* $Id: iiimp-dataP.h,v 1.1.1.1 2002/08/31 04:18:05 himi Exp $ */


#include <stdio.h>
#include <sys/types.h>

#include <iiimp-data.h>


#ifdef	__cplusplus
extern "C" {
#endif


#if defined(_BIG_ENDIAN) || defined(WORDS_BIGENDIAN)

#define	GETU16(n, r, p, b)	(((n) = ((0 == (b)) ? \
					 (((*((uchar_t *)(p + 0))) << 8) + \
					  ((*((uchar_t *)(p + 1))) << 0)) : \
					 (((*((uchar_t *)(p + 0))) << 0) + \
					  ((*((uchar_t *)(p + 1))) << 8)))), \
				 ((p) += 2), \
				 ((r) -= 2))

#define	GETU32(n, r, p, b)	(((n) = ((0 == (b)) ? \
					 (((*((uchar_t *)(p + 0))) << 24) + \
					  ((*((uchar_t *)(p + 1))) << 16) + \
					  ((*((uchar_t *)(p + 2))) << 8) + \
					  ((*((uchar_t *)(p + 3))) << 0)) : \
					 (((*((uchar_t *)(p + 0))) << 0) + \
					  ((*((uchar_t *)(p + 1))) << 8) + \
					  ((*((uchar_t *)(p + 2))) << 16) + \
					  ((*((uchar_t *)(p + 3))) << 24)))), \
				 ((p) += 4), \
				 ((r) -= 4))

#define	GET16(n, r, p, b) \
			(((n) = ((0 == (b)) ? \
				 (int16_t)(((*((uchar_t *)(p + 0))) << 8) + \
					   ((*((uchar_t *)(p + 1))) << 0)) : \
				 (int16_t)(((*((uchar_t *)(p + 0))) << 0) + \
					   ((*((uchar_t *)(p + 1))) << 8)))), \
			 ((p) += 2), \
			 ((r) -= 2))

#define	GET32(n, r, p, b) \
			(((n) = ((0 == (b)) ? \
				((int32_t)(((*((uchar_t *)(p + 0))) << 24) + \
					   ((*((uchar_t *)(p + 1))) << 16) + \
					   ((*((uchar_t *)(p + 2))) << 8) + \
					   ((*((uchar_t *)(p + 3))) << 0))) : \
				((int32_t)(((*((uchar_t *)(p + 0))) << 0) + \
					   ((*((uchar_t *)(p + 1))) << 8) + \
					   ((*((uchar_t *)(p + 2))) << 16) + \
					   ((*((uchar_t *)(p + 3))) << 24))))), \
			 ((p) += 4), \
			 ((r) -= 4))

#define	PUTU16(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0xff00) >> 8); \
				(*((p) + 1)) = (((n) & 0x00ff) >> 0); \
			} else { \
				(*((p) + 0)) = (((n) & 0x00ff) >> 0); \
				(*((p) + 1)) = (((n) & 0xff00) >> 8); \
			}; \
			((p) += 2); \
			((r) -= 2)

#define	PUTU32(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0xff000000) >> 24); \
				(*((p) + 1)) = (((n) & 0x00ff0000) >> 16); \
				(*((p) + 2)) = (((n) & 0x0000ff00) >> 8); \
				(*((p) + 3)) = (((n) & 0x000000ff) >> 0); \
			} else { \
				(*((p) + 0)) = (((n) & 0x000000ff) >> 0); \
				(*((p) + 1)) = (((n) & 0x0000ff00) >> 8); \
				(*((p) + 2)) = (((n) & 0x00ff0000) >> 16); \
				(*((p) + 3)) = (((n) & 0xff000000) >> 24); \
			}; \
			((p) += 4); \
			((r) -= 4)

#define	PUT16(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0xff00) >> 8); \
				(*((p) + 1)) = (((n) & 0x00ff) >> 0); \
			} else { \
				(*((p) + 0)) = (((n) & 0x00ff) >> 0); \
				(*((p) + 1)) = (((n) & 0xff00) >> 8); \
			}; \
			((p) += 2); \
			((r) -= 2)

#define	PUT32(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0xff000000) >> 24); \
				(*((p) + 1)) = (((n) & 0x00ff0000) >> 16); \
				(*((p) + 2)) = (((n) & 0x0000ff00) >> 8); \
				(*((p) + 3)) = (((n) & 0x000000ff) >> 0); \
			} else { \
				(*((p) + 0)) = (((n) & 0x000000ff) >> 0); \
				(*((p) + 1)) = (((n) & 0x0000ff00) >> 8); \
				(*((p) + 2)) = (((n) & 0x00ff0000) >> 16); \
				(*((p) + 3)) = (((n) & 0xff000000) >> 24); \
			}; \
			((p) += 4); \
			((r) -= 4)

#else /* !(_BIG_ENDIAN || WORDS_BIGENDIAN) */

#define	GETU16(n, r, p, b)	(((n) = ((0 == (b)) ? \
					 (((*((uchar_t *)(p + 0))) << 0) + \
					  ((*((uchar_t *)(p + 1))) << 8)) : \
					 (((*((uchar_t *)(p + 0))) << 8) + \
					  ((*((uchar_t *)(p + 1))) << 0)))), \
				 ((p) += 2), \
				 ((r) -= 2))

#define	GETU32(n, r, p, b)	(((n) = ((0 == (b)) ? \
					 (((*((uchar_t *)(p + 0))) << 0) + \
					  ((*((uchar_t *)(p + 1))) << 8) + \
					  ((*((uchar_t *)(p + 2))) << 16) + \
					  ((*((uchar_t *)(p + 3))) << 24)) : \
					 (((*((uchar_t *)(p + 0))) << 24) + \
					  ((*((uchar_t *)(p + 1))) << 16) + \
					  ((*((uchar_t *)(p + 2))) << 8) + \
					  ((*((uchar_t *)(p + 3))) << 0)))), \
				 ((p) += 4), \
				 ((r) -= 4))

#define	GET16(n, r, p, b) \
			(((n) = ((0 == (b)) ? \
				 (int16_t)(((*((uchar_t *)(p + 0))) << 0) + \
					   ((*((uchar_t *)(p + 1))) << 8)) : \
				 (int16_t)(((*((uchar_t *)(p + 0))) << 8) + \
					   ((*((uchar_t *)(p + 1))) << 0)))), \
			 ((p) += 2), \
			 ((r) -= 2))

#define	GET32(n, r, p, b) \
			(((n) = ((0 == (b)) ? \
				 ((int32_t)(((*((uchar_t *)(p + 0))) << 0) + \
					    ((*((uchar_t *)(p + 1))) << 8) + \
					    ((*((uchar_t *)(p + 2))) << 16) + \
					    ((*((uchar_t *)(p + 3))) << 24))) : \
				 ((int32_t)(((*((uchar_t *)(p + 0))) << 24) + \
					    ((*((uchar_t *)(p + 1))) << 16) + \
					    ((*((uchar_t *)(p + 2))) << 8) + \
					    ((*((uchar_t *)(p + 3))) << 0))))), \
			 ((p) += 4), \
			 ((r) -= 4))

#define	PUTU16(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0x00ff) >> 0); \
				(*((p) + 1)) = (((n) & 0xff00) >> 8); \
			} else { \
				(*((p) + 0)) = (((n) & 0xff00) >> 8); \
				(*((p) + 1)) = (((n) & 0x00ff) >> 0); \
			}; \
			((p) += 2); \
			((r) -= 2)

#define	PUTU32(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0x000000ff) >> 0); \
				(*((p) + 1)) = (((n) & 0x0000ff00) >> 8); \
				(*((p) + 2)) = (((n) & 0x00ff0000) >> 16); \
				(*((p) + 3)) = (((n) & 0xff000000) >> 24); \
			} else { \
				(*((p) + 0)) = (((n) & 0xff000000) >> 24); \
				(*((p) + 1)) = (((n) & 0x00ff0000) >> 16); \
				(*((p) + 2)) = (((n) & 0x0000ff00) >> 8); \
				(*((p) + 3)) = (((n) & 0x000000ff) >> 0); \
			}; \
			((p) += 4); \
			((r) -= 4)

#define	PUT16(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0x00ff) >> 0); \
				(*((p) + 1)) = (((n) & 0xff00) >> 8); \
			} else { \
				(*((p) + 0)) = (((n) & 0xff00) >> 8); \
				(*((p) + 1)) = (((n) & 0x00ff) >> 0); \
			}; \
			((p) += 2); \
			((r) -= 2)

#define	PUT32(n, r, p, b) \
			if (0 == (b)) { \
				(*((p) + 0)) = (((n) & 0x000000ff) >> 0); \
				(*((p) + 1)) = (((n) & 0x0000ff00) >> 8); \
				(*((p) + 2)) = (((n) & 0x00ff0000) >> 16); \
				(*((p) + 3)) = (((n) & 0xff000000) >> 24); \
			} else { \
				(*((p) + 0)) = (((n) & 0xff000000) >> 24); \
				(*((p) + 1)) = (((n) & 0x00ff0000) >> 16); \
				(*((p) + 2)) = (((n) & 0x0000ff00) >> 8); \
				(*((p) + 3)) = (((n) & 0x000000ff) >> 0); \
			}; \
			((p) += 4); \
			((r) -= 4)

#endif /* !(_BIG_ENDIAN || WORDS_BIGENDIAN) */

#define	GETU8(n, r, p, b)	(((n) = (*((uint8_t *)(p)))),  ((p) += 1), ((r) -= 1))
#define	GET8(n, r, p, b)	(((n) = (*((int8_t *)(p)))),   ((p) += 1), ((r) -= 1))

#define	PUTU8(n, r, p, b)	(((*p) = (n)),  ((p) += 1), ((r) -= 1))
#define	PUT8(n, r, p, b)	(((*p) = (n)),   ((p) += 1), ((r) -= 1))

#define	SKIP8(r, p)		(((p) += 1), ((r) -= 1))
#define	SKIP16(r, p)		(((p) += 2), ((r) -= 2))
#define	SKIP32(r, p)		(((p) += 4), ((r) -= 4))


#define PUT_PACKET_HEADER(ptr, opcode, length) \
	(*((ptr) + 0) = (((opcode) & 0x7f)), \
	 *((ptr) + 1) = (((length) & 0x00ff0000) >> 16), \
	 *((ptr) + 2) = (((length) & 0x0000ff00) >> 8), \
	 *((ptr) + 3) = (((length) & 0x000000ff) >> 0))


#define STRING_PAD(len)		((2 + (len)) % 4)
#define STRING_OBJECT_SIZE(len)	(2 + (len) + (STRING_PAD((len))))
#define PAD2(n)			((n) & 0x02)
#define PAD(n)			((4 - ((n) & 0x03)) & 0x03)

#define REQUIRE_PROTOCOL_VERSION(data_s, v) \
do { \
    if ((v) > (data_s)->protocol_version) { \
	(data_s)->status = IIIMP_DATA_PROTOCOL_VERSION_ERROR; \
	return NULL; \
    } \
} while(0)


#define KEY_EVENT_OBJECT_SIZE	(4 * 4)


typedef struct iiimp_attribute_id {
    int				id_predefined;
    int				id_dynamic;
    struct iiimp_attribute_id *	next;
} IIIMP_attribute_id;

struct iiimp_data_s {
    int				byte_swap;
    IIIMP_attribute_id *	attribute_id;
    int				status;
    FILE *			print_fp;
    uint_t			print_flag;
    int				protocol_version;
};


/* prototype of composite data unpack function */

#define IIIMP_dal \
	IIIMP_data_s *		data_s, \
	size_t *		nbyte, \
	const uchar_t **	ptr, \
	size_t			byte_length

IIIMP_card16_list *		iiimp_card16_list_unpack(IIIMP_dal);
IIIMP_card32_list *		iiimp_card32_list_unpack(IIIMP_dal);
IIIMP_keyevent_list *		iiimp_keyevent_list_unpack(IIIMP_dal);
IIIMP_string *			iiimp_string_unpack(IIIMP_dal);
IIIMP_string *			iiimp_string_list_unpack(IIIMP_dal);
IIIMP_feedback_attr_list *	iiimp_feedback_attr_list_unpack(IIIMP_dal);
IIIMP_char_with_feedback *	iiimp_char_with_feedback_unpack(IIIMP_dal);
IIIMP_char_with_feedback *	iiimp_char_with_feedback_list_unpack(IIIMP_dal);
IIIMP_operation *		iiimp_operation_unpack(IIIMP_dal);
IIIMP_operation *		iiimp_operation_list_unpack(IIIMP_dal);
IIIMP_annotation_value *	iiimp_annotation_text_unpack(IIIMP_dal);
IIIMP_annotation_value *	iiimp_annotation_string_unpack(IIIMP_dal);
IIIMP_annotation *		iiimp_annotation_unpack(IIIMP_dal);
IIIMP_text *			iiimp_text_unpack(IIIMP_dal);
IIIMP_text *			iiimp_text_list_unpack(IIIMP_dal);
IIIMP_client_descriptor *	iiimp_client_descriptor_unpack(IIIMP_dal);
IIIMP_object_descriptor *	iiimp_object_descriptor_unpack(IIIMP_dal);
IIIMP_object_descriptor *	iiimp_object_descriptor_list_unpack(IIIMP_dal);
IIIMP_ccdef *			iiimp_ccdef_unpack(IIIMP_dal);
IIIMP_language *		iiimp_language_unpack(IIIMP_dal);
IIIMP_language *		iiimp_language_list_unpack(IIIMP_dal);
IIIMP_jarfile_object *		iiimp_jarfile_object_unpack(IIIMP_dal);
IIIMP_inputmethod_descriptor *	iiimp_inputmethod_descriptor_unpack(IIIMP_dal);
IIIMP_inputmethod_descriptor *	iiimp_inputmethod_descriptor_list_unpack(IIIMP_dal);
IIIMP_binaryfile_object *	iiimp_binaryfile_object_unpack(IIIMP_dal);
IIIMP_imattribute *		iiimp_imattribute_unpack(IIIMP_dal);
IIIMP_imattribute *		iiimp_imattribute_list_unpack(IIIMP_dal);
IIIMP_icattribute *		iiimp_icattribute_unpack(IIIMP_dal);
IIIMP_icattribute *		iiimp_icattribute_list_unpack(IIIMP_dal);
IIIMP_contents *		iiimp_contents_unpack(IIIMP_dal);

#undef IIIMP_dal


/* prototype of composite data pack function */

extern void	iiimp_card16_list_pack(
			IIIMP_data_s *		data_s,
			IIIMP_card16_list *	m,
			size_t *		nbyte,
			uchar_t **		ptr);

extern void	iiimp_card32_list_pack(
			IIIMP_data_s *		data_s,
			IIIMP_card32_list *	m,
			size_t *		nbyte,
			uchar_t **		ptr);

extern void	iiimp_string_pack(
			IIIMP_data_s *		data_s,
			IIIMP_string *		m,
			size_t *		nbyte,
			uchar_t **		ptr);

extern void	iiimp_string_list_pack(
			IIIMP_data_s *		data_s,
			IIIMP_string *		m,
			size_t *		nbyte,
			uchar_t **		ptr);

extern void	iiimp_feedback_attr_list_pack(
			IIIMP_data_s *			data_s,
			IIIMP_feedback_attr_list *	m,
			size_t *			nbyte,
			uchar_t **			ptr);

extern void	iiimp_char_with_feedback_pack(
			IIIMP_data_s *			data_s,
			IIIMP_char_with_feedback *	m,
			size_t *			nbyte,
			uchar_t **			ptr);

extern void	iiimp_char_with_feedback_list_pack(
			IIIMP_data_s *			data_s,
			IIIMP_char_with_feedback *	m,
			size_t *			nbyte,
			uchar_t **			ptr);

extern void	iiimp_operation_pack(
			IIIMP_data_s *		data_s,
			IIIMP_operation *	m,
			size_t *		nbyte,
			uchar_t **		ptr);

extern void	iiimp_operation_list_pack(
			IIIMP_data_s *		data_s,
			IIIMP_operation *	m,
			size_t *		nbyte,
			uchar_t **		ptr);

extern void	iiimp_annotation_text_pack(
			IIIMP_data_s *			data_s,
			IIIMP_annotation_value *	m,
			size_t *			nbyte,
			uchar_t **			ptr);

extern void	iiimp_annotation_string_pack(
			IIIMP_data_s *			data_s,
			IIIMP_annotation_value *	m,
			size_t *			nbyte,
			uchar_t **			ptr);

extern void	iiimp_annotation_pack(
			IIIMP_data_s *		data_s,
			IIIMP_annotation *	m,
			size_t *		nbyte,
			uchar_t **		ptr);

extern void	iiimp_annotation_list_pack(
			IIIMP_data_s *		data_s,
			IIIMP_annotation *	m,
			size_t *		nbyte,
			uchar_t **		ptr);

extern void	iiimp_text_pack(
			IIIMP_data_s *	data_s,
			IIIMP_text *	m,
			size_t *	nbyte,
			uchar_t **	ptr);

extern void	iiimp_text_list_pack(
			IIIMP_data_s *	data_s,
			IIIMP_text *	text,
			size_t *	nbyte,
			uchar_t **	ptr);

extern void	iiimp_client_descriptor_pack(
			IIIMP_data_s *			data_s,
			IIIMP_client_descriptor *	cd,
			size_t *			nbyte,
			uchar_t **			ptr);

extern void	iiimp_object_descriptor_pack(
			IIIMP_data_s *			data_s,
			IIIMP_object_descriptor *	m,
			size_t *			nbyte,
			uchar_t **			ptr);

extern void	iiimp_object_descriptor_list_pack(
			IIIMP_data_s *			data_s,
			IIIMP_object_descriptor *	m,
			size_t *			nbyte,
			uchar_t **			ptr);

extern void	iiimp_ccdef_pack(
			IIIMP_data_s *	data_s,
			IIIMP_ccdef *	m,
			size_t *	nbyte,
			uchar_t **	ptr);

extern void	iiimp_language_pack(
			IIIMP_data_s *		data_s,
			IIIMP_language *	m,
			size_t *		nbyte,
			uchar_t **		ptr);

extern void	iiimp_language_list_pack(
			IIIMP_data_s *		data_s,
			IIIMP_language *	m,
			size_t *		nbyte,
			uchar_t **		ptr);

extern void	iiimp_jarfile_object_pack(
			IIIMP_data_s *		data_s,
			IIIMP_jarfile_object *	m,
			size_t *		nbyte,
			uchar_t **		ptr);

extern void	iiimp_inputmethod_descriptor_pack(
			IIIMP_data_s *			data_s,
			IIIMP_inputmethod_descriptor *	m,
			size_t *			nbyte,
			uchar_t **			ptr);

extern void	iiimp_inputmethod_descriptor_list_pack(
			IIIMP_data_s *			data_s,
			IIIMP_inputmethod_descriptor *	m,
			size_t *			nbyte,
			uchar_t **			ptr);

extern void	iiimp_binaryfile_object_pack(
			IIIMP_data_s *			data_s,
			IIIMP_binaryfile_object *	m,
			size_t *			nbyte,
			uchar_t **			ptr);

extern void	iiimp_imattribute_pack(
			IIIMP_data_s *		data_s,
			IIIMP_imattribute *	m,
			size_t *		nbyte,
			uchar_t **		ptr);

extern void	iiimp_imattribute_list_pack(
			IIIMP_data_s *		data_s,
			IIIMP_imattribute *	m,
			size_t *		nbyte,
			uchar_t **		ptr);

extern void	iiimp_icattribute_pack(
			IIIMP_data_s *		data_s,
			IIIMP_icattribute *	m,
			size_t *		nbyte,
			uchar_t **		ptr);

extern void	iiimp_icattribute_list_pack(
			IIIMP_data_s *		data_s,
			IIIMP_icattribute *	m,
			size_t *		nbyte,
			uchar_t **		ptr);

extern void	iiimp_keyevent_list_pack(
			IIIMP_data_s *		data_s,
			IIIMP_keyevent_list *	m,
			size_t *		nbyte,
			uchar_t **		ptr);

extern void	iiimp_contents_pack(
			IIIMP_data_s *		data_s,
			IIIMP_contents *	m,
			size_t *		nbyte,
			uchar_t **		ptr);


extern void	iiimp_message_header_print(IIIMP_data_s *	data_s,
					   int			opcode,
					   int			im_id,
					   int			ic_id);

extern void	iiimp_card16_list_print(IIIMP_data_s *		data_s,
					IIIMP_card16_list *	m);

extern void	iiimp_card32_list_print(IIIMP_data_s *		data_s,
					IIIMP_card32_list *	m);

extern void	iiimp_byte_stream_print(IIIMP_data_s *		data_s,
					IIIMP_byte_stream *	m);

extern void	iiimp_string_print(IIIMP_data_s *	data_s,
				   IIIMP_string *	m);

extern void	iiimp_string_list_print(IIIMP_data_s *	data_s,
					IIIMP_string *	m);

extern void	iiimp_feedback_attr_print(IIIMP_data_s *	data_s,
					  IIIMP_feedback_attr *	m);

extern void	iiimp_feedback_attr_list_print(
			IIIMP_data_s *			data_s,
			IIIMP_feedback_attr_list *	m);

extern void	iiimp_char_with_feedback_print(
			IIIMP_data_s *			data_s,
			IIIMP_char_with_feedback *	m);

extern void	iiimp_char_with_feedback_list_print(
			IIIMP_data_s *			data_s,
			IIIMP_char_with_feedback *	m);

extern void	iiimp_operation_print(IIIMP_data_s *	data_s,
				      IIIMP_operation *	m);

extern void	iiimp_operation_list_print(IIIMP_data_s *	data_s,
					   IIIMP_operation *	m);

extern void	iiimp_annotation_print(IIIMP_data_s *		data_s,
				       IIIMP_annotation *	m);

extern void	iiimp_text_print(IIIMP_data_s * data_s, IIIMP_text * m);

extern void	iiimp_text_list_print(IIIMP_data_s * data_s, IIIMP_text * m);

extern void	iiimp_client_descriptor_print(IIIMP_data_s *		data_s,
					      IIIMP_client_descriptor *	m);

extern void	iiimp_object_descriptor_print(IIIMP_data_s *		data_s,
					      IIIMP_object_descriptor *	m);

extern void	iiimp_object_descriptor_list_print(
			IIIMP_data_s *			data_s,
			IIIMP_object_descriptor *	m);

extern void	iiimp_ccdef_print(IIIMP_data_s * data_s, IIIMP_ccdef * m);

extern void	iiimp_language_print(IIIMP_data_s * data_s, IIIMP_language * m);

extern void	iiimp_jarfile_object_print(IIIMP_data_s *		data_s,
					   IIIMP_jarfile_object *	m);

extern void	iiimp_binaryfile_object_print(IIIMP_data_s *		data_s,
					      IIIMP_binaryfile_object *	m);

extern void	iiimp_inputmethod_descriptor_print(
			IIIMP_data_s *			data_s,
			IIIMP_inputmethod_descriptor *	m);

extern void	iiimp_inputmethod_descriptor_list_print(
			IIIMP_data_s *			data_s,
			IIIMP_inputmethod_descriptor *	m);

extern void	iiimp_imattribute_print(IIIMP_data_s *		data_s,
					IIIMP_imattribute *	m);

extern void	iiimp_imattribute_list_print(IIIMP_data_s *		data_s,
					     IIIMP_imattribute *	m);

extern void	iiimp_character_subsets_print(IIIMP_data_s *	data_s,
					      IIIMP_card32 *	m);

extern void	iiimp_character_subsets_list_print(IIIMP_data_s *	data_s,
						   IIIMP_card32_list *	m);

extern void	iiimp_icattribute_print(IIIMP_data_s *		data_s,
					IIIMP_icattribute *	m);

extern void	iiimp_icattribute_list_print(IIIMP_data_s *		data_s,
					     IIIMP_icattribute *	m);

extern void	iiimp_keyevent_print(IIIMP_data_s *	data_s,
				     IIIMP_keyevent *	m);

extern void	iiimp_keyevent_list_print(IIIMP_data_s *	data_s,
					  IIIMP_keyevent_list *	m);

extern void	iiimp_contents_print(IIIMP_data_s * data_s, IIIMP_contents * m);

extern void	iiimp_simple_print(IIIMP_data_s * data_s, IIIMP_message * m);

extern void	iiimp_simple_im_print(IIIMP_data_s * data_s, IIIMP_message * m);

extern void	iiimp_invalid_message_print(IIIMP_data_s *	data_s,
					    IIIMP_message *	m);

extern void	iiimp_aux_simple_print(IIIMP_data_s *	data_s,
				       IIIMP_message *	m);

extern void	iiimp_aux_value_print(IIIMP_data_s * data_s, IIIMP_message * m);

extern void	iiimp_connect_print(IIIMP_data_s * data_s, IIIMP_message * m);

extern void	iiimp_connect_reply_print(IIIMP_data_s *	data_s,
					  IIIMP_message *	m);

extern void	iiimp_register_trigger_keys_print(IIIMP_data_s *	data_s,
						  IIIMP_message *	m);

extern void	iiimp_trigger_notify_print(IIIMP_data_s *	data_s,
					   IIIMP_message *	m);

extern void	iiimp_setimvalues_print(IIIMP_data_s *	data_s,
					IIIMP_message *	m);

extern void	iiimp_getimvalues_print(IIIMP_data_s *	data_s,
					IIIMP_message *	m);

extern void	iiimp_getimvalues_reply_print(IIIMP_data_s *	data_s,
					      IIIMP_message *	m);

extern void	iiimp_createic_print(IIIMP_data_s * data_s, IIIMP_message * m);

extern void	iiimp_seticvalues_print(IIIMP_data_s *	data_s,
					IIIMP_message *	m);

extern void	iiimp_geticvalues_print(IIIMP_data_s *	data_s,
					IIIMP_message *	m);

extern void	iiimp_geticvalues_reply_print(IIIMP_data_s *	data_s,
					      IIIMP_message *	m);

extern void	iiimp_preedit_start_reply_print(IIIMP_data_s *	data_s,
						IIIMP_message *	m);

extern void	iiimp_preedit_draw_print(IIIMP_data_s *		data_s,
					 IIIMP_message *	m);

extern void	iiimp_status_draw_print(IIIMP_data_s *	data_s,
					IIIMP_message *	m);

extern void	iiimp_forward_event_print(IIIMP_data_s *	data_s,
					  IIIMP_message *	m);

extern void	iiimp_forward_event_with_operations_print(
			IIIMP_data_s *	data_s,
			IIIMP_message *	m);

extern void	iiimp_forward_event_with_operations_reply_print(
			IIIMP_data_s *	data_s,
			IIIMP_message *	m);

extern void	iiimp_commit_string_print(IIIMP_data_s *	data_s,
					  IIIMP_message *	m);

extern void	iiimp_lookup_choice_start_print(IIIMP_data_s *	data_s,
						IIIMP_message *	m);

extern void	iiimp_lookup_choice_draw_print(IIIMP_data_s *	data_s,
					       IIIMP_message *	m);

extern void	iiimp_lookup_choice_process_print(IIIMP_data_s *	data_s,
						  IIIMP_message *	m);

extern void	iiimp_protocol_version_print(IIIMP_data_s *	data_s,
					     IIIMP_message *	m);

extern IIIMP_card16	iiimp_attribute_id_search(
				IIIMP_data_s *	data_s,
				IIIMP_card16	id_dynamic);

extern void	iiimp_attribute_id_update(IIIMP_data_s *	data_s,
					  IIIMP_card16		id_predefined,
					  IIIMP_card16		id_dynamic);

extern void	iiimp_attribute_id_destroy(IIIMP_data_s * data_s);


#ifdef	__cplusplus
}
#endif

#endif /* !IIIMP_DATA_P_H */


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
