/* GNOME INPUT METHOD SWITCHER
 * Copyright 2003 Sun Microsystems Inc.
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include <gtk/gtkmain.h>
#include <gtk/gtkdrawingarea.h>
#include <gtk/gtksignal.h>
#include <panel-applet.h>
#include <gnome.h>

#include "gnome-im-switcher.h"
#include "widgets.h"
#include "preference.h"
#include "iiim-interface.h"

static void
phelp_cb (GtkDialog *dialog, gint tab, gpointer data)
{
  GError *error = NULL;

  gnome_help_display_desktop (NULL, 
			      "gnome-im-switcher", 
			      "gnome-im-switcher-palette",
			      NULL, 
			      &error);
	
  if (error) { /* FIXME: the user needs to see this */
    g_warning ("help error: %s\n", error->message);
    g_error_free (error);
    error = NULL;
  }
}

static gboolean
gimlet_applet_new (PanelApplet *applet, gpointer data)
{

  GimletWindow *gimlet;

  gimlet = g_new0 (GimletWindow, 1);

  gimlet->applet = applet;

  /* default preference settings */
  gimlet->showicon = FALSE;
  gimlet->showtext = TRUE;
  gimlet->use_theme_font = TRUE;
  gimlet->use_theme_colors = TRUE;
  gimlet->conversion_on_start = TRUE;
  gimlet->input_lang_policy = FOLLOW_APPLICATION;
  gimlet->menu_font = pango_font_description_new ();
  gimlet->status_font = pango_font_description_new ();

  gimlet->fixed_width = -1;
  gimlet->fixed_height = -1;

  gimlet->base_iconname = NULL;
  gimlet_preference_init (gimlet);

  gimlet_iiim_selection_set (gimlet);

  return TRUE;
}

static gboolean
imswitcher_applet_factory (PanelApplet *applet,
			   const gchar *iid, gpointer data)
{
  gboolean retval = FALSE;
	
  if (strcmp (iid, "OAFIID:GNOME_imswitcher") != 0)
    return FALSE;

  retval = gimlet_applet_new (applet, data);
	
  return retval;
}

PANEL_APPLET_BONOBO_FACTORY ("OAFIID:GNOME_imswitcher_Factory",
                             PANEL_TYPE_APPLET,
                             "GNOME Input Method Applet",
                             "0",
                             imswitcher_applet_factory,
                             NULL);

