/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


package sun.awt.im.iiimp;

import java.awt.*;
import java.text.*;
import java.awt.event.*;
import com.sun.iiim.*;

class StatusPane extends Panel implements MouseMotionListener, MouseListener {
    // Status string
    private String text="";
    private AttributedCharacterIterator iterator;

    /*
     * Default, no arg constructor
     */
    public StatusPane() {
        addMouseMotionListener(this);
        addMouseListener(this);
    }
    
    void handleEvent(IIIMStatusEvent e) {
        text = "";
        setData(e.getIterator());
        
        repaint();
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        
        Rectangle rec = getBounds();
        
	//g.setColor(Color.darkGray);
	g.setColor(Color.black);
	g.fill3DRect(rec.width - 2, 0, 2, rec.height,true);
	g.fill3DRect(0, rec.height - 2, rec.width, 2,true);

        g.setColor(Color.white);
	g.fill3DRect(0, 0, 2, rec.height,true);
	g.fill3DRect(0, 0, rec.width, 2,true);
	//g.drawString(text,12,14);

	g.setColor(Color.black);

	if (Manager.COLOR_SUPPORT) {
	    g.drawString(iterator, 12, 14);
	} else {
	    g.drawString(text, 12, 14);
	}
    }
    
    void setData(AttributedCharacterIterator str) {
	iterator = str;
        for(char c = str.first(); c != CharacterIterator.DONE; 
            c = str.next()) {
            text += c;
        }
    }
    
    String getData()  {
        return text;
    }
    
    private boolean dragged = false;
    int x = 0, y = 0;
    int oldx = 0, oldy = 0;
    Cursor cursor = null;
    
    public void mouseDragged(MouseEvent e) {
        x = e.getX();
        y = e.getY();

        if(!dragged) {
            oldx = x;
            oldy = y;
            dragged = true;
            cursor = getCursor();
            setCursor(new Cursor(Cursor.MOVE_CURSOR));
            return;
        }
        Point point = getParent().getLocationOnScreen();
            
        point.x += (x-oldx); 
        point.y += (y-oldy); 
            
        getParent().setLocation(point);
    }
    
    public void mouseMoved(MouseEvent e) {
    }
    
    public void mouseClicked(MouseEvent e) {
    }
    
    public void mouseEntered(MouseEvent e) {
    }
    
    public void mouseExited(MouseEvent e) {
    }
    
    public void mousePressed(MouseEvent e) {
    }
    
    public void mouseReleased(MouseEvent e) {
        dragged = false;
        setCursor(cursor);
    }
}
