/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef _KEYBOARDCONFIG_H_
#define _KEYBOARDCONFIG_H_

enum _BaseKeyList {
	VK_invalid  = -2,
	VK_movearea = -1,
	VK_quotedbl = 0,
	VK_1,
	VK_2,
	VK_3,
	VK_4,
	VK_5,
	VK_6,
	VK_7,
	VK_8,
	VK_9,
	VK_0,
	VK_minus,
	VK_equal,

	VK_q,
	VK_w,
	VK_e,
	VK_r,
	VK_t,
	VK_y,
	VK_u,
	VK_i,
	VK_o,
	VK_p,
	VK_bracketleft,
	VK_bracketright,
	VK_backslash,

	VK_a,
	VK_s,
	VK_d,
	VK_f,
	VK_g,
	VK_h,
	VK_j,
	VK_k,
	VK_l,
	VK_semicolon,
	VK_apostrophe,

	VK_z,
	VK_x,
	VK_c,
	VK_v,
	VK_b,
	VK_n,
	VK_m,
	VK_colon,
	VK_period,
	VK_slash,

	MAX_BASEKEY_NUM
};

enum _CtrlKeyList {
	VK_BackSpace = 0,
	VK_Tab,
	VK_Caps_Lock,
	VK_Enter,
	VK_Shift_L,
	VK_Control_L,
	VK_Alt_L,
	VK_space,
	VK_escape,

	MAX_CTRLKEY_NUM
};

enum _KeyboardType {
	KEYBOARD_STRING_TYPE = 0,
	KEYBOARD_KEY_TYPE,
};

#define MAX_VK_NUM  		(MAX_BASEKEY_NUM + MAX_CTRLKEY_NUM)
#define MAX_KEYBOARD_NUM 	32

#define KEYLIST_LOWER		"`1234567890-=qwertyuiop[]\\asdfghjkl;\'zxcvbnm,./";
#define KEYLIST_UPPER		"~!@#$%^&*()_+QWERTYUIOP{}|ASDFGHJKL:\"ZXCVBNM<>?";
#define KEYLIST_LABEL		"`1234567890-=QWERTYUIOP[]\\ASDFGHJKL;\'ZXCVBNM,./";
	
#define BACKSPACE_KEY_LABEL	"<-"
#define TAB_KEY_LABEL		"Tab"
#define CAPS_KEY_LABEL		"Caps"
#define ENTER_KEY_LABEL 	"Enter"
#define SHIFT_KEY_LABEL		"Shift"
#define CTRL_KEY_LABEL		"Ctrl"
#define ALT_KEY_LABEL		"Alt"
#define SPACE_KEY_LABEL		" "
#define ESCAPE_KEY_LABEL	"Esc"

typedef struct _BaseKeyStruct {
	char 		*lower_str;
	char 		*upper_str;
} BaseKeyStruct;

typedef struct _CtrlKeyStruct {
	char 		*label_str;
} CtrlKeyStruct;

typedef struct _VirtualKeyboard {
	char 		*ename;
	char 		*cname;
	char 		type;
	int 		encode;
	BaseKeyStruct	basekey[MAX_BASEKEY_NUM];
	CtrlKeyStruct	ctrlkey[MAX_CTRLKEY_NUM];
} VirtualKeyboard;

#endif     /*  _KEYBOARDCONFIG_H_  */

