/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include "thai_le.h"
#include "thai_key.h"
#include "encode.h"
#include "wtt_isc.h"

void le_commit_key(iml_session_t *s, unsigned char key);
void le_status_draw(iml_session_t *s);
int map_keyevent_to_immkey(IMKeyEventStruct *key_event);
int map_keyevent_to_imekey(IMKeyEventStruct *key_event);
void proc_key_output(iml_session_t *s, unsigned char key);
void proc_key_switch_conversion_event(iml_session_t *s, int on);

extern TThaiKeymapList gThaiKeymapList;
extern char *wtt_isc_mode_names[];

int le_session_get_isc_mode(iml_session_t *s)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) s->desktop->specific_data;
	int nInputMode_ID;

	nInputMode_ID = session_data->tPaletteAux_Status.nInputMode_ID;

	if (nInputMode_ID < 0 || nInputMode_ID >= WTT_ISC_MODES_NUM)
		nInputMode_ID = desktop_data->nDefault_InputMode_ID;

	return(nInputMode_ID);
}

int le_session_save_isc_mode(iml_session_t *s, int nInputMode_ID)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

	if (nInputMode_ID < 0 || nInputMode_ID >= WTT_ISC_MODES_NUM)
		nInputMode_ID = WTT_ISC0;

	session_data->tPaletteAux_Status.nInputMode_ID = nInputMode_ID;
}

int le_desktop_save_default_isc_mode(iml_session_t *s, int nInputMode_ID)
{
	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) s->desktop->specific_data;

	if (nInputMode_ID < 0 || nInputMode_ID >= WTT_ISC_MODES_NUM)
		nInputMode_ID = WTT_ISC0;

	desktop_data->nDefault_InputMode_ID = nInputMode_ID;
}

int le_session_get_keyboard_mode(iml_session_t *s)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) s->desktop->specific_data;
	int nKeyboard_ID;

	nKeyboard_ID = session_data->tKeyboardAux_Status.nKeyboard_ID;

	if (nKeyboard_ID < 0 || nKeyboard_ID >= gThaiKeymapList.nNum_Keymaps)
		nKeyboard_ID = desktop_data->nDefault_Keyboard_ID;

	return(nKeyboard_ID);
}

int le_session_save_keyboard_mode(iml_session_t *s, int nKeyboard_ID)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) s->desktop->specific_data;

	if (nKeyboard_ID < 0 || nKeyboard_ID >= gThaiKeymapList.nNum_Keymaps)
		nKeyboard_ID = desktop_data->nDefault_Keyboard_ID;

	session_data->tKeyboardAux_Status.nKeyboard_ID = nKeyboard_ID;
}

int le_desktop_save_default_keyboard_mode(iml_session_t *s, int nKeyboard_ID)
{
	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) s->desktop->specific_data;

	if (gThaiKeymapList.nNum_Keymaps <= 0) {
		nKeyboard_ID = 0xff;
	} else {
	    if (nKeyboard_ID < 0 || nKeyboard_ID >= gThaiKeymapList.nNum_Keymaps)
		nKeyboard_ID = 0;
	}
	desktop_data->nDefault_Keyboard_ID = nKeyboard_ID;
}

int le_session_get_previous_char(iml_session_t *s)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	return(session_data->chPrevious_Char);
}

int le_session_save_previous_char(iml_session_t *s, char ch)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	session_data->chPrevious_Char = ch;
}

/* process the keyboard event */
void proc_key_event(iml_session_t *s, IMKeyListEvent *keylistevent)
{
	int key_ret, nInputMode_ID;
	IMKeyEventStruct *key_event = (IMKeyEventStruct *) keylistevent->keylist;

	key_ret = map_keyevent_to_immkey(key_event);

	switch (key_ret) {
		/* English status <----> Chinese status */
		case ENGLISH_THAI_SWITCH_KEY:
			proc_key_switch_conversion_event(s, CONVERSION_OFF);
			return;

		/* Roundly Switch Input methods */
		case MODE_SWITCH_KEY:
			nInputMode_ID = le_session_get_isc_mode(s);
			nInputMode_ID = (nInputMode_ID + 1) % WTT_ISC_MODES_NUM;
			le_session_save_isc_mode(s, nInputMode_ID);
			le_status_draw(s);
			le_switch_mode_notify(s, nInputMode_ID);
			return;
	}

	key_ret = map_keyevent_to_imekey(key_event);
	if (key_ret == IME_NOT_USED_KEY) {
		le_session_save_previous_char(s, 0);
		iml_sendback_key(s, key_event);
		return;
	}

	proc_key_output(s, key_ret);
}

/* filter keys that used by Input Methods Manager */
int map_keyevent_to_immkey(IMKeyEventStruct *key_event) 
{
	int keycode, keystatus, keychar;

	keycode = key_event->keyCode;
	keychar = key_event->keyChar;
	keystatus = key_event->modifier;

	DEBUG_printf("keycode: 0x%x, keychar:0x%x, keystatus: 0x%x\n", keycode, keychar, keystatus);

	/* Function Keys */
	if (keycode == IM_VK_F2)
		return(MODE_SWITCH_KEY);

	/* Ctrl + Space */
	if ((keycode == IM_VK_SPACE) && (keystatus & IM_CTRL_MASK))
		return(ENGLISH_THAI_SWITCH_KEY);

	return (IMM_NOT_USED_KEY);
}

/*  get the keys that IME will use */
int map_keyevent_to_imekey(IMKeyEventStruct *key_event) 
{
	int keycode, keystatus, keychar;

	keycode = key_event->keyCode;
	keychar = key_event->keyChar;
	keystatus = key_event->modifier;

	/* fix bug 4700325: when switch to Thai IM, Numpad doesn't work as expected */
	if (keycode >= IM_VK_NUMPAD0 && keycode <= IM_VK_DIVIDE)
		return(IME_NOT_USED_KEY);

	/* fix bug 4708815: Thai IM gives English character */
	if (keycode >= IM_VK_COMMA && keycode <= IM_VK_CLOSE_BRACKET) {
		if (! (keystatus & IM_CTRL_MASK) &&
		    ! (keystatus & IM_META_MASK) &&
		    ! (keystatus & IM_ALT_MASK) &&
		    ! (keystatus & IM_ALT_GRAPH_MASK) )
			return(keychar);
	}

	return (IME_NOT_USED_KEY);
}

void proc_key_switch_conversion_event(iml_session_t *s, int on)
{
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;

	DEBUG_printf("ENGLISH_THAI SWITCH KEY, on:%d\n", on);

	session_data->tPaletteAux_Status.bShow = on;
	if (on == CONVERSION_OFF) {
		le_status_draw(s);
		iml_conversion_off(s);
	} else {
		iml_conversion_on(s);
		le_status_draw(s);
	}

	le_change_focus_notify(s);
}

void le_status_draw(iml_session_t *s)
{
	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) s->desktop->specific_data;
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	char status_string[128];
	char *mode_string;
	int  nInputMode_ID;

	nInputMode_ID = le_session_get_isc_mode(s);
        mode_string = (char *)wtt_isc_mode_names[nInputMode_ID];

	if (session_data->tPaletteAux_Status.bShow) {
		sprintf(status_string, "[ %s ] [ %s ]", (char *)THAI_LANG_NAME, mode_string);
	} else {
		sprintf(status_string, "[ %s ]", (char *)ENGLISH_LANG_NAME);
	}
	
	encode_draw_status(s, ENCODE_EUC_TH, status_string);
}

void le_commit_key(iml_session_t *s, unsigned char key)
{
	unsigned char key_string[2];
	key_string[0] = key;
	key_string[1] = 0;
	encode_commit(s, ENCODE_EUC_TH, key_string);
}

void proc_key_output(iml_session_t *s, unsigned char key)
{
	MyDataPerDesktop *desktop_data = (MyDataPerDesktop *) s->desktop->specific_data;
	MyDataPerSession *session_data = (MyDataPerSession *) s->specific_data;
	int nMode_ID;
	int nKeyboard_ID;
	int ret;

	unsigned char previous_char, following_char;

	nMode_ID = le_session_get_isc_mode(s);
	nKeyboard_ID = le_session_get_keyboard_mode(s);

	DEBUG_printf("proc_key_output: Mode_ID:%d, nKeyboardID:%d\n", nMode_ID, nKeyboard_ID);

	previous_char = le_session_get_previous_char(s);
	following_char = ThaiKeymapList_Item_Get_Symbol(&gThaiKeymapList, nKeyboard_ID, key);

	ret = THAI_isaccepted(following_char, previous_char, nMode_ID);
	if (ret == True) {
		le_session_save_previous_char(s, following_char);
		le_commit_key(s, following_char);
	}
#if 0
	if (previous_char) {
		printf("previous_char: %c\t", previous_char);
	} else {
		printf("previous_char: 0\t");
	}

	if (following_char) {
		printf("following_char: %c\t", following_char);
	} else {
		printf("following_char: 0\t");
	}

	printf("accepted: %s\n", ret?"True":"False");
#endif
}

