/*
  Copyright 2002-2003 Sun Microsystems, Inc. All Rights Reserved.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.


  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


  Except as contained in this notice, the names of The Open Group and/or
  Sun Microsystems, Inc. shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from The Open Group and/or Sun Microsystems,
  Inc., as applicable.


  X Window System is a trademark of The Open Group

  OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
  logo, LBX, X Window System, and Xinerama are trademarks of the Open
  Group. All other trademarks and registered trademarks mentioned herein
  are the property of their respective owners. No right, title or
  interest in or to any trademark, service mark, logo or trade name of
  Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include <locale.h>

#include "encode.h"
#include "codepoint_im.h"

#define MAX_LINE_LEN  256

int lineno = 0;

char *skip_space(char *s)
{
  while (*s && (*s==' ' || *s=='\t')) s++;
  return s;
}

int LoadTableHeader (file_name, unit_table)
     char *file_name;
     TableStruct *unit_table;
{
  FILE *ifile;
  char line_buf[256], line[MAX_LINE_LEN];
  char *key, *value_str;
  register char *ptr;
  int len, line_index;
  int flag_section = DEFAULT_SECTION;

  log_f("codepoint_table: ==== LoadTableHeader ====\n");

  /* read table from file to memory buffer  */
  ifile = fopen (file_name, "r");
  if (! ifile) {
    fprintf(stderr, "Unable to open the input table file \"%s\"\n",file_name);
    return(-1);
  }

  while(fgets(line_buf, 255, ifile) != NULL) {
    lineno++;

    if((line_buf[0] == '#') && (line_buf[1] == '#')){
      log_f("COMMENTS \n");
      continue;
    }

    value_str = line_buf;
    ptr = skip_space(value_str);

    if (*ptr == '\0') break;

    /* if is space line, get new line 
       if (flag_section != COMMENT_SECTION) {
       if (*ptr == '\n')
       continue;
       }
    */

    line_index = 0;
    while(*ptr != '\n' && *ptr != '\0' && line_index < MAX_LINE_LEN) 
      line[line_index++] = *ptr++;

    /* trim right space */
    while (isspace(line[line_index-1])) line_index--;
    line[line_index] = '\0';

    key = line;
    len = strlen(line);
    log_f("len:%d, %s\n", strlen(line), line);

    if (line[0] == '[' && line[len-1] == ']') {
      /* get section name of the item */
      ptr = line + 1;
      while(isspace(*ptr)) ptr++;
      key = ptr;

      ptr = line + len - 2;
      while(isspace(*ptr)) ptr--;
      *(ptr+1) = '\0';

      if (!*key) continue;

      if (!(strncasecmp(key, DESCRIPTION_STR, strlen(DESCRIPTION_STR)))) {
	flag_section = DESCRIPTION_SECTION;
	continue;
      } 
    }

    switch (flag_section) {
    case DEFAULT_SECTION:
      break;

    case DESCRIPTION_SECTION:
      if(!(strncasecmp(key, LOCALE_STR, strlen(LOCALE_STR)))) {
	value_str = skip_space(key+strlen(LOCALE_STR));
	if ((*value_str == '\0') || (*value_str == '\n'))
	  continue;
	strcpy(unit_table->Lname, value_str);
	break;
      }

      if (!(strncasecmp(key, NAME_STR, strlen(NAME_STR)))) {
	value_str = skip_space(key+strlen(NAME_STR));
	if ((*value_str == '\0') || (*value_str == '\n'))
	  continue;

	strcpy(unit_table->Cname, value_str);
	break;
      }

      if (!(strncasecmp(key, INPUT_TYPE_STR, strlen(INPUT_TYPE_STR)))) {
	value_str = skip_space(key+strlen(INPUT_TYPE_STR));
	if ((*value_str == '\0') || (*value_str == '\n'))
	  continue;

	strcpy(unit_table->InputType, value_str);
	break;
      }

      if (!(strncasecmp(key, DEFAULT_INPUT_STR, strlen(DEFAULT_INPUT_STR)))) {
	value_str = skip_space(key+strlen(DEFAULT_INPUT_STR));
	if ((*value_str == '\0') || (*value_str == '\n'))
	  continue;

        unit_table->Default_Input = atoi(value_str) & 0xff;
	break;
      }

      if (!(strncasecmp(key, MAX_INPUT_STR, strlen(MAX_INPUT_STR)))) {
	value_str = skip_space(key+strlen(MAX_INPUT_STR));
	if ((*value_str == '\0') || (*value_str == '\n'))
	  continue;

        unit_table->Max_Input = atoi(value_str) & 0xff;
	break;
      }

      if (!(strncasecmp(key, ENCODE_STR, strlen(ENCODE_STR)))) {
	value_str = skip_space(key+strlen(ENCODE_STR));
	if ((*value_str == '\0') || (*value_str == '\n'))
	  continue;

	unit_table->Encode = get_encodeid_from_name(value_str);
	unit_table->Output_Encode = unit_table->Encode;
	break;
      }

      if (!(strncasecmp(key, USEDCODES_STR, strlen(USEDCODES_STR)))) {
	value_str = skip_space(key+strlen(USEDCODES_STR));
	if ((*value_str == '\0') || (*value_str == '\n'))
	  continue;

	strncpy(unit_table->UsedCodes, value_str, MAX_USEDCODES_NUM);
	break;
      }
    }
  } 
  fclose (ifile);
  return(0);
}
