#ifndef _PHONETIC_IM_H_
#define _PHONETIC_IM_H_

/* Limit Constant Defination */
#define MAX_CHNAME_LEN		256 
#define MAX_USEDCODES_NUM	126 

#define PHONETIC_ENGINE_NAME   "phonetic"
#define PHONETIC_CONFIG_NAME   "phonetic.cfg"
#define DESCRIPTION_STR   "Description"
#define LOCALE_STR  "Locale Name:"
#define NAME_STR    "Layout Name:"
#define ENCODE_STR    "Encode:"
#define USEDCODES_STR   "UsedCodes:"
#define FUNCTION_STR   "Function:"

#define IME_Status  ime_buffer->return_status
#define Input_Buf  ime_buffer->inputkey_buf
#define Input_Len  ime_buffer->inputkey_len
#define Preedit_Buf  ime_buffer->preedit_buf
#define prev_Preedit_Buf  ime_buffer->prev_preedit_buf
#define Preedit_Len  ime_buffer->preedit_len
#define Preedit_CaretPos ime_buffer->preedit_caretpos
#define Commit_Buf  ime_buffer->commit_buf
#define Commit_Len  ime_buffer->commit_len
#define Status_Buf  ime_buffer->status_buf
#define Status_Len  ime_buffer->status_len
#define Lookup_Buf  ime_buffer->lookup_buf
#define Lookup_Num  ime_buffer->lookup_num
#define Lookup_Pos  ime_buffer->cur_lookup_pos
#define Candidates_Buf  ime_buffer->candidates_buf
#define Additions_Buf  ime_buffer->additions_buf

/* Section Constant */
enum _Section_List {
	DEFAULT_SECTION = 0,
	DESCRIPTION_SECTION,
	MAX_SECTION_NUM
};

/* Bit Operations */
#define BITMASK(i) 		(1 << (i))
#define BITSET(a, i) 		((a) |= BITMASK(i))
#define BITCLEAR(a, i) 		((a) &= ~BITMASK(i))
#define GETBIT(a, i) 		((a) & BITMASK(i))

typedef int (*parse_token) (char *,unsigned char **, int *, int, int);
parse_token fArray[127];
int fNum;

typedef struct {
	char		Encode;				/* UTF-8 or native: encoding of table */	
  unsigned char   Lname[MAX_CHNAME_LEN];
	unsigned char 	Cname[MAX_CHNAME_LEN];  	/* IM Name */
	char 	Fname[MAX_CHNAME_LEN];  	/* Parse Routine Name */
	char  UsedCodes[MAX_USEDCODES_NUM]; /* Characters for valid input */
	char	Output_Encode;			/* encode of output */
  int   EngineId;
  char *ptr;
} TableStruct;

TableStruct *phtable_Info[127];
int table_Num;

int word_start_flag;
int word_separator_flag;
int word_end_flag;

#endif    /*  _PHONETIC_IM_H_  */
		
