/*
*******************************************************************************
*
*   Copyright (C) 1997-1999, International Business Machines
*   Corporation and others.  All Rights Reserved.
*
*******************************************************************************
*
*  FILE NAME : platform.h
*
*   Date        Name        Description
*   05/13/98    nos         Creation (content moved here from ptypes.h).
*   03/02/99    stephen     Added AS400 support.
*   03/30/99    stephen     Added Linux support.
*   04/13/99    stephen     Reworked for autoconf.
*******************************************************************************
*/
#ifdef COMMENTOUT
/* Define the platform we're on. */
#ifndef @platform@
#define @platform@
#endif
#endif

#undef int8_t

/* Define to unsigned char if not in <sys/types.h> */
#undef uint8_t 

/* Define to signed short if not in <sys/types.h> */
#undef int16_t 

/* Define to unsigned short if not in <sys/types.h> */
#undef uint16_t 

/* Define to signed long if not in <sys/types.h> */
#undef int32_t 

/* Define to unsigned long if not in <sys/types.h> */
#undef uint32_t 

/* Define to signed char if not in <sys/types.h> */
#undef bool_t 


#include <stdlib.h>
#include <ctype.h>

/* Define whether inttypes.h is available */
#define HAVE_INTTYPES_H 1

/* Determines whether specific types are available */
#define HAVE_INT8_T 1
#define HAVE_UINT8_T 1
#define HAVE_INT16_T 1
#define HAVE_UINT16_T 1
#define HAVE_INT32_T 1
#define HAVE_UINT32_T 1
#define HAVE_BOOL_T 0

/* Determines the endianness of the platform */
#define U_IS_BIG_ENDIAN 1

#define HAVE_DLOPEN @HAVE_DLOPEN@

/* 1 or 0 to enable or disable threads.  If undefined, default is: enable threads. */

/*===========================================================================*/
/* Generic data types                                                        */
/*===========================================================================*/

/* If your platform does not have the <inttypes.h> header, you may
   need to edit the typedefs below. */
#if HAVE_INTTYPES_H
#include <inttypes.h>
#else

#if ! HAVE_INT8_T
typedef signed char int8_t;
#endif

#if ! HAVE_UINT8_T
typedef unsigned char uint8_t;
#endif

#if ! HAVE_INT16_T
typedef signed short int16_t;
#endif

#if ! HAVE_UINT16_T
typedef unsigned short uint16_t;
#endif

#if ! HAVE_INT32_T
typedef signed long int32_t;
#endif

#if ! HAVE_UINT32_T
typedef unsigned long uint32_t;
#endif
#endif

#include <limits.h>
#define T_INT32_MAX (LONG_MAX)

/*===========================================================================*/
/* Symbol import-export control                                              */
/*===========================================================================*/

#define U_EXPORT
#define U_EXPORT2
#define U_IMPORT
