#ifndef __GTK__IIIM_WIN_H
#define __GTK__IIIM_WIN_H

#include <gtk/gtk.h>

#include "ime.h"

#define CANDIDATES_POSITION_PREEDIT_CARET    0
#define CANDIDATES_POSITION_IME              1
#define CANDIDATES_POSITION_PREEDIT_RIGHT    2
#define CANDIDATES_POSITION_PREEDIT_STARTS   3

#define TITLE_ABOVE_CANDIDATES               0
#define TITLE_BELOW_CANDIDATES               1
#define TITLE_LEFT2_CANDIDATES               0
#define TITLE_RIGHT2_CANDIDATES              1

typedef struct _tagPCStyleAtomic {
  int    showSystemBar;
  int    followCursor;
  int    composite;
  int    showPageControl;
  int    ignoreCandidateTitle;

  // following 3 is useless when composite != 0
  int    candidateVertical;
  int    candidatePosition;
  int    candidateTitlePosition;  // useless when ignoreCandidateTitle != 0
} TPCStyleAtomic;

#define PC_STYLE_CUSTOM                     0
#define PC_STYLE_ROOT                       1
#define PC_STYLE_CLASSIC                    2
#define PC_STYLE_TRADITIONAL                3
#define PC_STYLE_MODERN                     4

typedef struct _tagPCStyleOption {
    int             type;
    TPCStyleAtomic  customOption;
} TPCStyleOption;

typedef void* TIIimPCWin;

TIIimPCWin createStockPreeditCandidatesWindows(int stockStyle);
TIIimPCWin createPreeditCandidatesWindows(TPCStyleAtomic* style);
//void recreateWindows(TIIimPCWin vpc, TPCStyleOption* pstyle);
void freePreeditCandidatesWindows(TIIimPCWin vpc);

void movePreedit(TIIimPCWin vpc, int cursor_x, int cursor_y, int cursor_w, int cursor_h);

void showPreedit(TIIimPCWin vpc);
void hidePreedit(TIIimPCWin vpc);
void updatePreedit(TIIimPCWin vpc, const char* label, int caret, int candidate_start, int nfbs, ImeFeedbackRec*fbs);

void showCandidates(TIIimPCWin vpc);
void hideCandidates(TIIimPCWin vpc);
void updateCandidates(TIIimPCWin vpc, int num, const char* candidates[], const char* title,
                      int firstIdx, int focusIdx, int total, int *p_fb_counts, ImeFeedbackRec **pfbs);

int  isPCFollowCursor(TIIimPCWin vpc);
int  is_pc_preedit_show(TIIimPCWin vpc);
int  is_pc_candidates_show(TIIimPCWin vpc);

TPCStyleOption* getStyles(TIIimPCWin vpc);
void getPCCursorPosition(TIIimPCWin vpc, int *pcursor_x, int *pcursor_y, int *pcursor_w, int* pcursor_h);


#define PC_PAGE_FIRST          0
#define PC_PAGE_PREV           1
#define PC_PAGE_NEXT           2
#define PC_PAGE_LAST           3

typedef void (*TIIimPCWinCallback)(TIIimPCWin vpc, int op);

void registerStyleChangeCallback(TIIimPCWin vpc, TIIimPCWinCallback callback);
void registerPageCallback(TIIimPCWin vpc, TIIimPCWinCallback callback);
void registerSelectionCallback(TIIimPCWin vpc, TIIimPCWinCallback callback);
void registerMoveCallback(TIIimPCWin vpc, TIIimPCWinCallback callback);


#endif

