#include <stdio.h>

#include "le_info.h"

ImmKeybindingRec *imm_keybinding_new()
{
    ImmKeybindingRec *imm_keybinding = NULL;

    imm_keybinding =
	(ImmKeybindingRec *) calloc(1, sizeof(ImmKeybindingRec));
    if (imm_keybinding == NULL)
	return (NULL);

    imm_keybinding->keycode = 0;
    imm_keybinding->keychar = 0;
    imm_keybinding->modifier = 0;
    imm_keybinding->defined_type = 0;
    return (imm_keybinding);
}

LeResult imm_keybinding_destroy(ImmKeybindingRec * imm_keybinding)
{
    if (imm_keybinding == NULL)
	return (LE_FAIL);

    free((char *) imm_keybinding);
    return (LE_OK);
}

int imm_keybinding_print(ImmKeybindingRec * imm_keybinding)
{
#if DEBUG
    if (imm_keybinding == NULL)
	return (LE_FAIL);

    printf(" keycode: 0x%x  modifier: %d: defined_type: %d\n",
	   imm_keybinding->keycode,
	   imm_keybinding->modifier, imm_keybinding->defined_type);

    return (LE_OK);
#endif
}

int imm_keybinding_set_value(ImmKeybindingRec * imm_keybinding,
			     char *keycode_str, char *modifier_str,
			     char *key_type_str)
{
    int keycode, keychar, modifier;
    int defined_type;

    if (imm_keybinding == NULL)
	return (LE_FAIL);
    if (!keycode_str || !*keycode_str)
	return (LE_FAIL);
    if (!modifier_str || !*modifier_str)
	return (LE_FAIL);
    if (!key_type_str || !*key_type_str)
	return (LE_FAIL);

    DEBUG_printf("keycode: %s, modifier: %s, type: %s\n", keycode_str,
		 modifier_str, key_type_str);
    keycode = 0;
    keychar = 0;
    modifier = 0;
    defined_type = 0;

    imm_keybinding->keycode = keycode;
    imm_keybinding->keychar = keychar;
    imm_keybinding->modifier = modifier;
    imm_keybinding->defined_type = defined_type;

    return (LE_OK);
}
