/*
  Copyright 2002-2003 Sun Microsystems, Inc. All Rights Reserved.

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the
  "Software"), to deal in the Software without restriction, including
  without limitation the rights to use, copy, modify, merge, publish,
  distribute, sublicense, and/or sell copies of the Software, and to
  permit persons to whom the Software is furnished to do so, subject to
  the following conditions: The above copyright notice and this
  permission notice shall be included in all copies or substantial
  portions of the Software.


  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
  IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
  CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
  THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
  ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


  Except as contained in this notice, the names of The Open Group and/or
  Sun Microsystems, Inc. shall not be used in advertising or otherwise to
  promote the sale, use or other dealings in this Software without prior
  written authorization from The Open Group and/or Sun Microsystems,
  Inc., as applicable.


  X Window System is a trademark of The Open Group

  OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
  logo, LBX, X Window System, and Xinerama are trademarks of the Open
  Group. All other trademarks and registered trademarks mentioned herein
  are the property of their respective owners. No right, title or
  interest in or to any trademark, service mark, logo or trade name of
  Sun Microsystems, Inc. or its licensors is granted.

*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <stdio.h>
#include <strings.h>
#include <stdlib.h>
#include <wchar.h>
#include "SunIM.h"
#include "codepoint_im.h"
#include "unit_input.h"
#include "codepoint_filter.h"
#include "logf.h"

int Check_Input_Type(unit_table) 
     TableStruct *unit_table;
{
  if (!strcmp((char *)unit_table->InputType, (char *)"HEX"))
    return(0); 
  return(1); 
}

int Is_UsedCodes_Key(unit_table, key)
     TableStruct *unit_table;
     int key;
{
  if ( index(unit_table->UsedCodes, key) )
    return(1);
  else
    return(0);
}

int Is_Commit_Key(unit_table, key)
     TableStruct *unit_table;
     int key;
{
  if (key == RETURN_KEY || key == SPACE_KEY)
    return(1);
  else
    return(0);
}

int Is_BackSpace_Key(unit_table, key)
     TableStruct *unit_table;
     int key;
{
  if (key == BACKSPACE_KEY || key == DELETE_KEY)
    return(1);
  else
    return(0);
}

int Is_ClearAll_Key(unit_table, key)
     TableStruct *unit_table;
     int key;
{
  if (key == ESC_KEY)
    return(1);
  else
    return(0);
}

int commit_candidate(ime_buffer, unit_table)
     IMEBufferRec *ime_buffer;
     TableStruct *unit_table;
{
  char *ret;
  char tmpstr[80];
  unsigned int *from_buf;
  unsigned char *to_buf;

  esc_key_flag = 0;
  from_buf = (unsigned int *)calloc(10, sizeof(unsigned int));
  to_buf = (unsigned char *)calloc(256, sizeof(unsigned char));

  (void)memset((char *)tmpstr,'\0',sizeof(tmpstr));
  if (!Check_Input_Type(unit_table)){
    sprintf(tmpstr,"0X%s",Preedit_Buf);
  }else{
    sprintf(tmpstr,"0%s",Preedit_Buf);
  }
  from_buf[0] = (wchar_t)strtol(tmpstr,&ret, 0);
  if (from_buf[0] == IM_VK_ENTER) {
    return RETURN_KEY;
  }
  from_buf[1] = L'\0'; 
  convert_UCS4_to_UTF8(from_buf, to_buf);
  (void)strcpy((char *)Commit_Buf, (char *)to_buf);
  Commit_Len = strlen((char *)Commit_Buf);
  log_f("Inside commit_candidate, Commit_Buf <%s>\n",Commit_Buf);
  IME_Status = IME_COMMIT;
  free(from_buf);
  free(to_buf);
  return(0);
}

void warning_bell()
{
}

/* return value:  IME_NOT_USED_KEY:  if IME not use this key, return */ 
/*                                   this key to systerm directly    */
/*                IME_USED_KEY:      if IME has used this key        */

int codepoint_filter(unit_table, key_event, ime_buffer)
     TableStruct *unit_table;
     IMEKey key_event;
     IMEBufferRec *ime_buffer;
{
  int     key, default_input_len;
 
  ime_buffer->encode = unit_table->Encode;
  default_input_len = unit_table->Default_Input;

  IME_Status = 0;

  key = map_keyevent_to_imekey(unit_table, key_event);
  log_f("codepoint_filter: map_keyevent_to_imekey: return key:0x%x\n", key);
 
  if (key == IME_NOT_USED_KEY){
    log_f("IME_NOT_USED_KEY \n");
    return(IME_NOT_USED_KEY);
  }

  if (esc_key_flag)
    default_input_len = unit_table->Max_Input; 

  if (Is_UsedCodes_Key(unit_table, key)){
    /* if not key by key, and is selectkey, and Lookup Mode */
    /* directly select */
  
    Input_Buf[Input_Len] = key;
    Input_Len ++;
    Input_Buf[Input_Len] = 0;
  
    log_f("Input_Len:%d\n",Input_Len);

    if (Input_Len == default_input_len){
      Preedit_Buf[Preedit_Len] = key;
      Preedit_Len += 1;
      Preedit_Buf[Preedit_Len] = '\0';
      if (commit_candidate(ime_buffer, unit_table) == RETURN_KEY) {
        Preedit_Len = 0;
        Preedit_CaretPos = 0;
        Input_Len = 0;
        Input_Buf[Input_Len]='\0';
        IME_Status |= IME_PREEDIT_AREA; 
        return RETURN_KEY;
      }
      Preedit_Len = 0;
      Preedit_CaretPos = 0;
      Input_Len = 0;
      Input_Buf[Input_Len]='\0';
      IME_Status |= IME_PREEDIT_AREA; 
      return(IME_USED_KEY);
    }

    Preedit_Buf[Preedit_Len] = key;
    Preedit_Len += 1;
    Preedit_Buf[Preedit_Len] = '\0';
    Preedit_CaretPos = Preedit_Len;
    IME_Status = IME_PREEDIT_AREA;
    return(IME_USED_KEY);
  }

  if (Is_ClearAll_Key(unit_table, key)) { 
    /* Esc , clear preedit and so on */
    log_f("ESC_KEY\n");
    if (!esc_key_flag)
      esc_key_flag = 1;
    else
      esc_key_flag = 0;

    return(IME_NOT_USED_KEY);
  }

  if (Is_BackSpace_Key(unit_table, key)) { /* Back Space & Delete */
    log_f("BACKSPACE_KEY, Input_Len:%d, Preedit_Len:%d\n", Input_Len, Preedit_Len);
    /*  if no inputted key, directly return this key */
    if (Input_Len==0) {
      return(IME_NOT_USED_KEY);
    }

    Input_Len --;
    Input_Buf[Input_Len] = '\0';
    Preedit_Len -= 1;
    Preedit_Buf[Preedit_Len] = '\0';
    Preedit_CaretPos = Preedit_Len;
    IME_Status = IME_PREEDIT_AREA;

    return(IME_USED_KEY);
  }

  if (Is_Commit_Key(unit_table, key)) { /* space or return key */
    log_f("SPACE/RETURN KEY\n");
    if (Input_Len==0){
      return(IME_NOT_USED_KEY);
    }

    /* if any keys and key is Space key and mode is not keybykey */
    /* then search and display the candidates */

    if (Preedit_Len > 0){
      log_f("RETURN/SPACE key: Input_Buf:%s\n",Input_Buf);
      log_f("RETURN/SPACE key: Preedit_Buf:%s\n",Preedit_Buf);
      commit_candidate(ime_buffer, unit_table);
    }
    /* clear Preedit_Buf and Input_Buf */ 
    Preedit_Len = 0;
    Preedit_CaretPos = 0;
    Input_Len = 0;
    Input_Buf[Input_Len]='\0';
    IME_Status |= IME_PREEDIT_AREA; 
    return(IME_USED_KEY);
  }

  /* for unnormal keys 
     if (Input_Len==0) return(IME_NOT_USED_KEY);
     else return(IME_USED_KEY);
  */
  return(IME_USED_KEY);
}

/*********************** Key Mapping ***********************/

/*  get the keys that IME will use */
int map_keyevent_to_imekey(TableStruct *unit_table, IMEKey key_event)
{
  int keycode, keystatus, keychar;

  keycode = key_event->keyCode;
  keychar = key_event->keyChar;
  keystatus = key_event->modifier;

  log_f("codepoint_filter: keycode: 0x%x, keychar:0x%x, keystatus: 0x%x\n", keycode, keychar, keystatus);
  /* normal status */
  if (keystatus  == 0) {
    /* Function Keys */
    if (keychar == 0) {
      log_f(" Function Key :%d\n", keycode);
      switch (keycode) {
      case IM_VK_ESCAPE:
	return(ESC_KEY);

      case IM_VK_BACK_SPACE:
	return(BACKSPACE_KEY);

      case IM_VK_ENTER:
	return(RETURN_KEY);

      case IM_VK_INSERT:
	return(INSERT_KEY);

      case IM_VK_DELETE:
	return(DELETE_KEY);

      case IM_VK_HOME:
	return(HOME_KEY);

      case IM_VK_END:
	return(END_KEY);

      case IM_VK_PAGE_UP:
	return(PAGEUP_KEY);

      case IM_VK_PAGE_DOWN:
	return(PAGEDOWN_KEY);

      }
      return(IME_NOT_USED_KEY);
    } else {
      /*  normal key  */
      log_f("codepoint_filter:  Normal Key :0x%x, %c\n", keychar, keychar);
      return(keychar);
    }
  }

  /*  Shift status */
  if (keystatus == IM_SHIFT_MASK) {
    if (keychar != 0) {
      /*  normal key  */
      log_f("codepoint_filter:  Ascii Key :0x%x, %c\n", keychar, keychar);
      return(keychar);
    }
  }
  return (IME_NOT_USED_KEY);
}

int convert_UCS4_to_UTF8 (unsigned int *from_buf, unsigned char *to_buf) {
  int to_len = 0;
  unsigned char *ptr = to_buf;
                                                                                              
  if ( *from_buf <= 0x7F) {
    *ptr++ = (unsigned char) *from_buf;
    to_len++;
    from_buf++;
  } else if ( *from_buf <= 0x07FF ) {
    *ptr++= (unsigned char) ((*from_buf >> 6) | 0xC0 );
    *ptr++= (unsigned char) ((*from_buf & 0x3F) | 0x80 );
    to_len+=2;
    from_buf++;
  } else if ( *from_buf <= 0xFFFF ) {
    *ptr++= (unsigned char) ((*from_buf >> 12) | 0xE0 );
    *ptr++= (unsigned char) ((*from_buf >> 6 & 0x3F) | 0x80 );
    *ptr++= (unsigned char) ((*from_buf & 0x3F) | 0x80 );
    to_len+=3;
    from_buf++;
  } else if ( *from_buf <= 0x1FFFFF ) {
    *ptr++= (unsigned char) ((*from_buf >> 18) | 0xF0 );
    *ptr++= (unsigned char) (((*from_buf >> 12) & 0x3F) | 0x80 );
    *ptr++= (unsigned char) ((*from_buf >> 6 & 0x3F) | 0x80 );
    *ptr++= (unsigned char) ((*from_buf & 0x3F)| 0x80 );
    to_len+=4;
    from_buf++;
  }
  log_f("to_len [%d]\n",to_len);
  return (to_len);
}
