#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#if defined(lint) && defined(HAVE_NOTE_H)
#include <note.h>
#endif /* lint && HAVE_NOTE_H */

#include <iiimp-data.h>
#include <iiimp-opcode.h>

#include "iiimp-dataP.h"


IIIMP_message *
iiimp_select_hotkey_profile_new(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	scope_and_profile_id)
{
    IIIMP_message *	m;
    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    m->opcode = IM_SELECT_HOTKEY_PROFILE;
    m->im_id = im_id;
    m->ic_id = -1;
    m->v.select_hotkey_profile.scope_and_profile_id = scope_and_profile_id;
    m->v.select_hotkey_profile.scope = -1;
    m->v.select_hotkey_profile.profile_id = -1;
    return m;
}


void
iiimp_select_hotkey_profile_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
#if defined(lint) && defined(HAVE_NOTE_H)
    NOTE(ARGUNUSED(data_s))
#endif /* lint && HAVE_NOTE_H */
	free(m);
}


uchar_t *
iiimp_select_hotkey_profile_pack(
    IIIMP_data_s *	data_s,
    IIIMP_card16	im_id,
    IIIMP_card16	scope_and_profile_id,
    size_t *		buf_size)
{
    size_t		nbyte;
    int			length;
    uchar_t *		buf;
    size_t		rest;
    uchar_t *		p;

    nbyte = 0
	+ 2	 /* input method id */
	+ 2	 /* PAD(2) or IC_ID */
	+ 2;      /* SCOPE and PROFILE ID */

    nbyte += PAD(nbyte);

    length = (nbyte >> 2);
    *buf_size = (1 + 3 + nbyte);

    buf = (uchar_t *)malloc(1 + 3 + nbyte);
    if (NULL == buf) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }

    PUT_PACKET_HEADER(buf, IM_SELECT_HOTKEY_PROFILE, length);

    rest = nbyte;
    p = (buf + 4);

    PUTU16(im_id, rest, p, data_s->byte_swap);
    PUTU16(0, rest, p, data_s->byte_swap);
    PUTU16(scope_and_profile_id, rest, p, data_s->byte_swap);

    return buf;
}


IIIMP_message *
iiimp_select_hotkey_profile_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    IIIMP_message *			m;
    IIIMP_select_hotkey_profile_v *	v;
    size_t	                     rest;
    const uchar_t *			p;

    rest = *nbyte;
    p = *ptr;

    if (rest < (2 + 2 + 2 + 2)) {
	data_s->status = IIIMP_DATA_INVALID;
	return NULL;
    }

    m = (IIIMP_message *)malloc(sizeof (IIIMP_message));
    if (NULL == m) {
	data_s->status = IIIMP_DATA_MALLOC_ERROR;
	return NULL;
    }
    v = &(m->v.select_hotkey_profile);

    m->opcode = opcode;

    GETU16(m->im_id, rest, p, data_s->byte_swap);
    m->ic_id = -1;
    SKIP16(rest, p);
    GET_SCOPE_FOR_HOTKEY(v->scope, p, data_s->byte_swap);
    GETU15(v->profile_id, p, data_s->byte_swap);
    GETU16(v->scope_and_profile_id, rest, p, data_s->byte_swap);

    *nbyte = rest;
    *ptr = p;

    return m;
}


void
iiimp_select_hotkey_profile_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    iiimp_message_header_print(data_s, m->opcode, m->im_id, m->ic_id);
    (void)fprintf(data_s->print_fp, "\tSCOPE = %d\n",
		  m->v.select_hotkey_profile.scope);
    (void)fprintf(data_s->print_fp, "\tPROFILE_ID = %d\n", m->v.select_hotkey_profile.profile_id);
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
