#include <stdlib.h>
#include <string.h>
#include <iconv.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

#include <iiimp.h>
#include <iiimp-data.h>
#include <iiimp-file-operation.h>

#include "iiimp-dataP.h"

IIIMP_string *
ascii_to_string(IIIMP_data_s * data_s, const char * from) {
    static iconv_t	cd;
    size_t		str_length;
    IIIMP_string *	str_string;
    IIIMP_card16 *	str_card16;
    size_t		str_size;
    const char *	inbuf;
    char *		outbuf;
    size_t		inbytesleft;
    size_t		outbytesleft;

    if (NULL == from) {
	if (0 != (int)cd) {
	    iconv_close(cd);
	}
	return NULL;
    }

    if (0 == (int)cd) {
	cd = iconv_open("UTF-16BE", "646");
    }

    str_length = strlen(from);
    str_size = ((sizeof (IIIMP_card16)) * str_length);

    str_card16 = (IIIMP_card16 *)malloc(str_size);

    inbuf = from;
    inbytesleft = str_length;
    outbuf = (char *)str_card16;
    outbytesleft = str_size;

    iconv(cd, &inbuf, &inbytesleft, &outbuf, &outbytesleft);

    str_string = iiimp_string_new(data_s, str_length, str_card16);

    free(str_card16);

    return str_string;
}


void
test_fop_close(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_request_close_new(data_s, 56);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_creat(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path;

    path = ascii_to_string(data_s, "/var/lib/iiim/le/sample/users/hoge/private.data");

    data_pre = iiimp_file_operation_request_creat_new(data_s, path, O_RDWR);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_ftruncate(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_request_ftruncate_new(data_s, 22, 123);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_lseek(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_request_lseek_new(data_s, 4, 513, SEEK_END);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_open(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path;

    path = ascii_to_string(data_s, "/var/lib/iiim/le/sample/users/hoge/private.data");

    data_pre = iiimp_file_operation_request_open_new(data_s, path, O_CREAT|O_TRUNC|O_APPEND|O_EXCL, 0666);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_read(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_request_read_new(data_s, 2, 1023);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_truncate(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path;

    path = ascii_to_string(data_s, "/var/lib/iiim/le/sample/users/hoge/private.data");
    data_pre = iiimp_file_operation_request_truncate_new(data_s, path, 1025);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_write(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    uchar_t *				write_data;
    size_t				write_data_len;
    int					i;

    write_data_len = 9;
    write_data = (uchar_t *)malloc(write_data_len);
    for (i = 0; i < write_data_len; i++) {
	write_data[i] = i;
    }
    data_pre = iiimp_file_operation_request_write_new(data_s, 4, write_data_len,
						      write_data);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
    free(write_data);
}



void
test_fop_link(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path_existing;
    IIIMP_string *			path_new;

    path_existing = ascii_to_string(data_s, "/path/to/existing/file");
    path_new = ascii_to_string(data_s, "/this/file/is/new");

    data_pre = iiimp_file_operation_request_link_new(data_s, path_existing, path_new);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_readlink(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path;

    path = ascii_to_string(data_s, "/read/the/link/target");

    data_pre = iiimp_file_operation_request_readlink_new(data_s, path);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_rename(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path_old;
    IIIMP_string *			path_new;

    path_old = ascii_to_string(data_s, "/path/to/old/file");
    path_new = ascii_to_string(data_s, "/this/file/is/new");

    data_pre = iiimp_file_operation_request_rename_new(data_s, path_old, path_new);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_symlink(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			name1;
    IIIMP_string *			name2;

    name1 = ascii_to_string(data_s, "/path/to/name1");
    name2 = ascii_to_string(data_s, "/name2/file");

    data_pre = iiimp_file_operation_request_symlink_new(data_s, name1, name2);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_unlink(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path;

    path = ascii_to_string(data_s, "/path/to/be/unlink");

    data_pre = iiimp_file_operation_request_unlink_new(data_s, path);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_chmod(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path;

    path = ascii_to_string(data_s, "/path/to/be/chmod");

    data_pre = iiimp_file_operation_request_chmod_new(data_s, path, 0700);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_chown(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path;
    IIIMP_string *			user;
    IIIMP_string *			group;

    path = ascii_to_string(data_s, "/path/to/be/chown");
    user = ascii_to_string(data_s, "user");
    group = ascii_to_string(data_s, "group");

    data_pre = iiimp_file_operation_request_chown_new(data_s, path, user, 1192, group, 1468);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_fchmod(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_request_fchmod_new(data_s, 5, 0711);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_fchown(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			user;
    IIIMP_string *			group;

    user = ascii_to_string(data_s, "USER");
    group = ascii_to_string(data_s, "GROUP");

    data_pre = iiimp_file_operation_request_fchown_new(data_s, 6, user, 2222, group, 3333);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}



void
test_fop_utime(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path;

    path = ascii_to_string(data_s, "/path/to/be/utime");

    data_pre = iiimp_file_operation_request_utime_new(data_s, path, 4444, 5555);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_utimes(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path;

    path = ascii_to_string(data_s, "/path/to/be/utimes");

    data_pre = iiimp_file_operation_request_utimes_new(data_s, path, 11111, 22222, 33333, 44444);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_fstat(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_request_fstat_new(data_s, 9);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_lstat(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path;

    path = ascii_to_string(data_s, "/path/to/be/lstat");

    data_pre = iiimp_file_operation_request_lstat_new(data_s, path);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_stat(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path;

    path = ascii_to_string(data_s, "/path/to/be/stat");

    data_pre = iiimp_file_operation_request_stat_new(data_s, path);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_access(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path;

    path = ascii_to_string(data_s, "/path/to/be/access");

    data_pre = iiimp_file_operation_request_access_new(data_s, path, R_OK);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_closedir(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_request_closedir_new(data_s, 0xABCDEF01);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_opendir(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path;

    path = ascii_to_string(data_s, "/path/to/be/opendir");

    data_pre = iiimp_file_operation_request_opendir_new(data_s, path);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_readdir(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_request_readdir_new(data_s, 0xBCDEF012);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_rewinddir(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_request_rewinddir_new(data_s, 0xCDEF0123);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_seekdir(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_request_seekdir_new(data_s, 0xDEF01234, 99);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_telldir(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_request_telldir_new(data_s, 0xEF012345);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}



void
test_fop_mkdir(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path;

    path = ascii_to_string(data_s, "/path/to/be/mkdir");

    data_pre = iiimp_file_operation_request_mkdir_new(data_s, path, 0751);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_rmdir(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path;

    path = ascii_to_string(data_s, "/path/to/be/rmdir");

    data_pre = iiimp_file_operation_request_rmdir_new(data_s, path);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
test_fop_fcntl(IIIMP_data_s * data_s) {
    IIIMP_file_operation_request *	data_pre;
    IIIMP_file_operation_request *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_file_operation_data_fcntl *	arg;

    arg = iiimp_file_operation_data_fcntl_setfd_new(data_s, FD_CLOEXEC);
    data_pre = iiimp_file_operation_request_fcntl_new(data_s, 10, F_SETFD, arg);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);


    arg = iiimp_file_operation_data_fcntl_flock_new(data_s, F_RDLCK,
						    SEEK_SET, 10, 11);
    data_pre = iiimp_file_operation_request_fcntl_new(data_s, 10, F_SETLK, arg);
    iiimp_file_operation_request_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_request_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_request_unpack(data_s, &nbyte,
						    (const uchar_t **)(&bufp), nbyte);
    iiimp_file_operation_request_print(data_s, data_post);

    iiimp_file_operation_request_delete(data_s, data_pre);
    iiimp_file_operation_request_delete(data_s, data_post);
    free(buf);
}


void
do_all(IIIMP_data_s * data_s)
{
    test_fop_close(data_s);
    test_fop_creat(data_s);
    test_fop_ftruncate(data_s);
    test_fop_lseek(data_s);
    test_fop_open(data_s);
    test_fop_read(data_s);
    test_fop_truncate(data_s);
    test_fop_write(data_s);

    test_fop_link(data_s);
    test_fop_readlink(data_s);
    test_fop_rename(data_s);
    test_fop_symlink(data_s);
    test_fop_unlink(data_s);

    test_fop_chmod(data_s);
    test_fop_chown(data_s);
    test_fop_fchmod(data_s);
    test_fop_fchown(data_s);

    test_fop_utime(data_s);
    test_fop_utimes(data_s);

    test_fop_fstat(data_s);
    test_fop_lstat(data_s);
    test_fop_stat(data_s);
    test_fop_access(data_s);

    test_fop_closedir(data_s);
    test_fop_opendir(data_s);
    test_fop_readdir(data_s);
    test_fop_rewinddir(data_s);
    test_fop_seekdir(data_s);
    test_fop_telldir(data_s);

    test_fop_mkdir(data_s);
    test_fop_rmdir(data_s);

    test_fop_fcntl(data_s);

    return;
}


void
test_fop_close_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_close_new(data_s, 1, EPERM);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_creat_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_creat_new(data_s, 3, ENOENT);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_ftruncate_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_ftruncate_new(data_s, 3, EINTR);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_lseek_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_lseek_new(data_s, 4, EIO);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_open_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_open_new(data_s, 5, ENXIO);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_read_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    uchar_t *				read_data;
    size_t				read_data_len;
    int					i;

    read_data_len = 12;
    read_data = (uchar_t *)malloc(read_data_len);
    for (i = 0; i < read_data_len; i++) {
	read_data[i] = (i + 5);
    }

    data_pre = iiimp_file_operation_result_read_new(data_s, EBADF,
						    read_data_len, read_data);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
    free(read_data);
}


void
test_fop_truncate_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_truncate_new(data_s, 4, EAGAIN);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_write_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_write_new(data_s, 1, ENOMEM);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}



void
test_fop_link_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_link_new(data_s, 1, EACCES);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_readlink_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_string *			path;

    path = ascii_to_string(data_s, "/link/to/this/file");

    data_pre = iiimp_file_operation_result_readlink_new(data_s, 1, EFAULT, path);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_rename_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_rename_new(data_s, 1, EBUSY);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_symlink_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_symlink_new(data_s, 1, EEXIST);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_unlink_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_unlink_new(data_s, 2, EXDEV);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_chmod_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_chmod_new(data_s, 1, ENOTDIR);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_chown_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_chown_new(data_s, 2, EISDIR);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_fchmod_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_fchmod_new(data_s, 1, EINVAL);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_fchown_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_fchown_new(data_s, 2, ENFILE);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}



void
test_fop_utime_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_utime_new(data_s, 1, EMFILE);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_utimes_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_utimes_new(data_s, 1, ETXTBSY);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_fstat_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_file_operation_data_stat *	st;
    IIIMP_string *			user;
    IIIMP_string *			group;

    user = ascii_to_string(data_s, "USER");
    group = ascii_to_string(data_s, "GROUP");

    st = iiimp_file_operation_data_stat_new(data_s,
					    0775, 12345, 66, 77, 2,
					    user, 1122, group, 3344,
					    512,
					    6789, 7890, 8901, 9012, 123, 1234,
					    2048, 1);

    data_pre = iiimp_file_operation_result_fstat_new(data_s, 1, EFBIG, st);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_lstat_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_file_operation_data_stat *	st;
    IIIMP_string *			user;
    IIIMP_string *			group;

    user = ascii_to_string(data_s, "USER1");
    group = ascii_to_string(data_s, "GROUP1");

    st = iiimp_file_operation_data_stat_new(data_s,
					    0774, 23456, 88, 99, 3,
					    user, 5566, group, 7788,
					    1024,
					    2345, 3456, 4567, 5678, 6789, 7890,
					    4096, 2);

    data_pre = iiimp_file_operation_result_lstat_new(data_s, 1, ENOSPC, st);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_stat_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_file_operation_data_stat *	st;
    IIIMP_string *			user;
    IIIMP_string *			group;

    user = ascii_to_string(data_s, "USER2");
    group = ascii_to_string(data_s, "GROUP2");

    st = iiimp_file_operation_data_stat_new(data_s,
					    0744, 34567, 11, 22, 4,
					    user, 9900, group, 1122,
					    8192,
					    8901, 9012, 123, 2345, 3456, 4567,
					    8192, 1);

    data_pre = iiimp_file_operation_result_stat_new(data_s, 1, EROFS, st);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_access_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_access_new(data_s, 2, EMLINK);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_closedir_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_closedir_new(data_s, 1, EDEADLK);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_opendir_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_opendir_new(data_s, 0xABCDEF01, ENOSPC);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_readdir_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_file_operation_data_dir *	entry;
    IIIMP_string *			path;

    path = ascii_to_string(data_s, "file");

    entry = iiimp_file_operation_data_dir_new(data_s, 1235, 3, path);

    data_pre = iiimp_file_operation_result_readdir_new(data_s, EDQUOT, entry);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_rewinddir_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_rewinddir_new(data_s);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_seekdir_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_seekdir_new(data_s);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_telldir_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_telldir_new(data_s, 1, ENAMETOOLONG);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}



void
test_fop_mkdir_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_mkdir_new(data_s, 1, EOVERFLOW);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_rmdir_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;

    data_pre = iiimp_file_operation_result_rmdir_new(data_s, 1, ENOSYS);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
test_fop_fcntl_result(IIIMP_data_s * data_s) {
    IIIMP_file_operation_result *	data_pre;
    IIIMP_file_operation_result *	data_post;
    size_t 				nbyte;
    uchar_t *				buf;
    uchar_t *				bufp;
    IIIMP_file_operation_data_fcntl *	arg;

    arg = iiimp_file_operation_data_fcntl_setfd_new(data_s, FD_CLOEXEC);
    data_pre = iiimp_file_operation_result_fcntl_new(data_s, 1, ELOOP, F_SETFD, arg);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);

    arg = iiimp_file_operation_data_fcntl_flock_new(data_s, F_RDLCK,
						    SEEK_SET, 10, 11);
    data_pre = iiimp_file_operation_result_fcntl_new(data_s, 1, EAGAIN, F_SETLK, arg);
    iiimp_file_operation_result_print(data_s, data_pre);

    nbyte = data_pre->nbyte;
    buf = (uchar_t *)malloc(nbyte);
    bufp = buf;
    iiimp_file_operation_result_pack(data_s, data_pre, &nbyte, &bufp);

    nbyte = data_pre->nbyte;
    bufp = buf;
    data_post = iiimp_file_operation_result_unpack(data_s, &nbyte,
						   (const uchar_t **)(&bufp),
						   nbyte);
    iiimp_file_operation_result_print(data_s, data_post);

    iiimp_file_operation_result_delete(data_s, data_pre);
    iiimp_file_operation_result_delete(data_s, data_post);
    free(buf);
}


void
do_all_result(IIIMP_data_s * data_s)
{
    test_fop_close_result(data_s);
    test_fop_creat_result(data_s);
    test_fop_ftruncate_result(data_s);
    test_fop_lseek_result(data_s);
    test_fop_open_result(data_s);
    test_fop_read_result(data_s);
    test_fop_truncate_result(data_s);
    test_fop_write_result(data_s);

    test_fop_link_result(data_s);
    test_fop_readlink_result(data_s);
    test_fop_rename_result(data_s);
    test_fop_symlink_result(data_s);
    test_fop_unlink_result(data_s);

    test_fop_chmod_result(data_s);
    test_fop_chown_result(data_s);
    test_fop_fchmod_result(data_s);
    test_fop_fchown_result(data_s);

    test_fop_utime_result(data_s);
    test_fop_utimes_result(data_s);

    test_fop_fstat_result(data_s);
    test_fop_lstat_result(data_s);
    test_fop_stat_result(data_s);
    test_fop_access_result(data_s);

    test_fop_closedir_result(data_s);
    test_fop_opendir_result(data_s);
    test_fop_readdir_result(data_s);
    test_fop_rewinddir_result(data_s);
    test_fop_seekdir_result(data_s);
    test_fop_telldir_result(data_s);

    test_fop_mkdir_result(data_s);
    test_fop_rmdir_result(data_s);

    test_fop_fcntl_result(data_s);

    return;
}


int
main(int argc, char ** argv)
{
    IIIMP_data_s *	data_s;

    data_s = iiimp_data_s_new();

    do_all(data_s);

    do_all_result(data_s);

    ascii_to_string(data_s, NULL);

    iiimp_data_s_delete(data_s);

    return 0;
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
