#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "imapfilter.h"
#include "pathnames.h"


extern options_t opts;


/*
 * Create imapfilter's home directory.
 */
int
create_homedir(void)
{
	char hd[PATH_MAX];

	snprintf(hd, PATH_MAX, "%s/%s", opts.home, PATHNAME_HOME);

	if (!exists_dir(hd)) {
		if (mkdir(hd, S_IRUSR | S_IWUSR | S_IXUSR))
			error("could not create directory %s; %s\n", hd,
			    strerror(errno));
	}
	return 0;
}


/*
 * Check if a file exists.
 */
int
exists_file(char *fname)
{
	struct stat fs;

	if (access(fname, F_OK))
		return 0;

	stat(fname, &fs);
	if (!S_ISREG(fs.st_mode)) {
		error("file %s not a regular file\n", fname);
		return -1;
	}
	return 1;
}


/*
 * Check if a directory exists.
 */
int
exists_dir(char *dname)
{
	struct stat ds;

	if (access(dname, F_OK))
		return 0;

	stat(dname, &ds);
	if (!S_ISDIR(ds.st_mode)) {
		error("file %s not a directory\n", dname);
		return -1;
	}
	return 1;
}


/*
 * Create a file with the specified permissions.
 */
int
create_file(char *fname, mode_t mode)
{
	int fd;

	fd = 0;

	if (!exists_file(fname)) {
		fd = open(fname, O_CREAT | O_WRONLY | O_TRUNC, mode);
		if (fd == -1) {
			error("could not create file %s; %s\n", fname,
			    strerror(errno));
			return -1;
		}
		close(fd);
	}
	return 0;
}
