#ifndef SESSION_H
#define SESSION_H


#include "queue.h"

#ifndef NO_SSLTLS
#include <openssl/ssl.h>
#endif


/* IMAP sessions list head. */
XLIST_HEAD(sessionhead, session);

/* IMAP session. */
typedef struct session {
	char *server;		/* Server hostname. */
	char *username;		/* User name. */
	int socket;		/* Socket. */
#ifndef NO_SSLTLS
	SSL *ssl;		/* SSL socket. */
#endif
	unsigned int protocol;	/* IMAP protocol.  Currently IMAP4rev1 and
				 * IMAP4 are supported. */
	unsigned int capabilities;	/* Capabilities of the mail server. */
	struct {		/* Namespace of the mail server's mailboxes. */
		char *prefix;	/* Namespace prefix. */
		char delim;	/* Namespace delimiter. */
	} ns;
	 XLIST_ENTRY(session) links;
} session_t;


/*	session.c	*/
session_t *session_new(void);
void session_init(session_t * ssn);
void session_destroy(session_t * ssn);
void session_free(session_t * ssn);
session_t *session_find(const char *server, const char *user);


#endif				/* SESSION_H */
