#{{{Top of file

import string
import socket
import os
import time
import sys
import getpass
import operator
import signal
import traceback
import codecs
import locale
import SocketWrapper
import pprint
from IMCom import IMCom, errorCodes
from Colors import *

# do idle time in a better spot than at the end of every command.
# like at the command handler.
terminalWidth = 80

#{{{ Utility functions

def mySort(x, y):
    a,b = x
    c,d = y
    return cmp(b,d)


def getColor(fg, bg):
  if bg != "":
    retval = fg[:-1] + ";" + bg[4:]
    return retval
  return fg


def setCIColors(prefs, profile):
    global usercolor, statuscolor, errorcolor, messagebodycolor,\
           timecolor, desccolor, sepcolor, defaultcolor, keycolor
    g = profile.sessioncolors

    backgroundcolor = g["background"]

    usercolor        = getColor(g["user"]       , backgroundcolor)
    statuscolor      = getColor(g["status"]     , backgroundcolor)
    errorcolor       = getColor(g["error"]      , backgroundcolor)
    messagebodycolor = getColor(g["messagebody"], backgroundcolor)
    timecolor        = getColor(g["time"]       , backgroundcolor)
    desccolor        = getColor(g["desc"]       , backgroundcolor)
    sepcolor         = getColor(g["sep"]        , backgroundcolor)
    defaultcolor     = getColor(g["default"]    , backgroundcolor)
    keycolor         = getColor(g["key"]        , backgroundcolor)

def getTerminalWidth():
    terminalWidth = 80 #linelength

def yesnostr( val ):
    if( val ):
        return "yes"
    else:
        return "no"

def truefalsestr( val ):
    if( val ):
        return "true"
    else:
        return "false"

#def logDebug(s):
#    print s #unicode(s.encode('ascii','replace'))

# my field parser..
def listExtend(a, b):
  #print "listExtending a:",a,"b:",b
  if len(b) == 0 or len(b[0]) == 0:
    return
  a.extend(b)

def parseFields(input, numFields):
  input = input.lstrip()
  #print "dealing with: [" + input +"] numFields:", numFields
  try:
    # we've split enough fields, go ahead and return what was given to us.
    if numFields == 1:
      # handle a special case where there is nothing left
      if len(input) == 0:
        return []
      # handle a special case where there are quotes exactly around the edges
      if input[0] == '"' and input[-1] == '"':
        return [input[1:-1]]
      return [input]

    quotePos = input.find('"')
    quotePos2 = input.find('"', quotePos+1)
    spacePos = input.find(' ')

    #print "quotePos:", quotePos, "spacePos:", spacePos

    # there isn't anything left to split by, so just return what we have left.
    if quotePos == -1 and spacePos == -1:
      # handle special case empty string
      if len(input) == 0:
        return []
      return [input]

    # handle the case where there are no quotes.
    if quotePos == -1:
      retval = [input[:spacePos]]
      #retval.extend(parseFields(input[spacePos+1:], numFields -1))
      listExtend(retval, parseFields(input[spacePos+1:], numFields -1))
      return retval

    # handle the case where quotes are further on in the file.
    if quotePos > spacePos:
      retval = [input[:spacePos]]
      #retval.extend(parseFields(input[spacePos+1:], numFields -1))
      listExtend(retval, parseFields(input[spacePos+1:], numFields -1))
      return retval

    # handle the case where there are mismatched quotes
    if quotePos != -1 and quotePos2 == -1:
      print "mismatched quotes."
      return None

    # handle the case where quoted item in the next item
    retval = [input[quotePos+1:quotePos2]]
    #retval.extend(parseFields(input[quotePos2+1:], numFields -1))
    listExtend(retval, parseFields(input[quotePos2+1:], numFields -1))
    return retval
  except:
    return None

#}}}

#{{{ Misc commands (bang, quit logs, last, version, set, setPriority, listProfiles, switchProfile)

def bangCommand(cli, line):
  if(len(line) == 0):
    cli.output("Too few arguments. Usage: " + cli.prefs.getCommand(cli.profile,"bang") +
               " ls ~")
    return
  os.system(line)
  return

def quitCommand(cli, line):
  for key in cli.socketlisteners:
    key.sendData("Server shutting down.\n")
    key.disconnect()
  cli.imcom.disconnect()
  if cli.autostatus != None:
    cli.autostatus.kill()
  cli.running = 0
  cli.handleQuit()
  return

def logsCommand(cli, line):
  params = parseFields(line, 2) #string.split(line, None, 1)
  if(len(params) > 1):
    cli.output("Too many arguments.\nI can take at most one argument - the nick or JID to view logs for" )
    return
  if( len(params) == 1 ):
    messages = cli.loghandler.readLogs( params[0], None,\
                                        None, None, None, 1 )
  else:
    messages = cli.loghandler.readLogs( None, None, None,\
                                        None, None, 1 )
  for x in messages:
    cli.loghandler.displayMessage( x )
  return


def idleCommand(cli, line):
  params = parseFields(line, 2) #string.split(line, None, 1)
  cli.autostatus.setIdleTime( int( params[0] ) )
  cli.autostatus.doAutoStatus()
  return


def lastCommand(cli, line):
  params = parseFields(line,2) #string.split(line, None, 1)
  if len(params) == 0:
    cli.output( cli.colorscheme["sepcolor"] + "You have messaged the following people:" + cli.colorscheme["defaultcolor"] )
    for x in cli.lastToDict.keys():
      cli.output( cli.colorscheme["usercolor"] + cli.getNick( x ) + cli.colorscheme["defaultcolor"] )

    cli.output( cli.colorscheme["sepcolor"] + "The following people have messaged you:" + cli.colorscheme["defaultcolor"] )
    for x in cli.lastFromDict.keys():
      cli.output( cli.colorscheme["usercolor"] + cli.getNick( x ) + cli.colorscheme["defaultcolor"] )
    return

  if len(params) == 2:
    messages = cli.loghandler.readLogs( params[0], -1, -1, None, params[1], 0 )
    for x in messages:
      cli.loghandler.displayMessage( x )
    return

  jidL = cli.getJID( params[0] )
  jid = jidL[0]
  target = params[0]
  if( jid == target ):
    cli.output( cli.colorscheme["desccolor"] + "Note: " + cli.colorscheme["usercolor"] + target + cli.colorscheme["defaultcolor"] + " is not in your roster" )

  if( not cli.lastToDict.has_key( jid ) ):
    cli.output( "You haven't said anything to " + cli.colorscheme["usercolor"] + target + cli.colorscheme["defaultcolor"] )
  else:
    cli.output( cli.colorscheme["usercolor"] + cli.profile.user + "@" + cli.profile.server + cli.colorscheme["defaultcolor"] + " -> " + \
                cli.colorscheme["usercolor"] + target + "\n" + cli.colorscheme["messagebodycolor"] + cli.lastToDict[jid] + cli.colorscheme["defaultcolor"] )

  if( not cli.lastFromDict.has_key( jid ) ):
    cli.output( cli.colorscheme["usercolor"] + target + cli.colorscheme["defaultcolor"] + " hasn't said anything to you" )
  else:
    cli.output( cli.colorscheme["usercolor"] + target + cli.colorscheme["defaultcolor"] + " -> " + cli.colorscheme["usercolor"] + cli.profile.user + "@" + \
                cli.profile.server + "\n" + cli.colorscheme["messagebodycolor"] + cli.lastFromDict[jid] + cli.colorscheme["defaultcolor"] )
  return


def versionCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params)==0):
    cli.output("You are using CLI Version: " + str(cli.VERSION) + " using IMCom library version: " + str(cli.imcom.VERSION))
    cmd = cli.prefs.getCommand(cli.profile,"version")
    cli.output("You can see what others are using by issuing: " + cmd + " [username]")
    cli.output("Example: " + cmd + " airog")
    return
  to = params[0]
  jid,resource = cli.getJID(to)
  if resource == None:
    cli.output(cli.colorscheme["errorcolor"] + "ERROR:" + cli.colorscheme["defaultcolor"] + " A resource is required to send a version request.")
    return
  to = cli.getNick(jid)
  cli.imcom.sendVersionRequest(jid, resource)
  cli.output("Querying " + cli.colorscheme["usercolor"] + to + cli.colorscheme["defaultcolor"] + " about the client version they are using.")
  cli.autostatus.setIdleTime( 0 )
  cli.autostatus.doAutoStatus()
  return


def setpriorityCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params) == 0):
    priority = 0
  else:
    try:
      priority = int(params[0])
      if priority < 6:
        cli.output("Base priority must be a positive integer greater than 5. (6, 8, 49574, etc)")
        return
    except:
      cli.output("Base priority must be a positive integer greater than 5. (6, 8, 49574, etc)")
      return

  cli.profile.priority = priority
  cli.output("Setting base priority to " + cli.colorscheme["statuscolor"] + str(priority) + cli.colorscheme["defaultcolor"])
  if(cli.currentStatus == "online" or cli.currentStatus == "chat"):
    cli.imcom.sendPriority(priority)
  elif(cli.currentStatus == "away"):
    cli.imcom.sendPriority(priority-2)
  elif(cli.currentStatus == "xa"):
    cli.imcom.sendPriority(priority-4)
  elif(cli.currentStatus == "dnd"):
    cli.imcom.sendPriority(priority-6)
  return


def setCommand(cli, line):
  params = parseFields(line, 2) #string.split(line, None, 1)
  if(len(params)<2):
    cli.output("Too few arguments. usage:" + cli.prefs.getCommand(cli.profile,"set") + " statusShow off")
    cli.output("The values are boolean and can be on, off, true, false, yes, no")
    maxwidth = 0
    for x in cli.profile.switches.keys():
      if maxwidth < len( cli.profile.switches[x][1]):
        maxwidth = len( cli.profile.switches[x][1] )
    for x in cli.profile.switches.keys():
      cli.output( cli.colorscheme["keycolor"] + string.ljust( cli.profile.switches[x][1], maxwidth + 3 ) + ": " +
                  cli.colorscheme["desccolor"] + string.ljust(cli.profile.switches[x][0], 6) + cli.colorscheme["defaultcolor"] + ": " +
                  cli.colorscheme["desccolor"] + cli.profile.switches[x][2] + cli.colorscheme["defaultcolor"])
    return

  variable = string.lower(params[0])
  value = string.lower(params[1])
  if variable == "ssl":
    cli.output("I cannot set the SSL value via the UI. Please edit the config file directly. Change the port accordingly and update the SSL flag. Sorry.")
    return

  if(value == "on" or value == "true" or value == "yes"):
    value = 1
  else:
    value = 0

  if( cli.profile.switches.has_key( variable ) ):
    cli.profile.switches[variable] = \
                                   [ truefalsestr( value ),
                                     cli.profile.switches[variable][1],
                                     cli.profile.switches[variable][2] ]
    cli.output( cli.colorscheme["desccolor"] + cli.profile.switches[variable][2] + "   " + cli.colorscheme["statuscolor"] + yesnostr( value ) + cli.colorscheme["defaultcolor"] )
  else:
    cli.output( "Unknown variable " + cli.colorscheme["statuscolor"] + params[0] + cli.colorscheme["defaultcolor"] )
    return

  if(variable == "statusshow"):
    cli.showPresenceUpdates = value
    return
  if(variable == "debug"):
    cli.debug=value
    cli.imcom.setDebug(value)
    return
  if(variable == "colors"):
    if(value):
      cli.setColors()
    else:
      cli.setNoColors()
    return
  if(variable == "ringbell"):
    cli.ringBell = value
    return
  if(variable == "confringbell"):
    cli.confRingBell = value
    return
  if(variable == "nickprompt"):
    cli.useNickAsPrompt = value
    return
  if(variable == "allowinterruptions"):
    cli.allowInterrupt = value
    return
  return


def listprofilesCommand(cli, line):
  keys = cli.prefs.profiles.keys()
  cli.output("You have " + cli.colorscheme["timecolor"] + "%d"%len(keys) + cli.colorscheme["defaultcolor"] + " profiles")
  for item in keys:
    cli.output(cli.prefs.profiles[item].name)
  cli.output("")
  return



def switchprofileCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params) == 0):
    cli.output("Too few arguments. usage:" + cli.prefs.getCommand(cli.profile,"switchprofile") + " jabber.org")
    return
  if(cli.prefs.profiles.has_key(string.strip(params[0]))):
    cli.profile.loadedModules = []
    cli.profile = cli.prefs.profiles[string.strip(params[0])]
    cli.output("Switching to " + line + ", hold on a sec...")
    cli.imcom.disconnect()
    cli.imcom = None
    cli.imcom = IMCom(cli)
    cli.registerCallbacks()
    cli.lastMessaged = None
    cli.lastReceived = None
    cli.threadHash = {}
    result = cli.applyProfileWrapper()
    if result[0] != 0:
      sys.exit(-1)
    cli.applyPrefs(0)
    cli.loghandler.setProfile( cli.profile )
    return
  else:
    cli.output("I couldn't find a profile by the name of " + line)
    return

#}}}

#{{{ Administrative commands (admin, adminWho, changePassword, submitVCard,

def adminCommand(cli, line):
  params = string.split(line, None, 1)
  body = None
  to = None
  if(len(params) != 2):
    cli.output("Incorrect number of arguments. Usage:  " + cli.prefs.getCommand(cli.profile,"admin") +
               " floobin.cx announce/online")
    cli.output(" or floobin.cx annouce/motd")
    return
  to = params[0]
  res = params[1]
  cli.output("Composing a message to users of " + to + " for res: " + res)
  body = cli.getAllText("msg")
  if(body == None or len(body)==0):
    cli.output("Message " + cli.colorscheme["errorcolor"] + "cancelled" + cli.colorscheme["defaultcolor"])
    return
  thread = None
  cli.imcom.sendMessage(to, body, thread, res)
  cli.output("Sent a message to " + cli.colorscheme["usercolor"] + to + cli.colorscheme["defaultcolor"])
  cli.autostatus.setIdleTime( 0 )
  cli.autostatus.doAutoStatus()
  return


def adminwhoCommand(cli, line):
  cli.output("Retrieving the list of all users online.. hold on a sec..")
  body = "<iq type='get' to='"
  body = body + cli.profile.server
  body = body + "'><query xmlns='jabber:iq:admin'><who/></query></iq>"
  cli.imcom.sendPacket(body)
  cli.autostatus.setIdleTime( 0 )
  cli.autostatus.doAutoStatus()
  return

def changepasswordCommand(cli, line):
  params = parseFields(line, 1)
  if len(params) <= 0:
    cmd = cli.prefs.getCommand(cli.profile, "changepassword")
    cli.output("Too few parmeters. Usage: " + cmd + " <newPassword>")
    cli.output("Example " + cmd + " myPantsAreMypAsswoRd")
    return
  cli.imcom.sendChangePassword(params[0])
  cli.output("Attempting to change your password.")
  return


def submitvcardCommand(cli, line):
  params = parseFields(line, 5) #string.split(line, None, 4)
  if(len(params) != 5):
    cli.output("Incorrect number of arguments. Usage: /submitinfo " +
               " Casey Crabb Casey Airog crabbkw@nafai.dyndns.org \n" +
               cli.prefs.getCommand(cli.profile, "submitvcard") + " DisplayName FamilyName GivenName NickName Email")
    return
  fn = params[0]
  f  = params[1]
  g  = params[2]
  n  = params[3]
  e  = params[4]
  cli.output("Submitting your vCard to the server.")
  cli.imcom.sendSetInfo(fn,f,g,n,e)
  return

#}}}

#{{{ old Message Commands

def oldmsgrCommand(cli, line):
    params = string.split(line, None, 1)
    body = None
    to = None
    if(len(params) != 2):
        cli.output("Incorrect number of arguments. Usage: " + cli.prefs.getCommand(cli.profile,"msgr") +
              " airog@floobin.cx the resource I'm at")
        return
    if( cli.profile.switches["statusnag"][0] == "true" ):
        cli.statusNag()
    to = params[0]
    jid,resource = cli.getJID(to)
    res = params[1]
    if(not cli.checkto(jid)):
        cli.output(cli.colorscheme["errorcolor"] + "Error: " + cli.colorscheme["defaultcolor"] +
              "no such user: " + cli.colorscheme["usercolor"] + to + cli.colorscheme["defaultcolor"])
        return
    cli.output("Composing a message to " + cli.colorscheme["usercolor"] + to + cli.colorscheme["defaultcolor"] +
          " on resource: " + cli.colorscheme["keycolor"] + params[1] + cli.colorscheme["defaultcolor"])
    if(cli.useNickAsPrompt):
        body = cli.getAllText(to)
    else:
        body = cli.getAllText( "msg" )
    if(body == None or len(body)==0):
        cli.output("Message " + cli.colorscheme["errorcolor"] + "cancelled" + cli.colorscheme["defaultcolor"])
        return
    thread = None
    if(cli.threadHash.has_key(jid)):
        thread = cli.threadHash[jid]
    else:
        thread = None

    cli.imcom.sendMessage(jid, body, thread, res)
    cli.lastMessaged = jid
    cli.output("Sent a message to " + cli.colorscheme["usercolor"] + to + cli.colorscheme["defaultcolor"])
    cli.logMessage(jid,cli.profile.user+"@"+cli.profile.server,
                    cli.getDate(),cli.getTime(),body)
    cli.autostatus.setIdleTime( 0 )
    cli.autostatus.doAutoStatus()
    return


def oldmsgCommand(cli, line):
    params = string.split(line,None,1)
    body = None
    to = None
    # begin add by ted
    multi_to = None
    multi_message_p = None
    multi_jids = None
    # end add by ted

    if(len(params) == 1):
        if( cli.profile.switches["statusnag"][0] == "true" ):
            cli.statusNag()
        to = params[0]
        # begin add by ted
        multi_to = string.split(to, ',')
        if len(multi_to) <= 1:
            # end add by ted
            jid,resource = cli.getJID(to)
            if(not cli.checkto(jid)):
                cli.output(cli.colorscheme["errorcolor"] + "Error: " + cli.colorscheme["defaultcolor"] +
                      "no such user: " + cli.colorscheme["usercolor"] + to + cli.colorscheme["defaultcolor"])
                return
        cli.output("Composing a message to " + cli.colorscheme["usercolor"] + to + cli.colorscheme["defaultcolor"])
        if(cli.useNickAsPrompt):
            body = cli.getAllText(to)
        else:
            body = cli.getAllText( "msg" )
        if(body == None or len(body)==0):
            cli.output("Message " + cli.colorscheme["errorcolor"] + "cancelled" + cli.colorscheme["defaultcolor"])
            return
    elif(len(params)<2):
        cli.output("Too few arguments. Usage: " + cli.prefs.getCommand(cli.profile,"msg") +
              " airog@floobin.cx hi there!")
        return

    if( cli.profile.switches["statusnag"][0] == "true" ):
        cli.statusNag()
    if(body == None):
        body = params[1]
    to = params[0]

    # begin add by ted
    if (len(params) != 1):
        multi_to = string.split(to, ',')
    multi_message_p =  (len(multi_to) > 1)
    multi_jids = []

    if multi_message_p:
        for to in multi_to:
            if len(to) == 0:
                continue
            jid,resource = cli.getJID(to)
            if (resource != None and resource != ""):
                multi_jids.append(jid + "/" + resource)
            else:
                multi_jids.append(jid)
            to = cli.getNick(jid)

            if (not cli.checkto(jid)):
                cli.output(cli.colorscheme["errorcolor"] + "Error: " + cli.colorscheme["defaultcolor"] +
                           "No such user: " + cli.colorscheme["usercolor"] + to + cli.colorscheme["defaultcolor"])
                return

        # I'm passing the buck on your scary threading.
        thread = None
    else:
        # end add by ted. note: following lines have been indented.
        jid,resource = cli.getJID(to)
        to = cli.getNick(jid)
        if(not cli.checkto(jid)):
            cli.output(cli.colorscheme["errorcolor"] + "Error: " + cli.colorscheme["defaultcolor"] +
                  "No such user: " + cli.colorscheme["usercolor"] + to + cli.colorscheme["defaultcolor"])
            return
        thread = None
        if(cli.threadHash.has_key(jid)):
            thread = cli.threadHash[jid]
        else:
            thread = None
        if(resource != None and resource != ""):
            jid = jid + "/" + resource

    if multi_message_p:
        cli.imcom.sendMultiMessage(multi_jids, body, thread)
        for to in multi_to:
            if(len(to) == 0):
                continue
            cli.output("Sent a message to "+ cli.colorscheme["usercolor"] + to + cli.colorscheme["defaultcolor"])

        cli.logMultiMessage(multi_jids, cli.profile.user +
                            "@" + cli.profile.server,
                            cli.getDate(), cli.getTime(), body)
        cli.autostatus.setIdleTime( 0 )
        cli.autostatus.doAutoStatus()
        return
    else:
        cli.imcom.sendMessage(jid, body, thread)
        cli.lastMessaged = jid
        if(not cli.imcom.conferences.has_key(jid)):
            cli.output("Sent a message to " + cli.colorscheme["usercolor"] + to + cli.colorscheme["defaultcolor"])
        cli.logMessage(jid,cli.profile.user+"@"+cli.profile.server,
                       cli.getDate(),cli.getTime(),body)
        cli.autostatus.setIdleTime( 0 )
        cli.autostatus.doAutoStatus()
        return

def oldreplyCommand(cli, line):
    if(cli.lastMessaged == None):
        cli.output("You have to message somebody first.")
        return
    body = line
    to = cli.lastMessaged
    nick = cli.getNick(to)
    if(len(line) == 0):
        cli.output("Composing a message to " + cli.colorscheme["usercolor"] + nick +
              cli.colorscheme["defaultcolor"])
        if(cli.useNickAsPrompt):
            body = cli.getAllText(nick)
        else:
            body = cli.getAllText("msg")
        if(body == None or len(body)==0):
            cli.output("Message " + cli.colorscheme["errorcolor"] + " cancelled" + cli.colorscheme["defaultcolor"])
            return

    cli.lastMessaged = to

    thread = None
    if(cli.threadHash.has_key(to)):
        thread = cli.threadHash[to]
    else:
        thread = None

    cli.imcom.sendMessage(to, body, thread)
    if(not cli.imcom.conferences.has_key(to)):
        cli.output("Sent a message to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"])
    cli.logMessage(to,cli.profile.user+"@"+cli.profile.server,
                   cli.getDate(),cli.getTime(),body)
    cli.autostatus.setIdleTime( 0 )
    cli.autostatus.doAutoStatus()
    return


def oldrespondCommand(cli, line):
    if(cli.lastReceived == None):
        cli.output("Someone has to message you first.")
        return

    to = cli.lastReceived
    nick = cli.getNick(to)
    body = line
    if(len(line) == 0):
        cli.output("Composing a message to " + cli.colorscheme["usercolor"] + nick +
              cli.colorscheme["defaultcolor"])
        if(cli.useNickAsPrompt):
            body = cli.getAllText(nick)
        else:
            body = cli.getAllText("msg")
        if(body == None or len(body)==0):
            cli.output("Message " + cli.colorscheme["errorcolor"] + " cancelled" + cli.colorscheme["defaultcolor"])
            return
    thread = None
    if(cli.threadHash.has_key(to)):
        thread = cli.threadHash[to]
    else:
        thread = None
    cli.imcom.sendMessage(to, body, thread)
    cli.lastMessaged = to
    cli.output("Sent a message to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"])
    cli.logMessage(to,cli.profile.user+"@"+cli.profile.server,
                   cli.getDate(),cli.getTime(),body)
    cli.autostatus.setIdleTime( 0 )
    cli.autostatus.doAutoStatus()
    return

#}}}

#{{{ Message Commands (msgr, msg, reply, respond)

def msgrCommand(cli, line):
  params = parseFields(line, 2)
  body = None
  if(len(params) != 2):
    cli.output("Too few arguments. Usage: " + cli.prefs.getCommand(cli.profile,"msgr") +
               " airog@floobin.cx the resource I'm at")
    return

  jid, resource = cli.getJID(params[0])
  resource = params[1]
  nick = cli.getNick(jid)

  if(not cli.checkto(jid)):
    cli.output(cli.colorscheme["errorcolor"] + "Error: " + cli.colorscheme["defaultcolor"] + "no such user: " + cli.colorscheme["usercolor"] + params[0] + cli.colorscheme["defaultcolor"])
    return

  if( cli.profile.switches["statusnag"][0] == "true" ):
      cli.statusNag()

  cli.output("Composing a message to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " on resource: " + cli.colorscheme["keycolor"] + resource + cli.colorscheme["defaultcolor"])
  if(cli.useNickAsPrompt):
    body = cli.getAllText(nick)
  else:
    body = cli.getAllText("msg")

  if(body == None or len(body)==0):
    cli.output("Message " + cli.colorscheme["errorcolor"] + "cancelled" + cli.colorscheme["defaultcolor"])
    return

  thread = None
  if(cli.threadHash.has_key(jid)):
    thread = cli.threadHash[jid]
  else:
    thread = None

  cli.imcom.sendMessage(jid, body, thread, resource)
  cli.lastMessaged = jid
  cli.output("Sent a message to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " at " + cli.colorscheme["timecolor"] + cli.getTime() + cli.colorscheme["defaultcolor"])
  cli.logMessage(jid,cli.profile.user+"@"+cli.profile.server, cli.getDate(),cli.getTime(),body)
  return


def msgCommand(cli, line):
  params = parseFields(line, 2)
  body = None

  if(len(params) == 0):
    cli.output("Too few arguments. Usage: " + cli.prefs.getCommand(cli.profile,"msg") + " airog@floobin.cx hi there!")
    return

  jid, resource = cli.getJID(params[0])
  if(not cli.checkto(jid)):
    cli.output(cli.colorscheme["errorcolor"] + "Error: " + cli.colorscheme["defaultcolor"] + "no such user: " + cli.colorscheme["usercolor"] + params[0] + cli.colorscheme["defaultcolor"])
    return
  nick = cli.getNick(jid)

  if( cli.profile.switches["statusnag"][0] == "true" ):
      cli.statusNag()

  if(len(params) == 1):
    #We're a multi-line message mode message.
    cli.output("Composing a message to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " (. to Send, # to cancel)")
    if(cli.useNickAsPrompt):
      body = cli.getAllText(nick)
    else:
      body = cli.getAllText( "msg" )
    if(body == None or len(body)==0):
      cli.output("Message " + cli.colorscheme["errorcolor"] + "cancelled" + cli.colorscheme["defaultcolor"])
      return

  if(len(params) == 2):
    body = params[1]

  thread = None
  if(cli.threadHash.has_key(jid)):
    thread = cli.threadHash[jid]
  else:
    thread = None

  if(resource != None and resource != ""):
    jid = jid + "/" + resource

  cli.lastMessaged = jid
  cli.imcom.sendMessage(jid, body, thread)

  if(not cli.imcom.conferences.has_key(jid)):
    cli.output("Sent a message to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " at " + cli.colorscheme["timecolor"] + cli.getTime() + cli.colorscheme["defaultcolor"])
    cli.logMessage(jid,cli.profile.user+"@"+cli.profile.server, cli.getDate(),cli.getTime(),body)
  return


def msggroupCommand(cli, line):
  params = parseFields(line, 1)
  body = None

  if(len(params) == 0):
    cli.output("Too few arguments. Usage: " + cli.prefs.getCommand(cli.profile,"msggroup") + " mygroup")
    return

  group = params[0]
  if not cli.imcom.grouphash.has_key(group):
    cli.output("You have not defined a group: " + group + ".")
    cli.output("The following is a list of the groups you have defined.")
    for g in cli.imcom.grouphash.keys():
      cli.output(cli.colorscheme["keycolor"] + g + cli.colorscheme["defaultcolor"])
    return

  #We're a multi-line message mode message.
  cli.output("Composing a message to the members of group " + cli.colorscheme["keycolor"] + group + cli.colorscheme["defaultcolor"] + " (. to Send, # to cancel)")
  if(cli.useNickAsPrompt):
    body = cli.getAllText(group)
  else:
    body = cli.getAllText( "msg" )
  if(body == None or len(body)==0):
    cli.output("Message " + cli.colorscheme["errorcolor"] + "cancelled" + cli.colorscheme["defaultcolor"])
    return

  for jid in cli.imcom.grouphash[group]:
    cli.logMessage(jid,cli.profile.user+"@"+cli.profile.server, cli.getDate(),cli.getTime(),body)
    cli.imcom.sendMessage(jid, body, None, None)

  cli.output("Sent a message to the members of group " + cli.colorscheme["keycolor"] + group + cli.colorscheme["defaultcolor"] + " at " + cli.colorscheme["timecolor"] + cli.getTime() + cli.colorscheme["defaultcolor"] + ".")
  return


def replyCommand(cli, line):
  if(cli.lastMessaged == None):
    cli.output("You have to message somebody first.")
    return

  body = line
  to = cli.lastMessaged
  nick = cli.getNick(to)
  if(len(line) == 0):
    cli.output("Composing a message to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " (. to Send, # to cancel)")

    if(cli.useNickAsPrompt):
      body = cli.getAllText(nick)
    else:
      body = cli.getAllText("msg")

    if(body == None or len(body)==0):
      cli.output("Message " + cli.colorscheme["errorcolor"] + " cancelled" + cli.colorscheme["defaultcolor"])
      return

  cli.lastMessaged = to

  thread = None
  if(cli.threadHash.has_key(to)):
    thread = cli.threadHash[to]
  else:
    thread = None

  cli.imcom.sendMessage(to, body, thread)

  if not cli.imcom.conferences.has_key(to):
    cli.output("Sent a message to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " at " + cli.colorscheme["timecolor"] + cli.getTime() + cli.colorscheme["defaultcolor"])
    cli.logMessage(to,cli.profile.user+"@"+cli.profile.server, cli.getDate(),cli.getTime(),body)
  return


def respondCommand(cli, line):
  if(cli.lastReceived == None):
    cli.output("Someone has to message you first.")
    return

  to = cli.lastReceived
  nick = cli.getNick(to)
  body = line
  if(len(line) == 0):
    cli.output("Composing a message to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " (. to Send, # to cancel)")
    if(cli.useNickAsPrompt):
      body = cli.getAllText(nick)
    else:
      body = cli.getAllText("msg")

    if(body == None or len(body)==0):
      cli.output("Message " + cli.colorscheme["errorcolor"] + " cancelled" + cli.colorscheme["defaultcolor"])
      return

  thread = None
  if(cli.threadHash.has_key(to)):
    thread = cli.threadHash[to]
  else:
    thread = None

  cli.imcom.sendMessage(to, body, thread)
  cli.lastMessaged = to
  cli.output("Sent a message to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " at " + cli.colorscheme["timecolor"] + cli.getTime() + cli.colorscheme["defaultcolor"])
  cli.logMessage(to,cli.profile.user+"@"+cli.profile.server, cli.getDate(),cli.getTime(),body)
  return


def msgbangCommand(cli, line):
  params = parseFields(line, 2)
  if len(params) != 2:
    cmd = cli.prefs.getCommand(cli.profile,"msgbang")
    cli.output("Too few arguments. Usage: " + cmd + " [JID] [COMMAND]")
    cli.output("Example: " + cmd + " airog /sbin/ifconfig eth0")
    cli.output("This command is only available on UNIX systems.")
    return

  jid, resource = cli.getJID(params[0])
  cmd = params[1]
  thread = None
  if(cli.threadHash.has_key(jid)):
    thread = cli.threadHash[jid]
  else:
    thread = None

  i,o = os.popen4(cmd)
  msg = o.read()
  o.close()
  i.close()
  cli.imcom.sendMessage(jid, msg, thread, resource)
  cli.lastMessaged = jid
  nick = cli.getNick(jid)
  cli.output("Sent a message to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " at " + cli.colorscheme["timecolor"] + cli.getTime() + cli.colorscheme["defaultcolor"])
  cli.logMessage(jid,cli.profile.user+"@"+cli.profile.server, cli.getDate(),cli.getTime(),msg)
  return

#}}}

#{{{ Roster Management (e, w, add, remove, addGroup, delGroup, setGroup, auth, deny, delete, rename, info, membership)

def eCommand(cli, line):
  cli.printOnlineRoster()
  return

def wCommand(cli, line):
  cli.printRoster()
  return

def addCommand(cli, line):
  params = parseFields(line, 2) #string.split(line, None, 1)
  if(len(params)<2):
    cli.output("Too few arguments. usage: " + cli.prefs.getCommand(cli.profile,"add") + " airog@floobin.cx airog")
    return

  to = params[0]
  nick = params[1]
  if(to[0] == "$" and len(to) == 2):
    n = int(to[1])
    if(len(cli.userQueue)>n):
      to = cli.userQueue[n]

  if(-1 == string.find(to,"@")):
    cli.output(cli.colorscheme["errorcolor"] + "ERROR: " + cli.colorscheme["defaultcolor"] + to + " isn't a fully qualified jabber ID. \nUsage: " +
               cli.prefs.getCommand(cli.profile,"add") + " airog@floobin.cx airog")
    return

  if cli.imcom.nickhash.has_key(nick):
    cli.output(cli.colorscheme["errorcolor"] + "ERROR: " + cli.colorscheme["defaultcolor"] + "can not set nick of " + cli.colorscheme["keycolor"] + to + cli.colorscheme["defaultcolor"] +
               " to '" + cli.colorscheme["keycolor"] + nick + cli.colorscheme["defaultcolor"] + "' because that nickname is already associated with JID: " +
               cli.colorscheme["keycolor"] + cli.imcom.nickhash[nick] + cli.colorscheme["defaultcolor"])
    cli.output("Not sending subscribe request.")
    return
  if nick.find("/") != -1:
    cli.output(cli.colorscheme["errorcolor"] + "ERROR: " + cli.colorscheme["defaultcolor"] + "can not set nick of " + cli.colorscheme["keycolor"] + params[0] + cli.colorscheme["defaultcolor"] +
               " to '" + cli.colorscheme["keycolor"] + name + cli.colorscheme["defaultcolor"] + "' because nicknames CANNOT contain slashes.")
    cli.output("Not sending subscribe request.")
    return

  cli.imcom.sendSubscribe(to)
  cli.imcom.setNick(to, nick)
  cli.output("Sending subscribe request to " + cli.colorscheme["usercolor"] + to + cli.colorscheme["defaultcolor"] + " and renaming to " + cli.colorscheme["usercolor"] + nick +
             cli.colorscheme["defaultcolor"])
  return


def authCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params)==0):
    cli.output("Too few arguments. usage: " + cli.prefs.getCommand(cli.profile,"auth") + " airog@floobin.cx")
    return
  to = params[0]
  jid,resource = cli.getJID(to)
  to = cli.getNick(jid)
  cli.imcom.sendSubscribed(jid)
  cli.output("Authorizing " + cli.colorscheme["usercolor"] + to + cli.colorscheme["defaultcolor"] + " to add you to their roster")
  return

def denyCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params)==0):
    cli.output("Too few arguments. usage: " + cli.prefs.getCommand(cli.profile,"deny") + " airog@floobin.cx")
    return
  to = params[0]
  jid,resource = cli.getJID(to)
  to = cli.getNick(jid)
  cli.imcom.sendUnsubscribed(jid)
  cli.output("Denying " + cli.colorscheme["usercolor"] + to + cli.colorscheme["defaultcolor"] + " to add you to their roster")
  return

def removeCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params)==0):
    cli.output("Too few arguments. usage: " + cli.prefs.getCommand(cli.profile,"remove") + " airog@floobin.cx")
    return
  to = params[0]
  jid,resource = cli.getJID(to)
  if(not cli.checkto(jid)):
    cli.output(cli.colorscheme["errorcolor"] + "Error: " + cli.colorscheme["defaultcolor"] + jid + " is not a proper Jabber ID or not on userlist")
    return
  cli.imcom.sendUnsubscribe(jid)
  cli.output("Attempting to unsubscribe from " + cli.colorscheme["usercolor"] + to + cli.colorscheme["defaultcolor"] + "'s presence")
  return


def renameCommand(cli, line):
  params = parseFields(line, 2)
  if(len(params) != 2):
    cmd = cli.prefs.getCommand(cli.profile, "rename")
    cli.output("Incorrect number of arguments. usage: " + cmd + " <JID> <new nickname>\n" +
               "Example: " + cmd + " airog casey")
    return
  jid,resource = cli.getJID(params[0])
  if(not cli.checkto(jid)):
    cli.output(cli.colorscheme["errorcolor"] + "Error: " + cli.colorscheme["defaultcolor"] +
               jid + " is not a proper Jabber ID or not on userlist")
    return
  name = params[1]
  if cli.imcom.nickhash.has_key(name):
    cli.output(cli.colorscheme["errorcolor"] + "ERROR: " + cli.colorscheme["defaultcolor"] + "can not set nick of " + cli.colorscheme["keycolor"] + params[0] + cli.colorscheme["defaultcolor"] +
               " to '" + cli.colorscheme["keycolor"] + name + cli.colorscheme["defaultcolor"] + "' because that name is already associated with JID: " +
               cli.colorscheme["keycolor"] + cli.imcom.nickhash[name] + cli.colorscheme["defaultcolor"])
    return
  if name.find("/") != -1:
    cli.output(cli.colorscheme["errorcolor"] + "ERROR: " + cli.colorscheme["defaultcolor"] + "can not set nick of " + cli.colorscheme["keycolor"] + params[0] + cli.colorscheme["defaultcolor"] +
               " to '" + cli.colorscheme["keycolor"] + name + cli.colorscheme["defaultcolor"] + "' because nicknames CANNOT contain slashes.")
    return
  cli.output("Attempting to set " + cli.colorscheme["usercolor"] + jid + cli.colorscheme["defaultcolor"] +
             "'s nick to " + cli.colorscheme["usercolor"] + name + cli.colorscheme["defaultcolor"])
  cli.imcom.setNick(jid,name)
  return


def deleteCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params) == 0):
    cli.output("Too few arguments. usage:" + cli.prefs.getCommand(cli.profile,"delete") + " airog")
    cli.output("This command will remove a roster entry, unsubscribing as necessary. " +
               "Use this if you don't want someone in your roster at all and " +
               cli.prefs.getCommand(cli.profile, "remove") + " when you simply want to " +
               "not receive presence updates from someone, but still want a nickname and " +
               "group associated with them.")
    return
  jid,resource = cli.getJID(params[0])

  cli.output("Removing the roster entry for " + cli.colorscheme["usercolor"] + jid + cli.colorscheme["defaultcolor"])
  cli.imcom.removeUser(jid)
  return

def infoCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params) == 0):
    cli.output("Too few arguments. usage:" + cli.prefs.getCommand(cli.profile,"info") + " airog@floobin.cx")
    return
  jid,resource = cli.getJID(params[0])
  if(not cli.checkto(jid)):
    cli.output(cli.colorscheme["errorcolor"] + "Error: " + cli.colorscheme["defaultcolor"] + jid + " is not a proper Jabber ID or not on userlist")
    return
  cli.output("Trying to retrieve information on " + cli.colorscheme["usercolor"] + params[0] + cli.colorscheme["defaultcolor"])
  cli.imcom.sendGetInfo(jid)
  return


def showCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params) == 0):
    cli.output("Too few arguments. usage: " + cli.prefs.getCommand(cli.profile,"show") + " lurker")
    cli.output("The following is a list of groups: ")
    keys = cli.imcom.grouphash.keys()
    for item in keys:
      if(len(cli.imcom.grouphash[item]) > 0):
        cli.output(cli.colorscheme["keycolor"] + item + cli.colorscheme["defaultcolor"])
    return

  if(not cli.imcom.grouphash.has_key(params[0]) or len(cli.imcom.grouphash[params[0]]) <= 0):
    cli.output("There is no one who is a member of group: " + cli.colorscheme["keycolor"] + params[0] + cli.colorscheme["defaultcolor"])
    return

  cli.showGroupMembers(params[0])
  return



def addgroupCommand(cli, line):
  params = parseFields(line, 2) #string.split(line, None, 1)
  if(len(params)<2):
    cli.output("Too few arguments. usage:" + cli.prefs.getCommand(cli.profile,"addgroup") + " airog lurker")
    return

  jid,resource = cli.getJID(params[0])
  if(not cli.checkto(jid)):
    cli.output(cli.colorscheme["errorcolor"] + "Error: " + cli.colorscheme["defaultcolor"] + jid + " is not a proper Jabber ID or not on userlist")
    return

  gname = params[1]
  cli.output("Adding " + cli.colorscheme["usercolor"] + params[0] + cli.colorscheme["defaultcolor"] + " to group " + cli.colorscheme["keycolor"] + gname + cli.colorscheme["defaultcolor"])
  cli.imcom.addGroup(jid,gname)
  return


def setgroupCommand(cli, line):
  params = parseFields(line, 2) #string.split(line, None, 1)
  if(len(params)<2):
    cli.output("Too few arguments. usage:" + cli.prefs.getCommand(cli.profile,"setgroup") + " airog lurker")
    return

  jid,resource = cli.getJID(params[0])
  if(not cli.checkto(jid)):
    cli.output(cli.colorscheme["errorcolor"] + "Error: " + cli.colorscheme["defaultcolor"] + jid + " is not a proper Jabber ID or not on userlist")
    return

  gname = params[1]
  cli.output("Setting " + cli.colorscheme["usercolor"] + params[0] + cli.colorscheme["defaultcolor"] + "'s group to be " + cli.colorscheme["keycolor"] + gname + cli.colorscheme["defaultcolor"])
  cli.imcom.setGroup(jid,gname)
  return


def delgroupCommand(cli, line):
  params = parseFields(line, 2) #string.split(line, None, 1)
  if(len(params)<2):
    cli.output("Too few arguments. usage:" + cli.prefs.getCommand(cli.profile,"delgroup") + " airog lurker")
    return

  jid,resource = cli.getJID(params[0])
  if(not cli.checkto(jid)):
    cli.output(cli.colorscheme["errorcolor"] + "Error: " + cli.colorscheme["defaultcolor"] + jid + " is not a proper Jabber ID or not on userlist")
    return

  gname = params[1]
  cli.output("Removing " + cli.colorscheme["usercolor"] + params[0] + cli.colorscheme["defaultcolor"] + " from group " + cli.colorscheme["keycolor"] + gname + cli.colorscheme["defaultcolor"])
  cli.imcom.removeGroup(jid,gname)
  return


def membershipCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params) == 0):
    cli.output("Too few arguments. usage:" + cli.prefs.getCommand(cli.profile,"membership") + " airog")
    return

  jid,resource = cli.getJID(params[0])
  nick = cli.getNick(jid)
  if(not cli.checkto(jid)):
    cli.output(cli.colorscheme["errorcolor"] + "Error: " + cli.colorscheme["defaultcolor"] + jid + " is not a proper Jabber ID or not on userlist")
    return

  l = cli.imcom.gjidhash[jid]
  cli.output(cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " belongs to the following groups:" + cli.colorscheme["keycolor"])
  for item in l:
    cli.output(item)
  cli.output(cli.colorscheme["defaultcolor"])
  return

#}}}

#{{{ Presence Management (chat, online, away, xa, dnd)

def chatCommand(cli, line):
  cli.handleUserPresenceChange(cli.currentStatus, cli.currentStatusReason, "chat", "")
  cli.currentStatus = "chat"
  cli.currentStatusReason = ""
  cli.imcom.sendChat()
  cli.output("Setting status to " + cli.colorscheme["statuscolor"] + "chat" + cli.colorscheme["defaultcolor"])
  cli.autostatus.statusChange( cli.currentStatus, cli.currentStatusReason )
  cli.autostatus.doAutoStatus()
  return

def onlineCommand(cli, line):
  reason = ""
  params = parseFields(line, 1)
  if(len(params) != 0):
    reason = params[0]
  cli.handleUserPresenceChange(cli.currentStatus, cli.currentStatusReason, "online", reason)
  cli.currentStatus = "online"
  cli.currentStatusReason = reason
  cli.autostatus.statusChange( cli.currentStatus, cli.currentStatusReason )
  cli.output("Setting status to " + cli.colorscheme["statuscolor"] + "online" + cli.colorscheme["defaultcolor"])
  cli.imcom.sendOnline(reason)
  cli.autostatus.doAutoStatus()
  return


def awayCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params) == 0):
    reason = "I'm too lazy to enter why I'm away"
  else:
    reason = params[0]
  cli.handleUserPresenceChange(cli.currentStatus, cli.currentStatusReason, "away", reason)
  cli.currentStatus = "away"
  cli.currentStatusReason = reason
  cli.imcom.sendAway(reason)
  cli.output("Setting status to " + cli.colorscheme["statuscolor"] + "away" + cli.colorscheme["defaultcolor"] + " with reason: " + cli.colorscheme["desccolor"] + reason + cli.colorscheme["defaultcolor"])
  cli.autostatus.statusChange( cli.currentStatus, cli.currentStatusReason )
  cli.autostatus.doAutoStatus()
  return


def xaCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params) == 0):
    reason = "I'm too lazy to enter why I'm xa"
  else:
    reason = params[0]
  cli.handleUserPresenceChange(cli.currentStatus, cli.currentStatusReason, "xa", reason)
  cli.currentStatus = "xa"
  cli.currentStatusReason = reason
  cli.imcom.sendXA(reason)
  cli.output("Setting status to " + cli.colorscheme["statuscolor"] + "xa" + cli.colorscheme["defaultcolor"] + " with reason: " + cli.colorscheme["desccolor"] + reason + cli.colorscheme["defaultcolor"])
  cli.autostatus.statusChange( cli.currentStatus, cli.currentStatusReason )
  cli.autostatus.doAutoStatus()
  return


def dndCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params) == 0):
    reason = "I'm too lazy to enter why I'm dnd"
  else:
    reason = params[0]
  cli.handleUserPresenceChange(cli.currentStatus, cli.currentStatusReason, "dnd", reason)
  cli.currentStatus = "dnd"
  cli.currentStatusReason = reason
  cli.imcom.sendDND(reason)
  cli.output("Setting status to " + cli.colorscheme["statuscolor"] + "dnd" + cli.colorscheme["defaultcolor"] + " with reason: " + cli.colorscheme["desccolor"] + reason + cli.colorscheme["defaultcolor"])
  cli.autostatus.statusChange( cli.currentStatus, cli.currentStatusReason )
  cli.autostatus.doAutoStatus()
  return

#}}}

#{{{ FileTransfer Commands

def sendfileCommand(cli, line):
  params = parseFields(line, 2) #string.split(line, None, 1)
  if(len(params) < 2):
    cli.output("Too few arguments. usage:" + cli.prefs.getCommand(cli.profile,"sendfile") + " airog /home/crabbkw/test.txt")
    return

  jid,res = cli.getJID(params[0])
  fname = params[1]
  if(not os.path.exists(fname) or not os.path.isfile(fname)):
    cli.output(cli.colorscheme["errorcolor"] + "Error: " + cli.colorscheme["defaultcolor"] + "Path doesn't exist: " + fname)
    return

  nick = cli.getNick(jid)
  cli.output("Offering: " + cli.colorscheme["desccolor"] + fname + cli.colorscheme["defaultcolor"] + " to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"])
  cli.imcom.sendFile(jid+"/"+res,fname)
  return


def getfileCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params)<=0):
    cli.output("Too few arguments. Usage: " + cli.prefs.getCommand(cli.profile,"getfile") + " airog")
    return

  jid,resource = cli.getJID(params[0])
  if(not cli.checkto(jid)):
    cli.output(cli.colorscheme["errorcolor"] + "Error: " + cli.colorscheme["defaultcolor"] + jid + " is not a proper Jabber ID or not on userlist")
    return

  nick = cli.getNick(jid)
  if not cli.imcom.filehash.has_key(jid):
    cli.output(params[0] + " has not tried to send you a file. You cannot receive a file not transmitted. " + cli.colorscheme["defaultcolor"])
    return
  file = cli.imcom.filehash[jid][0][0]
  cli.output("Attempting to get " + cli.colorscheme["desccolor"] + str(file) + cli.colorscheme["defaultcolor"] + " from " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"])
  cli.imcom.getFile(jid)
  return

#}}}

#{{{ Agent Commands

def agentsCommand(cli, line):
  cli.output("Requesting the list of transport and agents supported")
  cli.imcom.sendAgentListRequest()
  return



def agenthelpCommand(cli, line):
  if(len(line) == 0):
    cli.output("Too few arguments. Usage: " + cli.prefs.getCommand(cli.profile,"agenthelp") + " icq.jabber.org")
    return
  cli.output("Beginning the registration process. Requesting required information.")
  to = line
  cli.imcom.sendAgentRegHelp(to)
  return


def agentregCommand(cli, line):
  params = string.split(line)
  if(len(params) < 2):
    cli.output("Too few arguments. Usage: " + cli.prefs.getCommand(cli.profile,"agentreg") +
               " icq.jabber.org 1227626 yeah-right nobody")
    return

  to = params[0]
  fields=params[1:]
  cli.imcom.sendAgentRegistration(to,fields)
  return


def interactiveregCommand( cli, line ):
  fields = string.split( line, "<" )
  ffrom = fields.pop(0)

  cli.output( "Now attempting to register you for the " + cli.colorscheme["usercolor"] +  cli.getNick( ffrom ) + cli.colorscheme["defaultcolor"] + " (" + cli.colorscheme["usercolor"] + ffrom + cli.colorscheme["defaultcolor"] +")" )
  cli.gettingCommand = 1
  cli.mode = cli.MULTILINE

  retfields = []
  for i in fields:
    print "\n" + cli.colorscheme["keycolor"] + i + cli.colorscheme["defaultcolor"]
    retfields.append( raw_input("> " ) )

  answer = raw_input( "Send registration request (y/n)? " )

  cli.mode = 0
  cli.gettingCommand = 0

  # show the messages that came in while they were busy
  cli.dumpQueue()
  if( ( answer[0] == "y" ) or ( answer[0] == "Y" ) ):
    cli.imcom.sendAgentRegistration( ffrom, retfields )


def unregisterCommand(cli, line):
  params = parseFields(line, 1)
  if len(params) <= 0:
    cli.output("Too few arguments. Usage: " + cli.prefs.getCommand(cli.profile, "unregister") + " <transport-name>\n" +
               "Example " + cli.prefs.getCommand(cli.profile, "unregister") +
               " aim.floobin.cx\n")
    return
  #if cli.imcom.subscriptions.has_key(line):
  #  if cli.imcom.subscriptions[line] == "from" or cli.imcom.subscriptions[line] == "both":
  cli.imcom.sendAgentUnregistration(params[0] )
  return

#}}}

#{{{ Alias Commands

def aliasCommand(cli, line):
  params = parseFields(line, 2) #string.split(line,None,1)
  if(len(params) != 2):
    cli.output("Too few arguments. Usage: " + cli.prefs.getCommand(cli.profile,"alias") + " <name> <command to issue>\n" +
               "Example " + cli.prefs.getCommand(cli.profile,'alias') + " today ! date\n")
    cli.output("This is the current list of aliases")
    keys = cli.profile.aliases.keys()
    for item in keys:
      cli.output(cli.colorscheme["keycolor"] + item + cli.colorscheme["defaultcolor"] + " : " + cli.colorscheme["desccolor"] + cli.profile.aliases[item] + cli.colorscheme["defaultcolor"])

    return

  cli.output("Setting " +params[0] + " to " + params[1])
  cli.profile.aliases[params[0]]=params[1]
  return



def unaliasCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params) == 0):
    cli.output("Too few arguments. Usage: " + cli.prefs.getCommand(cli.profile,"unalias") + " <aliasname>\n" +
              "Example " + cli.prefs.getCommand(cli.profile,'unalias') + " today\n")
    cli.output("This is the current list of aliases")
    keys = cli.profile.aliases.keys()
    for item in keys:
      cli.output(cli.colorscheme["keycolor"] + item + cli.colorscheme["defaultcolor"] + " : " + cli.colorscheme["desccolor"] + cli.profile.aliases[item] + cli.colorscheme["defaultcolor"])
    return

  if(not cli.profile.aliases.has_key(params[0])):
    cli.output(cli.colorscheme["errorcolor"] + "Error: " + cli.colorscheme["keycolor"] + params[0] + cli.colorscheme["defaultcolor"] + " is not the name of an alias")
    return

  cli.output("Removing alias: " + cli.colorscheme["keycolor"] + params[0] + cli.colorscheme["defaultcolor"])
  del cli.profile.aliases[params[0]]
  return

#}}}

#{{{ Conference Commands

def joinconfCommand(cli, line):
  params = parseFields(line, 4) #string.split(line,None,1)
  if(len(params) < 3):
    cmd = cli.prefs.getCommand(cli.profile,"joinconf")
    cli.output("Too few arguments. Usage: " + cmd +
               " <jid-of-conference> <nickname-to-assign-conference> <your-nickname-in-conf> <optional-password>\n" +
               "Example : " + cmd + " jdev@conference.jabber.org jdev casey\n" +
               "Example2: " + cmd + " otherchannel@conference.jabber.org oc casey confpassword\n")
    cli.output("This is the current list of conferences you are in: ")
    if len(cli.imcom.confnick) > 0:
      for key in cli.imcom.confnick.keys():
        cli.output(cli.colorscheme["keycolor"] + key + cli.colorscheme["defaultcolor"] + " : " + cli.colorscheme["usercolor"] + cli.imcom.confnick[key] + cli.colorscheme["defaultcolor"])
    return

  cli.output("Attemping to join conference: " + cli.colorscheme["usercolor"] + params[0] + cli.colorscheme["defaultcolor"])
  if len(params) == 4:
    cli.imcom.joinConference(params[0], params[1], params[2], params[3])
  else:
    cli.imcom.joinConference(params[0], params[1], params[2], None)
  return


def leaveconfCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params) == 0):
    cli.output("Too few arguments. Usage: " + cli.prefs.getCommand(cli.profile,"leaveconf") +
               " <conference-jid-or-conference-nick>\n" +
               "Example " + cli.prefs.getCommand(cli.profile,'leaveconf') + " jdev@conference.jabber.org\n")
    cli.output("This is the current list of conferences you are in: ")
    if len(cli.imcom.confnick) > 0:
      for key in cli.imcom.confnick.keys():
        cli.output(cli.colorscheme["keycolor"] + key + cli.colorscheme["defaultcolor"] + " : " + cli.colorscheme["usercolor"] + cli.imcom.confnick[key] + cli.colorscheme["defaultcolor"])
    return

  cli.output("attempting to leave conference: " + cli.colorscheme["usercolor"] + params[0] + cli.colorscheme["defaultcolor"])
  cli.imcom.leaveConference(params[0])
  return

def confusersCommand(cli, line):
  params = parseFields(line, 1)
  if(len(params) == 0):
    cli.output("Too few arguments. Usage: " + cli.prefs.getCommand(cli.profile,"confusers") +
               " <conference-jid-or-conference-nick>\n" +
               "Example " + cli.prefs.getCommand(cli.profile,'confusers') + " jdev@conference.jabber.org\n")
    cli.output("This is the current list of conferences you are in: ")
    if len(cli.imcom.confnick) > 0:
      for key in cli.imcom.confnick.keys():
        cli.output(key + " : " + cli.imcom.confnick[key])
    return

  cjid = params[0]
  if(cli.imcom.confnick.has_key(params[0])):
    cjid = cli.imcom.confnick[params[0]]
  if(cli.imcom.conferences.has_key(cjid)):
    # print out the users
    for key in cli.imcom.conferences[cjid][2]:
      stat = cli.imcom.conferences[cjid][2][key][0]
      show = cli.imcom.conferences[cjid][2][key][1]
      aff  = cli.imcom.conferences[cjid][2][key][2]
      role = cli.imcom.conferences[cjid][2][key][3]
      towrite = cli.colorscheme["usercolor"] + key + cli.colorscheme["defaultcolor"] + " is " + cli.colorscheme["statuscolor"] + show + \
                 cli.colorscheme["defaultcolor"] + " as " + cli.colorscheme["desccolor"] + stat + cli.colorscheme["defaultcolor"]
      if aff != None:
        towrite = towrite + " (" + cli.colorscheme["keycolor"] + aff + cli.colorscheme["defaultcolor"] + ") "
      if role != None:
        towrite = towrite + " (" + cli.colorscheme["keycolor"] + role + cli.colorscheme["defaultcolor"] + ") "
      cli.output(towrite)
  else:
    cli.output("You're not a part of conference: " + cjid)
  return

def confnickchangeCommand(cli, line):
  params = parseFields(line, 2)
  if len(params) != 2:
    cmd = cli.prefs.getCommand(cli.profile,"confnickchange")
    cli.output("Too few arguments. Usage: " + cmd + " <conference> <newnick>\n" +
               "Example: " + cmd + " jdev airog")
    return

  cjid = params[0]
  if(cli.imcom.confnick.has_key(params[0])):
    cjid = cli.imcom.confnick[params[0]]

  if not cli.imcom.conferences.has_key(cjid):
    cli.output("You are not in a conference called " + params[0] + ".")
    return

  cli.output("Attempting to change your nickname to " + cli.colorscheme["usercolor"] + params[1] + cli.colorscheme["defaultcolor"])
  cli.imcom.sendConferenceChangeNick(cjid, params[1])
  return


def confinviteCommand(cli, line):
  params = parseFields(line, 2)
  if len(params) != 2:
    cmd = cli.prefs.getCommand(cli.profile, "confinvite")
    cli.output("Too few arguments. Usage: " + cmd + " <conference> <nick>\n" +
               "Example: " + cmd + " jdev airog")
    return

  cjid = params[0]
  if(cli.imcom.confnick.has_key(params[0])):
    cjid = cli.imcom.confnick[params[0]]

  if not cli.imcom.conferences.has_key(cjid):
    cli.output("You are not in a conference called " + params[0] + ".")
    return

  jid,resource = cli.getJID(params[1])
  if resource != None:
    jid = jid + "/" + resource
  cli.output("Sending an invitation to join " + cli.colorscheme["keycolor"] + cjid + cli.colorscheme["defaultcolor"] + " to " + cli.colorscheme["usercolor"] + jid + cli.colorscheme["defaultcolor"])
  cli.imcom.sendConferenceInvite(cjid, jid)


def confsubjectCommand(cli, line):
  params = parseFields(line, 2)
  if len(params) != 2:
    cmd = cli.prefs.getCommand(cli.profile, "confsubject")
    cli.output("Too few arguments. Usage: " + cmd + " <conference> <new subject>\n" +
               "Example: " + cmd + " jdev everything you ever wanted to know about jabber development")
    return

  cjid, resouce = cli.getJID(params[0])

  if not cli.imcom.conferences.has_key(cjid):
    cli.output("You are not in a conference called " + params[0] + ".")
    return

  cli.output("Attempting to change " + cli.colorscheme["keycolor"] + cjid + cli.colorscheme["defaultcolor"] + "'s subject to \"" + cli.colorscheme["desccolor"] +
             params[1] + cli.colorscheme["defaultcolor"] + "\"")
  cli.imcom.sendConferenceChangeSubject(cjid, params[1])

def confkickCommand(cli, line):
  params = parseFields(line, 3)
  if len(params) < 2:
    cmd = cli.prefs.getCommand(cli.profile, "confkick")
    cli.output("Too few arguments. Usage: " + cmd + " <conference> <nick-to-kick> <reason>\n" +
               "Example: " + cmd + " jdev idiot You're a bloody idiot.")
    return

  cjid, resource = cli.getJID(params[0])
  nick = params[1]
  reason = None
  if len(params) == 3:
    reason = params[2]

  cli.output("Attempting to kick " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " out of " + cli.colorscheme["keycolor"] + cjid + cli.colorscheme["defaultcolor"])
  cli.imcom.sendConferenceKickUser(cjid, nick, reason)

def confvoiceCommand(cli, line):
  params = parseFields(line, 2)
  if len(params) < 2:
    cmd = cli.prefs.getCommand(cli.profile, "confvoice")
    cli.output("Too few arguments. Usage: " + cmd + " <conference> <nick-to-voice>\n" +
               "Example: " + cmd + " jdev casey.")
    return

  cjid, resource = cli.getJID(params[0])
  nick = params[1]

  cli.output("Attempting to voice " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " in " + cli.colorscheme["keycolor"] + cjid + cli.colorscheme["defaultcolor"])
  cli.imcom.sendConferenceVoiceUser(cjid, nick)

def confdevoiceCommand(cli, line):
  params = parseFields(line, 3)
  if len(params) < 2:
    cmd = cli.prefs.getCommand(cli.profile, "confdevoice")
    cli.output("Too few arguments. Usage: " + cmd + " <conference> <nick-to-devoice>\n" +
               "Example: " + cmd + " jdev loudmouth")
    return

  cjid, resource = cli.getJID(params[0])
  nick = params[1]

  cli.output("Attempting to revoke the voice priviledges of " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] +
             " in " + cli.colorscheme["keycolor"] + cjid + cli.colorscheme["defaultcolor"])
  cli.imcom.sendConferenceDeVoiceUser(cjid, nick)


def confbanCommand(cli, line):
  params = parseFields(line, 2)
  if len(params) < 2:
    cmd = cli.prefs.getCommand(cli.profile, "confban")
    cli.output("Too few arguments. Usage: " + cmd + " <conference> <nick-to-ban>\n" +
               "Example: " + cmd + " jdev shmuck.")
    return

  cjid, resource = cli.getJID(params[0])
  nick = params[1]

  cli.output("Attempting to ban " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " from " + cli.colorscheme["keycolor"] + cjid + cli.colorscheme["defaultcolor"])
  cli.imcom.sendConferenceBanUser(cjid, nick)

def confmodCommand(cli, line):
  params = parseFields(line, 2)
  if len(params) < 2:
    cmd = cli.prefs.getCommand(cli.profile, "confmod")
    cli.output("Too few arguments. Usage: " + cmd + " <conference> <nick-to-grant-moderator-role>\n" +
               "Example: " + cmd + " jdev casey.")
    return

  cjid, resource = cli.getJID(params[0])
  nick = params[1]

  cli.output("Attempting to grant moderator role to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " in " + cli.colorscheme["keycolor"] + cjid + cli.colorscheme["defaultcolor"])
  cli.imcom.sendConferenceGrantModerator(cjid, nick)

def confdemodCommand(cli, line):
  params = parseFields(line, 2)
  if len(params) < 2:
    cmd = cli.prefs.getCommand(cli.profile, "confdemod")
    cli.output("Too few arguments. Usage: " + cmd + " <conference> <nick-to-revoke-moderator-role>\n" +
               "Example: " + cmd + " jdev casey.")
    return

  cjid, resource = cli.getJID(params[0])
  nick = params[1]

  cli.output("Attempting to revoke moderator role to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " in " + cli.colorscheme["keycolor"] + cjid + cli.colorscheme["defaultcolor"])
  cli.imcom.sendConferenceRevokeModerator(cjid, nick)

def confmemberCommand(cli, line):
  params = parseFields(line, 2)
  if len(params) < 2:
    cmd = cli.prefs.getCommand(cli.profile, "confmember")
    cli.output("Too few arguments. Usage: " + cmd + " <conference> <nick-to-grant-member-affiliation>\n" +
               "Example: " + cmd + " jdev casey.")
    return

  cjid, resource = cli.getJID(params[0])
  nick = params[1]

  cli.output("Attempting to grant member affiliation to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " in " +
             cli.colorscheme["keycolor"] + cjid + cli.colorscheme["defaultcolor"])
  cli.imcom.sendConferenceGrantMember(cjid, nick)

def confdememberCommand(cli, line):
  params = parseFields(line, 2)
  if len(params) < 2:
    cmd = cli.prefs.getCommand(cli.profile, "confdemember")
    cli.output("Too few arguments. Usage: " + cmd + " <conference> <nick-to-revoke-member-affiliation>\n" +
               "Example: " + cmd + " jdev casey.")
    return

  cjid, resource = cli.getJID(params[0])
  nick = params[1]

  cli.output("Attempting to revoke member affiliation to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " in " +
             cli.colorscheme["keycolor"] + cjid + cli.colorscheme["defaultcolor"])
  cli.imcom.sendConferenceRevokeMember(cjid, nick)

def confadminCommand(cli, line):
  params = parseFields(line, 2)
  if len(params) < 2:
    cmd = cli.prefs.getCommand(cli.profile, "confadmin")
    cli.output("Too few arguments. Usage: " + cmd + " <conference> <nick-to-grant-admin-affiliation>\n" +
               "Example: " + cmd + " jdev casey.")
    return

  cjid, resource = cli.getJID(params[0])
  nick = params[1]

  cli.output("Attempting to grant admin affiliation to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " in " +
             cli.colorscheme["keycolor"] + cjid + cli.colorscheme["defaultcolor"])
  cli.imcom.sendConferenceGrantAdmin(cjid, nick)

def confdeadminCommand(cli, line):
  params = parseFields(line, 2)
  if len(params) < 2:
    cmd = cli.prefs.getCommand(cli.profile, "confdeadmin")
    cli.output("Too few arguments. Usage: " + cmd + " <conference> <nick-to-revoke-admin-affiliation>\n" +
               "Example: " + cmd + " jdev casey.")
    return

  cjid, resource = cli.getJID(params[0])
  nick = params[1]

  cli.output("Attempting to revoke admin affiliation from " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " in " +
             cli.colorscheme["keycolor"] + cjid + cli.colorscheme["defaultcolor"])
  cli.imcom.sendConferenceRevokeAdmin(cjid, nick)

def confownerCommand(cli, line):
  params = parseFields(line, 2)
  if len(params) < 2:
    cmd = cli.prefs.getCommand(cli.profile, "confowner")
    cli.output("Too few arguments. Usage: " + cmd + " <conference> <nick-to-grant-owner-affiliation>\n" +
               "Example: " + cmd + " jdev casey.")
    return

  cjid, resource = cli.getJID(params[0])
  nick = params[1]

  cli.output("Attempting to grant owner affiliation to " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " in " +
             cli.colorscheme["keycolor"] + cjid + cli.colorscheme["defaultcolor"])
  cli.imcom.sendConferenceGrantOwner(cjid, nick)

def confdeownerCommand(cli, line):
  params = parseFields(line, 2)
  if len(params) < 2:
    cmd = cli.prefs.getCommand(cli.profile, "confdeowner")
    cli.output("Too few arguments. Usage: " + cmd + " <conference> <nick-to-revoke-owner-affiliation>\n" +
               "Example: " + cmd + " jdev casey.")
    return

  cjid, resource = cli.getJID(params[0])
  nick = params[1]

  cli.output("Attempting to revoke owner affiliation from " + cli.colorscheme["usercolor"] + nick + cli.colorscheme["defaultcolor"] + " in " +
             cli.colorscheme["keycolor"] + cjid + cli.colorscheme["defaultcolor"])
  cli.imcom.sendConferenceRevokeOwner(cjid, nick)

def confdestroyCommand(cli, line):
  params = parseFields(line, 1)
  if len(params) < 1:
    cmd = cli.prefs.getCommand(cli.profile, "confdestroy")
    cli.output("Too few arguments. Usage: " + cmd + " <conference>\n" +
               "Example: " + cmd + " myconference")
    return

  cjid, resource = cli.getJID(params[0])

  cli.output("Attempting to destroy " + cli.colorscheme["keycolor"] + cjid + cli.colorscheme["defaultcolor"])
  cli.imcom.sendConferenceDestroy(cjid)

def confconfigCommand(cli, line):
  params = parseFields(line, 1)
  if len(params) < 1:
    cmd = cli.prefs.getCommand(cli.profile, "confconfig")
    cli.output("Too few arguments. Usage: " + cmd + " <conference>\n" +
               "Example: " + cmd + " myconference")
    return

  cjid, resource = cli.getJID(params[0])

  cli.output("Requesting configuration form for " + cli.colorscheme["keycolor"] + cjid + cli.colorscheme["defaultcolor"])
  cli.imcom.sendConferenceConfigRequest(cjid)

#}}}

def modloadCommand(cli, line):
  params = parseFields(line, 2)
  if(len(params) != 1):
    cmd = cli.prefs.getCommand(cli.profile, "modload")
    cli.output("Too few arguments. Usage: " + cmd + " <module-to-load>\n" + "Example: " + cmd + " examplemodule\n")
    cli.output("The following is a list of modules already loaded.")
    for item in cli.profile.modules.keys():
      cli.output(item)
    return
  cli.output("Attempting to load module: " + params[0])
  try:
    cli.loadModule(params[0])
  except:
    cli.output("Failed to load module: " + params[0])
    if(cli.debug):
      traceback.print_exc()
    return
  cli.output("Success!")

def modunloadCommand(cli, line):
  params = parseFields(line, 2)
  if(len(params) != 1):
    cmd = cli.prefs.getCommand(cli.profile, "modunload")
    cli.output("Too few arguments. Usage: " + cmd + " <module-to-unload>\n" + "Example: " + cmd + " examplemodule\n")
    cli.output("The following is a list of modules already loaded.")
    for item in cli.profile.modules.keys():
      cli.output(item)
    return
  cli.output("Attempting to unload module: " + params[0])
  result = cli.unloadModule(params[0])
  if result == -1:
    cli.output("Failed to unload module: " + params[0])
  else:
    cli.output("Success!")

def modconfigCommand(cli, line):
  params = parseFields(line, 2)
  if(len(params) != 1):
    cmd = cli.prefs.getCommand(cli.profile, "modconfig")
    cli.output("Too few arguments. Usage: " + cmd + " <module-to-config>\n" + "Example: " + cmd + " examplemodule\n")
    cli.output("The following is a list of modules already loaded.")
    for item in cli.profile.modules.keys():
      cli.output(item)
    return

  result = cli.configureModule(params[0])
  if result == -1:
    cli.output("Failed to configure module: " + params[0])
  else:
    cli.output("Success!")

def saveprefsCommand(cli, line):
  cli.output("Saving your preferences to ~/.imcom/imcomrc")
  cli.prefs.writePreferences()
  cli.output("Prefs saved")
  return

def jidlinktestCommand(cli, line):
  params = parseFields(line, 2) #string.split(line,None,1)
  if(len(params) != 1):
    cmd = cli.prefs.getCommand(cli.profile,"jidlinktest")
    cli.output("Too few arguments. Usage: " + cmd + " <user>\n" + "Example: " + cmd + " airog desk\n")
    return
  jid,resource = cli.getJID(line)
  cli.output("Sending JIDLink Test Request to " + cli.colorscheme["usercolor"] + jid + cli.colorscheme["defaultcolor"] + "/" + cli.colorscheme["keycolor"] + resource + cli.colorscheme["defaultcolor"] + ".")
  cli.imcom.sendJIDLinkTestRequest(jid,resource)
  return

def helpCommand(cli, line):
  cli.output(cli.colorscheme["sepcolor"] + "------------------Help-------------------" + cli.colorscheme["defaultcolor"])
  cli.output("The following commands are available: ")
  keys = cli.prefs.commands.helpcommands.keys()
  mxkeylen = 0
  hc = []
  for item in keys:
    if(len(item) > mxkeylen):
      mxkeylen = len(item)
    hc.append((item,cli.prefs.getCommand(cli.profile,item)))
  hc.sort(mySort)
  for item in hc:
    key,value = item
    cli.output(cli.colorscheme["keycolor"] + string.ljust(value,mxkeylen+4) + cli.colorscheme["defaultcolor"] + " : " + cli.colorscheme["desccolor"] +
               cli.prefs.commands.helpcommands[key] + cli.colorscheme["defaultcolor"])
  cli.output("")

  return

#}}}
# end of file.
