import sys
import traceback

class presenceErrorModule:
  def __init__(self, confignode):
    self.errorHosts = []

  def registerCallbacks(self, cli):
    cli.registerCallback("handlePresenceError", cli.PRE, self.myHandlePresenceError)
    cli.registerCallback("handlePresenceUpdate", cli.POST, self.myHandlePresenceUpdate)

  def unRegisterCallbacks(self, cli):
    cli.unRegisterCallback("handlePresenceError", cli.PRE, self.myHandlePresenceError)
    cli.unRegisterCallback("handlePresenceUpdate", cli.POST, self.myHandlePresenceUpdate)

  def getName(self):
    return "presenceErrorModule"

  # You MUST implement a printShortDescription()  it gets called when the module is loaded to print out version/short description/whatever
  def printShortDescription(self):
    print "Presence error redundancy eliminator loaded"

  def getConfigurationString(self, prependString):
    return None

  # You MUST implement a configureModuleCLI(self, cli) function.
  # cli is a reference to a CLI object.
  # No special return value
  # This function is called to give the user an interactive way to configure settings of this module.
  def configureModuleCLI(self, cli):
    print "No configuration required"

  def getHost(self, ffrom):
    host = ffrom
    offset = host.find('@')
    if offset != -1:
      host = host[offset+1:]
    return host

  def myHandlePresenceError(self, cli, ffrom, code, text):
    try:
      #cli.output("in my handle message receive pre")
      host = self.getHost(ffrom)
      if host in self.errorHosts:
        return -1
      self.errorHosts.append(host)
      return None
    except:
      traceback.print_exc()

  def myHandlePresenceUpdate(self, cli, who, show, status, available, resource, duplicate):
    try:
      host = self.getHost(who)
      if host in self.errorHosts:
        self.errorHosts.remove(host)
      return None
    except:
      traceback.print_exc()
