""" Rename wizard implementation

    begin                : Sat Dec 14 2002
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: RenameWiz.py,v 1.7 2004/10/21 02:50:16 niederberger Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__version__ = "$Revision: 1.7 $"

from string import *
import traceback
import os
try:
    from RenameForm import *
#    import Settings
except:
    print "RenameWiz: Unable to import some imgSeek modules. Some features will not work."

class RenameWiz(RenameWizard):
    def tr(self,msg):
        return qApp.translate('main',msg)

    def __init__(self, parent,env):
        RenameWizard.__init__(self,parent)
        self.env = env
        self.curBatch = -1
        self.setFinishEnabled(self.lastpage,1)
        self.helpButton().hide()        #TODO6: show help for this wizard. Until it's not done, just hide the button
        self.curdb = self.env.curdb
        self.flist = []
        try:
            self.bid = self.curdb.batches.keys()[0]
        except:
            traceback.print_exc()
            pass
        self.curdb.cbs["Batch"].append(self.updateDirList)

    def showEvent(self,e):
        self.updateDirList()

    def updateDirList(self,what = None):
        """call it to sync curdb batch list to what the ui shows """
        self.batchcombo.clear()
        for bid in self.curdb.batches.keys():
            self.batchcombo.insertItem(self.curdb.batches[bid][0])
        if self.bid != -1:
            self.showBatch(self.bid)
        else:
            if len(self.curdb.batches.keys()):
                self.showBatch(self.curdb.batches.keys()[0])
            else:
                self.htmlsourcelistbox.clear()

    def showBatch(self,bid):
        txt = self.curdb.BatchToText(bid)
        self.htmlsourcelistbox.clear()
        self.bid = bid
        if not txt:
            self.htmlsourcelistbox.insertItem(self.tr(
                "You should populate this batch with groups/volumes/directories before using it to rename files. Right-click on a directory or volume and select \"Add to batch\""))
            return
        for it in txt:
            self.htmlsourcelistbox.insertItem(it[1]+" - "+it[0])
        # populate file list
        self.flist = []
        self.curdb.crawlBatchForFile(bid,self.flist)
        self.imglistbox.clear()
        for fil in self.flist:
            self.imglistbox.insertItem(fil)

    def RenameWizard_helpClicked(self):
        pass

    def RenameWizard_selected(self,a0):
        if str(a0)==str(self.tr("Rename preview")):
            self.run(preview = 1)

    def batchedbtn_clicked(self):
        wnd = self.parent()
        wnd.editcategaction_activated()

    def batchcombo_activated(self,a0):
        try:
            bid = self.curdb.batches.keys()[a0]
        except:
            print "key Error showing desired batch"
            return
        self.showBatch(bid)

    def run(self,preview = 0):
        """perform or preview changes

        @param preview: if true, only show changes
        @type preview: int
        """
        renpairs = {}                     # dict. key is old fname value is new fname
        cnt = 0
        seriesw = str(len(str(len(self.flist)))) # width of series numbering needed (as a string)
        serformat = "%0"+seriesw+"d"
        for fname in self.flist:
            sfname = os.path.split(fname)[-1] # filename
            pfname = fname[:-len(sfname)] # filepath prefix
            extp = find(sfname,".")
            if extp != -1:
                ext = sfname[extp:]
                sfname = sfname[:extp]
            else:
                ext = ""
            if self.replacecheck.isChecked():
                nsfname = replace(sfname,str(self.replacesrcedit.text()),str(self.replacedstedit.text()))
                if  nsfname+ext != sfname+ext:
                    renpairs[fname] = pfname+nsfname+ext
            if self.appendcheck.isChecked():
                nsfname = sfname+str(self.appendedit.text())
                if  nsfname+ext != sfname+ext:
                    renpairs[fname] = pfname+nsfname+ext
            if self.prependcheck.isChecked():
                nsfname = str(self.prependedit.text())+sfname
                if  nsfname+ext != sfname+ext:
                    renpairs[fname] = pfname+nsfname+ext
            if self.uppercheck.isChecked():
                nsfname = upper(sfname)
                if  nsfname+ext != sfname+ext:
                    renpairs[fname] = pfname+nsfname+ext
            if self.lowercheck.isChecked():
                nsfname = lower(sfname)
                if  nsfname+ext != sfname+ext:
                    renpairs[fname] = pfname+nsfname+ext
            if self.seriescheck.isChecked():
               base = str(self.seriesedit.text())
               renpairs[fname] = pfname+base+ serformat%cnt+ext
               cnt = cnt+1
        if preview:
            self.previewtable.setNumRows(len(renpairs))
            a = 0
            for pair in renpairs:
                self.previewtable.setText(a,0,pair)
                self.previewtable.setText(a,1,os.path.split(renpairs[pair])[-1])
                a = a+1
        else:
            for pair in renpairs:
                try:
                    os.rename(pair,renpairs[pair])
                except:
                    traceback.print_exc()
            self.curdb.renameFiles(renpairs)
            QMessageBox.information( None, "imgSeek",str(self.tr("%d image(s) renamed. "))%len(renpairs))

    def applybtn_clicked(self):
        self.run()

    def prependcheck_toggled(self,a0):
        self.prependedit.setEnabled(a0)

    def appendcheck_toggled(self,a0):
        self.appendedit.setEnabled(a0)
##    def uppercheck_toggled(self,a0):
##        if a0 and self.lowercheck.isChecked(): self.lowercheck.setChecked(0)
##    def lowercheck_toggled(self,a0):
##        if a0 and self.uppercheck.isChecked(): self.uppercheck.setChecked(0)

    def replacecheck_toggled(self,a0):
        self.replacesrcedit.setEnabled(a0)
        self.replacedstedit.setEnabled(a0)

    def seriescheck_toggled(self,a0):
        self.seriesedit.setEnabled(a0)
