<?php
/*
 * $Horde: imp/filters.php,v 2.30.2.12 2005/01/03 11:25:46 jan Exp $
 *
 * Copyright 2000-2005 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 2000-2005 Max Kalika <max@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';

/* redirect back to the options screen if folder or filter use is not allowed */
if (!$conf['user']['allow_folders'] || $prefs->isLocked('filters')) {
    header('Location: ' . Horde::applicationUrl('prefs.php', true));
    exit;
}

IMP::checkAuthentication(OP_HALFOPEN);

/* Start to compress pages if requested. */
if ($conf['compress_pages']) {
    ob_start('ob_gzhandler');
}

$preamble = IMP::preambleString();
$errormsg = '';
$actionID = Horde::getFormData('actionID');

/* Run through the action handlers */
if (isset($actionID)) {
    switch ($actionID) {

    case FILTER_CREATE:
        $fields = Horde::getFormData('fields');
        if (is_array($fields) && Horde::getFormData('text') && Horde::getFormData('action') && !preg_match('/^\s*$/', Horde::getFormData('text'))) {
            $filters = @unserialize($prefs->getValue('filters'));
            if (Horde::getFormData('action') == 'delete') {
                $filters[] = array('fields' => Horde::getFormData('fields'), 'text' => chop(trim(Horde::getFormData('text'))), 'action' => 'delete');
            } elseif (Horde::getFormData('action') == 'move' && Horde::getFormData('folder')) {
                $filters[] = array('fields' => Horde::getFormData('fields'), 'text' => chop(trim(Horde::getFormData('text'))), 'action' => 'move', 'folder' => Horde::getFormData('folder'));
            } else {
                Horde::raiseMessage(_("no folder selected"), HORDE_ERROR);
                $errorRaised = true;
            }

            $prefs->setValue('filters', serialize($filters));
            $prefs->store();
        }
        else {
            Horde::raiseMessage(_("please fill in the text and choose a field and an action"), HORDE_ERROR);
            $errorRaised = true;
        }
        break;

    case FILTER_MODIFY:
        $fields = Horde::getFormData('fields');
        if (Horde::getFormData('number', -1) != -1) {
            if (Horde::getFormData('text') && !preg_match('/^\s*$/', Horde::getFormData('text'))) {
                $filters = @unserialize($prefs->getValue('filters'));
                if (Horde::getFormData('action') == 'delete') {
                    $filters[Horde::getFormData('number')] = array('fields' => Horde::getFormData('fields'), 'text' => chop(trim(Horde::getFormData('text'))), 'action' => 'delete');
                } elseif (Horde::getFormData('action') == 'move' && Horde::getFormData('folder')) {
                    $filters[Horde::getFormData('number')] = array('fields' => Horde::getFormData('fields'), 'text' => chop(trim(Horde::getFormData('text'))), 'action' => 'move', 'folder' => Horde::getFormData('folder'));
                } else {
                    Horde::raiseMessage(_("no folder selected"), HORDE_ERROR);
                    $errorRaised = true;
                }

                $prefs->setValue('filters', serialize($filters));
                $prefs->store();
            } else {
                Horde::raiseMessage(_("no text specified"), HORDE_ERROR);
                $errorRaised = true;
            }
        } else {
            Horde::raiseMessage(_("no rule selected"), HORDE_ERROR);
        }
        break;

    case FILTER_DELETE:
        if (Horde::getFormData('number', -1) != -1) {
            $filters = @unserialize($prefs->getValue('filters'));
            array_splice($filters, Horde::getFormData('number'), 1);
            $prefs->setValue('filters', serialize($filters));
            $prefs->store();
        } else {
            Horde::raiseMessage(_("no rule selected"), HORDE_ERROR);
        }
        break;

    case FILTER_DOWN:
        if (Horde::getFormData('number', -1) != -1) {
            $filters = @unserialize($prefs->getValue('filters'));
            if (Horde::getFormData('number') < count($filters) - 1) {
                $tmpFilter = array_splice($filters, Horde::getFormData('number'), 1);
                array_splice($filters, Horde::getFormData('number') + 1, 0, $tmpFilter);
                $prefs->setValue('filters', serialize($filters));
                $prefs->store();
            } else {
                Horde::raiseMessage(_("cannot move past the end"), HORDE_WARNING);
                $errorRaised = true;
            }
        } else {
            Horde::raiseMessage(_("no rule selected"), HORDE_ERROR);
        }
        break;

    case FILTER_UP:
        if (Horde::getFormData('number', -1) != -1) {
            $filters = @unserialize($prefs->getValue('filters'));
            if (Horde::getFormData('number')) {
                $tmpFilter = array_splice($filters, Horde::getFormData('number'), 1);
                array_splice($filters, Horde::getFormData('number') - 1, 0, $tmpFilter);
                $prefs->setValue('filters', serialize($filters));
                $prefs->store();
            } else {
                Horde::raiseMessage(_("cannot move past the beginning"), HORDE_WARNING);
                $errorRaised = true;
            }
        } else {
            Horde::raiseMessage(_("no rule selected"), HORDE_ERROR);
        }
        break;

    }
}

$title = _("Mail Filters");
$js_onLoad = null;
require IMP_TEMPLATES . '/common-header.inc';
require IMP_BASE . '/menu.php';
require IMP_BASE . '/status.php';

$filters = @unserialize($prefs->getValue('filters'));

$filterLabels = array('to'      => _("To:"),
                      'cc'      => _("Cc:"),
                      'from'    => _("From:"),
                      'subject' => _("Subject:"),
                      'body'    => _("Body"));

$fieldsDisplay = array();
for ($i = 0; $i < count($filters); $i++) {
    $fieldsDisplay[$i] = '';
    for ($j = 0; $j < count($filters[$i]['fields']); $j++) {
        $fieldsDisplay[$i] .= ' <b>' . $filterLabels[$filters[$i]['fields'][$j]] . '</b> ';
        if ($j < count($filters[$i]['fields']) - 1) {
            $fieldsDisplay[$i] .= _("or");
        }
    }
}

$apply_js = 'window.location = \'' . Horde::url('mailbox.php?actionID=' . FILTER, true) . '\';';
if (count(IMP::flist(array('INBOX')))) {
    $options = IMP::flistSelect(_("select folder"), true, array('INBOX'));
}

$fieldsList['to'] = 0;
$fieldsList['cc'] = 1;
$fieldsList['from'] = 2;
$fieldsList['subject'] = 3;
$fieldsList['body'] = 4;

$actionsList['delete'] = 0;
$actionsList['move'] = 1;

require IMP_TEMPLATES . '/filters/javascript.inc';
require IMP_TEMPLATES . '/filters/list.inc';
require IMP_TEMPLATES . '/filters/manage.inc';

$registry->shutdown();

require IMP_TEMPLATES . '/common-footer.inc';

$prefs->store();

?>
