<?php
/*
 * $Horde: imp/prefs.php,v 2.146.2.25 2005/01/03 11:25:48 jan Exp $
 *
 * Copyright 1999-2005 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2005 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */


/**
 * Encapsulate the logic saying whether or not a preferences group is
 * editable.
 */
function groupIsEditable($group)
{
    global $prefs, $prefGroups;
    static $results;

    if (!isset($results)) $results = array();

    if (!isset($results[$group])) {
        if ($group == 'filters') {
            global $conf;
            if ($conf['prefs']['driver'] == '' ||
                $conf['prefs']['driver'] == 'none' ||
                $prefs->isLocked('filters')) {
                $results[$group] = false;
                return false;
            }
        }

        $results[$group] = false;
        foreach ($prefGroups[$group]['members'] as $pref) {
            if (!$prefs->isLocked($pref)) {
                $results[$group] = true;
                return true;
            }
        }
    } else {
        return $results[$group];
    }

    return false;
}


define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';
require IMP_BASE . '/config/servers.php';
require IMP_BASE . '/config/prefs.php';


IMP::checkAuthentication(OP_HALFOPEN);

/* See if we have a preferences group set. */
$group = Horde::getFormData('group');

/* Run through the action handlers */
$actionID = Horde::getFormData('actionID', NO_ACTION);
switch ($actionID) {

 case NO_ACTION:
     break;

 case UPDATE_PREFS:
     if (isset($group) && groupIsEditable($group)) {
         $updated = false;

         foreach ($prefGroups[$group]['members'] as $pref) {
             if (!$prefs->isLocked($pref) ||
                 $_prefs[$pref]['type'] == 'special') {
                 switch ($_prefs[$pref]['type']) {

                     // These either aren't set or are set in other parts
                     // of the UI.
                 case 'implicit':
                 case 'link':
                     break;

                 case 'select':
                 case 'text':
                 case 'textarea':
                     $prefs->setValue($pref, Horde::getFormData($pref));
                     $updated = true;
                     break;

                 case 'enum':
                     $val = Horde::getFormData($pref);
                     if (isset($_prefs[$pref]['enum'][$val])) {
                         $prefs->setValue($pref, $val);
                         $updated = true;
                     } else {
                         Horde::raiseMessage(_("An illegal value was specified."), HORDE_ERROR);
                     }
                     break;

                 case 'number':
                     $num = Horde::getFormData($pref);
                     if (intval($num) != $num) {
                         Horde::raiseMessage(_("This value must be a number."), HORDE_ERROR);
                     } elseif ($num == 0) {
                         Horde::raiseMessage(_("This number must be at least one."), HORDE_ERROR);
                     } else {
                         $prefs->setValue($pref, $num);
                         $updated = true;
                     }
                     break;

                 case 'checkbox':
                     $val = Horde::getFormData($pref);
                     $prefs->setValue($pref, isset($val) ? 1 : 0);
                     $updated = true;
                     break;

                 case 'special':
                     // Code for special elements must be written
                     // specifically for each application.
                     switch ($pref) {
                     case 'folderselect':
                         if ($conf['user']['allow_folders']) {
                             $drafts_folder = Horde::getFormData('drafts');
                             $drafts_new = Horde::getFormData('drafts_new');
                             if (isset($drafts_folder) && !$prefs->isLocked('drafts_folder')) {
                                 if (empty($drafts_folder) && !empty($drafts_new)) {
                                     $drafts_folder = $drafts_new;
                                     include_once IMP_BASE . '/lib/Folder.php';
                                     IMP_Folder::create($imp['stream'], IMP::preambleString() . $drafts_folder, $prefs->getValue('subscribe'));
                                     unset($imp['imaptree']);
                                 } elseif (substr($drafts_folder, 0, strlen(IMP::preambleString())) == IMP::preambleString()) {
                                     $drafts_folder = substr($drafts_folder, strlen(IMP::preambleString()));
                                 }
                                 if (!empty($drafts_folder)) {
                                     $prefs->setValue('drafts_folder', $drafts_folder);
                                     $updated = true;
                                 }
                             }
                         }
                         break;

                     case 'trashselect':
                         if ($conf['user']['allow_folders']) {
                             $trash_folder = Horde::getFormData('trash');
                             $trash_new = Horde::getFormData('trash_new');
                             if (isset($trash_folder) && !$prefs->isLocked('trash_folder')) {
                                 if (empty($trash_folder) && !empty($trash_new)) {
                                     $trash_folder = IMP::preambleString() . $trash_new;
                                     include_once IMP_BASE . '/lib/Folder.php';
                                     IMP_Folder::create($imp['stream'], $trash_folder, $prefs->getValue('subscribe'));
                                     unset($imp['imaptree']);
                                 } elseif (substr($trash_folder, 0, strlen(IMP::preambleString())) == IMP::preambleString()) {
                                     $trash_folder = substr($trash_folder, strlen(IMP::preambleString()));
                                 }
                                 if (!empty($trash_folder)) {
                                     $prefs->setValue('trash_folder', $trash_folder);
                                     $updated = true;
                                 }
                             }
                         }
                         break;

                     case 'sourceselect':
                         $search_sources = Horde::getFormData('search_sources');
                         if (!is_null($search_sources)) {
                             $prefs->setValue('search_sources', $search_sources);
                             $updated = true;
                         }

                         $search_fields_string = Horde::getFormData('search_fields_string');
                         if (!is_null($search_fields_string)) {
                             $prefs->setValue('search_fields', $search_fields_string);
                             $updated = true;
                         }

                         $add_source = Horde::getFormData('add_source');
                         if (!is_null($add_source)) {
                             $prefs->setValue('add_source', $add_source);
                             $updated = true;
                         }
                         break;

                     case 'identityselect':
                         $default_identity = Horde::getFormData('default_identity');
                         if (!is_null($default_identity)) {
                             $identities = @unserialize($prefs->getValue('identities'));
                             if ($identities && count($identities) > 0 && isset($identities[$default_identity])) {
                                 if (!isset($prefs->prefs['default_identity'])) {
                                     $acl = 0;
                                     if ($prefs->isLocked('identities')) {
                                         $acl |= _PREF_LOCKED;
                                     }
                                     if ($prefs->isShared('identities')) {
                                         $acl |= _PREF_SHARED;
                                     }
                                     $prefs->add('default_identity', '', $acl);
                                 }
                                 $prefs->setValue('default_identity', $default_identity);
                                 if (!$prefs->isLocked('fullname')) {
                                     $prefs->setValue('fullname', $identities[$default_identity]['fullname']);
                                 }
                                 if (!$prefs->isLocked('from_addr')) {
                                     $prefs->setValue('from_addr', $identities[$default_identity]['from_addr']);
                                 }
                                 if (!$prefs->isLocked('replyto_addr')) {
                                     $prefs->setValue('replyto_addr', $identities[$default_identity]['replyto_addr']);
                                 }
                                 if (!$prefs->isLocked('signature')) {
                                     $prefs->setValue('signature', $identities[$default_identity]['signature']);
                                 }
                                 if (!$prefs->isLocked('sig_dashes')) {
                                     $prefs->setValue('sig_dashes', $identities[$default_identity]['sig_dashes']);
                                 }
                                 if (!$prefs->isLocked('sig_first')) {
                                     $prefs->setValue('sig_first', $identities[$default_identity]['sig_first']);
                                 }
                                 $updated = true;
                             }
                         }
                         break;

                     case 'initialpageselect':
                         $initial_page = Horde::getFormData('initial_page');
                         if ($initial_page != 'folders.php' &&
                             substr($initial_page, 0, strlen(IMP::preambleString())) == IMP::preambleString()) {
                             $initial_page = substr($initial_page, strlen(IMP::preambleString()));
                         }
                         $prefs->setValue('initial_page', $initial_page);
                         $updated = true;
                         break;

                     }
                     break;

                 }
             }
         }

         // Do anything that you need to do as a result of certain
         // preferences changing.
         if ($prefs->isDirty('language')) {
             Lang::setLang($prefs->getValue('language'));
             Lang::setDomain('imp', IMP_BASE . '/locale', $registry->getCharset());
             include IMP_BASE . '/config/prefs.php';
         }
         if ($prefs->isDirty('subscribe')) {
             if (isset($imp['imaptree'])) unset($imp['imaptree']);
         }

         if ($updated) {
             $prefs->store();
             Horde::raiseMessage(_("Your options have been updated."), HORDE_MESSAGE);
             $group = null;
         }
     }

     break;
}

/*
 * Assign variables to hold select lists
 */
if (!$prefs->isLocked('language')) {
    $language_options = &$nls['languages'];
}

if (!$prefs->isLocked('timezone')) {
    $timezone_options = &$tz;
}

/*
 * Import select lists from maintenance operations
 */
require_once IMP_BASE . '/lib/Maintenance/imp.php';
$maint = new Maintenance_IMP();
foreach (($maint->exportIntervalPrefs()) as $val) {
    $$val = &$intervals;
}

if ($conf['compress_pages']) {
    ob_start('ob_gzhandler');
}

$title = _("User Options");
$js_onLoad = null;
require IMP_TEMPLATES . '/common-header.inc';
require IMP_BASE . '/menu.php';
require IMP_BASE . '/status.php';

if (!empty($group) &&
    groupIsEditable($group)) {
    include $registry->getTemplatePath('horde') . '/prefs/begin.inc';
    foreach ($prefGroups[$group]['members'] as $pref) {
        if (!$prefs->isLocked($pref)) {
            switch ($_prefs[$pref]['type']) {
            case 'implicit':
                break;

            case 'special':
                include IMP_TEMPLATES . "/prefs/$pref.inc";
                break;

            default:
                include $registry->getTemplatePath('horde') . '/prefs/' . $_prefs[$pref]['type'] . '.inc';
                break;
            }
        }
    }
    include $registry->getTemplatePath('horde') . '/prefs/end.inc';
} else {
    foreach ($prefGroups as $group => $gvals) {
        $col = $gvals['column'];
        unset($gvals['column']);
        $columns[$col][$group] = $gvals;
    }
    $span = round(100 / count($columns));
    include $registry->getTemplatePath('horde') . '/prefs/overview.inc';
}

$registry->shutdown();
require IMP_TEMPLATES . '/common-footer.inc';

imap_errors();
